/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import java.util.AbstractList;
import java.util.List;

final class TruffleList<T>
extends AbstractList<T> {
    private final TruffleObject array;
    private final TypeAndClass<T> type;

    private TruffleList(TypeAndClass<T> elementType, TruffleObject array) {
        this.array = array;
        this.type = elementType;
    }

    public static <T> List<T> create(TypeAndClass<T> elementType, TruffleObject array) {
        return new TruffleList<T>(elementType, array);
    }

    @Override
    public T get(int index) {
        try {
            Object item = ToJavaNode.message(this.type, Message.READ, this.array, index);
            Object javaItem = ToJavaNode.toJava(item, this.type);
            return this.type.cast(javaItem);
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public T set(int index, T element) {
        this.type.cast(element);
        T prev = this.get(index);
        try {
            ToJavaNode.message(null, Message.WRITE, this.array, index, element);
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
        return prev;
    }

    @Override
    public int size() {
        try {
            return (Integer)ToJavaNode.message(null, Message.GET_SIZE, this.array, new Object[0]);
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }
}

