/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;

public class CallPrimitiveNode
extends RubyNode {
    @Node.Child
    private RubyNode primitive;
    @Node.Child
    private RubyNode fallback;
    private final ConditionProfile successProfile = ConditionProfile.createBinaryProfile();

    public CallPrimitiveNode(RubyNode primitive, RubyNode fallback) {
        this.primitive = primitive;
        this.fallback = fallback;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.primitive.execute(frame);
        if (this.successProfile.profile(value != null)) {
            return value;
        }
        return this.fallback.execute(frame);
    }
}

