/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@ImportStatic(value={ShapeCachingGuards.class})
@NodeChild(value="object", type=RubyNode.class)
public abstract class MetaClassNode
extends RubyNode {
    public static MetaClassNode create() {
        return MetaClassNodeGen.create(null);
    }

    public abstract DynamicObject executeMetaClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject metaClassTrue(boolean value) {
        return this.coreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject metaClassFalse(boolean value) {
        return this.coreLibrary().getFalseClass();
    }

    @Specialization
    protected DynamicObject metaClassInt(int value) {
        return this.coreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject metaClassLong(long value) {
        return this.coreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject metaClassDouble(double value) {
        return this.coreLibrary().getFloatClass();
    }

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected DynamicObject metaClassCached(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="getMetaClass(cachedShape)") DynamicObject metaClass) {
        return metaClass;
    }

    @Specialization(guards={"updateShape(object)"})
    protected DynamicObject updateShapeAndMetaClass(DynamicObject object) {
        return this.executeMetaClass(object);
    }

    @Specialization(contains={"metaClassCached", "updateShapeAndMetaClass"})
    protected DynamicObject metaClassUncached(DynamicObject object) {
        return Layouts.BASIC_OBJECT.getMetaClass(object);
    }

    @Fallback
    protected DynamicObject metaClassFallback(Object object) {
        return this.getContext().getCoreLibrary().getMetaClass(object);
    }

    protected static DynamicObject getMetaClass(Shape shape) {
        return Layouts.BASIC_OBJECT.getMetaClass(shape.getObjectType());
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CLASS_CACHE;
    }
}

