/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.SafepointAction;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.tools.simpleshell.SimpleShell;

public class InstrumentationServerManager {
    private final RubyContext context;
    private final HttpServer server;
    private volatile boolean shuttingDown = false;

    public InstrumentationServerManager(RubyContext context, int port) {
        this.context = context;
        InetAddress host = InetAddress.getLoopbackAddress();
        HttpServer server = null;
        try {
            server = HttpServer.create(new InetSocketAddress(host, port), 0);
        }
        catch (BindException e) {
            System.err.println("Port " + port + " was already in use: " + e);
            throw new JavaException(e);
        }
        catch (IOException e) {
            throw new JavaException(e);
        }
        this.server = server;
    }

    public void start() {
        this.server.createContext("/stacks", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) {
                try {
                    final StringBuilder builder = new StringBuilder();
                    InstrumentationServerManager.this.context.getSafepointManager().pauseAllThreadsAndExecuteFromNonRubyThread(false, new SafepointAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(DynamicObject thread, Node currentNode) {
                            1 var3_3 = this;
                            synchronized (var3_3) {
                                try {
                                    Backtrace backtrace = InstrumentationServerManager.this.context.getCallStack().getBacktrace(null);
                                    List<String> lines = BacktraceFormatter.createDefaultFormatter(InstrumentationServerManager.this.context).formatBacktrace(InstrumentationServerManager.this.context, null, backtrace);
                                    builder.append(StringUtils.format("#%d %s", Thread.currentThread().getId(), Thread.currentThread().getName()));
                                    builder.append("\n");
                                    for (String line : lines) {
                                        builder.append(line);
                                        builder.append("\n");
                                    }
                                    builder.append("\n");
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    byte[] bytes = builder.toString().getBytes("UTF-8");
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, bytes.length);
                    OutputStream stream = httpExchange.getResponseBody();
                    stream.write(bytes);
                    stream.close();
                }
                catch (IOException e) {
                    if (InstrumentationServerManager.this.shuttingDown) {
                        return;
                    }
                    e.printStackTrace();
                }
            }
        });
        this.server.createContext("/break", httpExchange -> {
            try {
                Thread mainThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(this.context.getThreadManager().getRootThread()).getCurrentFiber());
                this.context.getSafepointManager().pauseThreadAndExecuteLaterFromNonRubyThread(mainThread, (thread, currentNode) -> new SimpleShell(this.context).run(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), (Node)currentNode));
                httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                httpExchange.sendResponseHeaders(200, 0L);
                httpExchange.getResponseBody().close();
            }
            catch (IOException e) {
                if (this.shuttingDown) {
                    return;
                }
                e.printStackTrace();
            }
        });
        this.server.start();
    }

    public void shutdown() {
        if (this.server != null) {
            this.shuttingDown = true;
            this.server.stop(1);
        }
    }
}

