/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import com.dickimawbooks.texosquery.FileSortComparator;
import com.dickimawbooks.texosquery.FileSortType;
import com.dickimawbooks.texosquery.FileWalkVisitor;
import com.dickimawbooks.texosquery.TeXOSQuery;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class TeXOSQueryJRE8
extends TeXOSQuery {
    public TeXOSQueryJRE8() {
        super("texosquery-jre8");
    }

    @Override
    public char openinFallbackValue() {
        return 'p';
    }

    @Override
    protected File checkDirectoryListing(File file) throws IOException {
        if ((file = file.getCanonicalFile()).getParentFile() == null) {
            throw new IOException(String.format("Listing on root directory not permitted: %s", file));
        }
        File file2 = new File(this.getSystemProperty("user.dir", "."));
        if (!file2.equals(file) && !this.isFileInTree(file, file2)) {
            throw new IOException(String.format("Listing outside cwd path not permitted: %s", file));
        }
        return file;
    }

    @Override
    public String walk(String string, String string2, File file, FileSortType fileSortType) {
        try {
            return FileWalkVisitor.walk(this, string, string2, file, fileSortType);
        }
        catch (Exception exception) {
            this.debug(String.format("Can't walk directory: %s", file.toString()), exception);
            return "";
        }
    }

    @Override
    public String getScript(Locale locale) {
        return locale.getScript();
    }

    @Override
    public Locale getLocale(String string) {
        Locale locale = Locale.forLanguageTag(string);
        String string2 = locale.getCountry();
        try {
            string2 = this.getRegionAlpha2Code(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return locale;
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLocale(locale);
        builder.setRegion(string2);
        return builder.build();
    }

    @Override
    public String getLanguageTag(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.toLanguageTag();
    }

    @Override
    public int getWeekYear(Calendar calendar) {
        try {
            return calendar.isWeekDateSupported() ? calendar.getWeekYear() : calendar.get(1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.debug(unsupportedOperationException.getMessage(), unsupportedOperationException);
            return calendar.get(1);
        }
    }

    @Override
    public String getStandaloneMonths(Calendar calendar, Locale locale) {
        Map<String, Integer> map = calendar.getDisplayNames(2, 32770, locale);
        String[] stringArray = new String[12];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int n = entry.getValue();
            if (n >= 12) continue;
            stringArray[n] = entry.getKey();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getStandaloneShortMonths(Calendar calendar, Locale locale) {
        Map<String, Integer> map = calendar.getDisplayNames(2, 32769, locale);
        String[] stringArray = new String[12];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int n = entry.getValue();
            if (n >= stringArray.length) continue;
            stringArray[n] = entry.getKey();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getStandaloneWeekdays(Calendar calendar, Locale locale) {
        Map<String, Integer> map = calendar.getDisplayNames(7, 32770, locale);
        String[] stringArray = new String[7];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            switch (entry.getValue()) {
                case 2: {
                    stringArray[0] = entry.getKey();
                    break;
                }
                case 3: {
                    stringArray[1] = entry.getKey();
                    break;
                }
                case 4: {
                    stringArray[2] = entry.getKey();
                    break;
                }
                case 5: {
                    stringArray[3] = entry.getKey();
                    break;
                }
                case 6: {
                    stringArray[4] = entry.getKey();
                    break;
                }
                case 7: {
                    stringArray[5] = entry.getKey();
                    break;
                }
                case 1: {
                    stringArray[6] = entry.getKey();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getStandaloneShortWeekdays(Calendar calendar, Locale locale) {
        Map<String, Integer> map = calendar.getDisplayNames(7, 32769, locale);
        String[] stringArray = new String[7];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            switch (entry.getValue()) {
                case 2: {
                    stringArray[0] = entry.getKey();
                    break;
                }
                case 3: {
                    stringArray[1] = entry.getKey();
                    break;
                }
                case 4: {
                    stringArray[2] = entry.getKey();
                    break;
                }
                case 5: {
                    stringArray[3] = entry.getKey();
                    break;
                }
                case 6: {
                    stringArray[4] = entry.getKey();
                    break;
                }
                case 7: {
                    stringArray[5] = entry.getKey();
                    break;
                }
                case 1: {
                    stringArray[6] = entry.getKey();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    @Override
    public void sortFileList(String[] stringArray, File file, FileSortType fileSortType) {
        Arrays.parallelSort(stringArray, new FileSortComparator(file, fileSortType));
    }

    public static void main(String[] stringArray) {
        try {
            new TeXOSQueryJRE8().processArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
    }
}

