#ifndef EVAS_CANVAS_EO_HH
#define EVAS_CANVAS_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_animator.eo.h"
#include "efl_canvas.eo.h"
#include "efl_canvas_object.eo.h"
#include "efl_event_hold.eo.h"
#include "efl_event_key.eo.h"
#include "efl_event_pointer.eo.h"
#include "efl_gfx.eo.h"
#include "efl_input_device.eo.h"
#include "efl_input_interface.eo.h"
#include "eo_base.eo.h"
#include "evas_canvas.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_animator.eo.hh"
#include "efl_canvas.eo.hh"
#include "efl_canvas_object.eo.hh"
#include "efl_event_hold.eo.hh"
#include "efl_event_key.eo.hh"
#include "efl_event_pointer.eo.hh"
#include "efl_gfx.eo.hh"
#include "efl_input_device.eo.hh"
#include "efl_input_interface.eo.hh"
#include "eo_base.eo.hh"
namespace evas { 
struct Canvas;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::evas::Canvas> : ::std::true_type {}; } }

namespace eo_cxx {
namespace evas { 
struct Canvas {
   ::efl::eolian::return_traits<int>::type image_cache_get() const;
   ::efl::eolian::return_traits<void>::type image_cache_set( ::efl::eolian::in_traits<int>::type size) const;
   ::efl::eolian::return_traits<Efl_Event_Flags>::type event_default_flags_get() const;
   ::efl::eolian::return_traits<void>::type event_default_flags_set( ::efl::eolian::in_traits<Efl_Event_Flags>::type flags) const;
   ::efl::eolian::return_traits<int>::type font_cache_get() const;
   ::efl::eolian::return_traits<void>::type font_cache_set( ::efl::eolian::in_traits<int>::type size) const;
   ::efl::eolian::return_traits<void*>::type data_attach_get() const;
   ::efl::eolian::return_traits<void>::type data_attach_set( ::efl::eolian::in_traits<void*>::type data) const;
   ::efl::eolian::return_traits<Evas_Font_Hinting_Flags>::type font_hinting_get() const;
   ::efl::eolian::return_traits<void>::type font_hinting_set( ::efl::eolian::in_traits<Evas_Font_Hinting_Flags>::type hinting) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type focus_get() const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_get() const;
   ::efl::eolian::return_traits<void>::type pointer_canvas_xy_get( ::efl::eolian::out_traits<Evas_Coord>::type x,  ::efl::eolian::out_traits<Evas_Coord>::type y) const;
   ::efl::eolian::return_traits<int>::type event_down_count_get() const;
   ::efl::eolian::return_traits<int>::type smart_objects_calculate_count_get() const;
   ::efl::eolian::return_traits<bool>::type focus_state_get() const;
   ::efl::eolian::return_traits<bool>::type changed_get() const;
   ::efl::eolian::return_traits<void>::type pointer_output_xy_get( ::efl::eolian::out_traits<int>::type x,  ::efl::eolian::out_traits<int>::type y) const;
   ::efl::eolian::return_traits<bool>::type pointer_inside_get() const;
   ::efl::eolian::return_traits<bool>::type image_max_size_get( ::efl::eolian::out_traits<int>::type maxw,  ::efl::eolian::out_traits<int>::type maxh) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_bottom_get() const;
   ::efl::eolian::return_traits< unsigned int>::type pointer_button_down_mask_get() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type tree_objects_at_xy_get( ::efl::eolian::in_traits< ::efl::canvas::Object>::type stop,  ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y) const;
   ::efl::eolian::return_traits<void>::type key_lock_on( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<Evas_Modifier_Mask>::type key_modifier_mask_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type key_modifier_add( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type key_modifier_off( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type objects_at_xy_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<bool>::type render_async() const;
   ::efl::eolian::return_traits<bool>::type render2() const;
   ::efl::eolian::return_traits<void>::type focus_out() const;
   ::efl::eolian::return_traits<void>::type norender() const;
   ::efl::eolian::return_traits< unsigned int>::type touch_point_list_count() const;
   ::efl::eolian::return_traits<void>::type nochange_pop() const;
   ::efl::eolian::return_traits<void>::type key_lock_off( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type nochange_push() const;
   ::efl::eolian::return_traits<void>::type font_cache_flush() const;
   ::efl::eolian::return_traits<bool>::type font_hinting_can_hint( ::efl::eolian::in_traits<Evas_Font_Hinting_Flags>::type hinting) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_at_xy_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<void>::type key_modifier_on( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::eina::string_view>>::type font_available_list() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type objects_in_rectangle_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<Evas_Coord>::type w,  ::efl::eolian::in_traits<Evas_Coord>::type h,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_name_find( ::efl::eolian::in_traits< ::efl::eina::string_view>::type name) const;
   ::efl::eolian::return_traits<void>::type font_path_append( ::efl::eolian::in_traits< ::efl::eina::string_view>::type path) const;
   ::efl::eolian::return_traits<int>::type touch_point_list_nth_id_get( ::efl::eolian::in_traits< unsigned int>::type n) const;
   ::efl::eolian::return_traits<void>::type font_path_clear() const;
   ::efl::eolian::return_traits<void>::type smart_objects_calculate() const;
   ::efl::eolian::return_traits<void>::type touch_point_list_nth_xy_get( ::efl::eolian::in_traits< unsigned int>::type n,  ::efl::eolian::out_traits<Evas_Coord>::type x,  ::efl::eolian::out_traits<Evas_Coord>::type y) const;
   ::efl::eolian::return_traits<void>::type key_lock_del( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type damage_rectangle_add( ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y,  ::efl::eolian::in_traits<int>::type w,  ::efl::eolian::in_traits<int>::type h) const;
   ::efl::eolian::return_traits<void>::type sync() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::eina::string_view>>::type font_path_list() const;
   ::efl::eolian::return_traits<void>::type image_cache_reload() const;
   ::efl::eolian::return_traits<int>::type coord_world_x_to_screen( ::efl::eolian::in_traits<Evas_Coord>::type x) const;
   ::efl::eolian::return_traits<void>::type image_cache_flush() const;
   ::efl::eolian::return_traits<Evas_Coord>::type coord_screen_y_to_world( ::efl::eolian::in_traits<int>::type y) const;
   ::efl::eolian::return_traits<void>::type key_modifier_del( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<Evas_Touch_Point_State>::type touch_point_list_nth_state_get( ::efl::eolian::in_traits< unsigned int>::type n) const;
   ::efl::eolian::return_traits<void>::type focus_in() const;
   ::efl::eolian::return_traits<void>::type obscured_rectangle_add( ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y,  ::efl::eolian::in_traits<int>::type w,  ::efl::eolian::in_traits<int>::type h) const;
   ::efl::eolian::return_traits<void>::type render_dump() const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_in_rectangle_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<Evas_Coord>::type w,  ::efl::eolian::in_traits<Evas_Coord>::type h,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<void>::type render() const;
   ::efl::eolian::return_traits<void>::type font_path_prepend( ::efl::eolian::in_traits< ::efl::eina::string_view>::type path) const;
   ::efl::eolian::return_traits<void>::type obscured_clear() const;
   ::efl::eolian::return_traits<Evas_Coord>::type coord_screen_x_to_world( ::efl::eolian::in_traits<int>::type x) const;
   ::efl::eolian::return_traits<void>::type key_lock_add( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type render_idle_flush() const;
   ::efl::eolian::return_traits<int>::type coord_world_y_to_screen( ::efl::eolian::in_traits<Evas_Coord>::type y) const;
   static Eo_Class const* _eo_class()
   {
      return EVAS_CANVAS_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::evas::Canvas() const;
   operator ::evas::Canvas&();
   operator ::evas::Canvas const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Canvas,  ::efl::Animator,  ::efl::Canvas,  ::efl::input::Interface,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Canvas const ,  ::efl::Animator const ,  ::efl::Canvas const ,  ::efl::input::Interface const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace evas { 
struct Canvas : ::efl::eo::concrete
   , EO_CXX_INHERIT( ::efl::Animator)
   , EO_CXX_INHERIT( ::efl::Canvas)
   , EO_CXX_INHERIT( ::efl ::input::Interface)
   , EO_CXX_INHERIT( ::eo::Base)
{
   explicit Canvas( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Canvas(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Canvas(Canvas const& other) = default;
   Canvas(Canvas&& other) = default;
   Canvas& operator=(Canvas const& other) = default;
   Canvas& operator=(Canvas&& other) = default;
   Canvas()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Canvas( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Canvas(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<int>::type image_cache_get() const;
   ::efl::eolian::return_traits<void>::type image_cache_set( ::efl::eolian::in_traits<int>::type size) const;
   ::efl::eolian::return_traits<Efl_Event_Flags>::type event_default_flags_get() const;
   ::efl::eolian::return_traits<void>::type event_default_flags_set( ::efl::eolian::in_traits<Efl_Event_Flags>::type flags) const;
   ::efl::eolian::return_traits<int>::type font_cache_get() const;
   ::efl::eolian::return_traits<void>::type font_cache_set( ::efl::eolian::in_traits<int>::type size) const;
   ::efl::eolian::return_traits<void*>::type data_attach_get() const;
   ::efl::eolian::return_traits<void>::type data_attach_set( ::efl::eolian::in_traits<void*>::type data) const;
   ::efl::eolian::return_traits<Evas_Font_Hinting_Flags>::type font_hinting_get() const;
   ::efl::eolian::return_traits<void>::type font_hinting_set( ::efl::eolian::in_traits<Evas_Font_Hinting_Flags>::type hinting) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type focus_get() const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_get() const;
   ::efl::eolian::return_traits<void>::type pointer_canvas_xy_get( ::efl::eolian::out_traits<Evas_Coord>::type x,  ::efl::eolian::out_traits<Evas_Coord>::type y) const;
   ::efl::eolian::return_traits<int>::type event_down_count_get() const;
   ::efl::eolian::return_traits<int>::type smart_objects_calculate_count_get() const;
   ::efl::eolian::return_traits<bool>::type focus_state_get() const;
   ::efl::eolian::return_traits<bool>::type changed_get() const;
   ::efl::eolian::return_traits<void>::type pointer_output_xy_get( ::efl::eolian::out_traits<int>::type x,  ::efl::eolian::out_traits<int>::type y) const;
   ::efl::eolian::return_traits<bool>::type pointer_inside_get() const;
   ::efl::eolian::return_traits<bool>::type image_max_size_get( ::efl::eolian::out_traits<int>::type maxw,  ::efl::eolian::out_traits<int>::type maxh) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_bottom_get() const;
   ::efl::eolian::return_traits< unsigned int>::type pointer_button_down_mask_get() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type tree_objects_at_xy_get( ::efl::eolian::in_traits< ::efl::canvas::Object>::type stop,  ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y) const;
   ::efl::eolian::return_traits<void>::type key_lock_on( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<Evas_Modifier_Mask>::type key_modifier_mask_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type key_modifier_add( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type key_modifier_off( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type objects_at_xy_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<bool>::type render_async() const;
   ::efl::eolian::return_traits<bool>::type render2() const;
   ::efl::eolian::return_traits<void>::type focus_out() const;
   ::efl::eolian::return_traits<void>::type norender() const;
   ::efl::eolian::return_traits< unsigned int>::type touch_point_list_count() const;
   ::efl::eolian::return_traits<void>::type nochange_pop() const;
   ::efl::eolian::return_traits<void>::type key_lock_off( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type nochange_push() const;
   ::efl::eolian::return_traits<void>::type font_cache_flush() const;
   ::efl::eolian::return_traits<bool>::type font_hinting_can_hint( ::efl::eolian::in_traits<Evas_Font_Hinting_Flags>::type hinting) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_at_xy_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<void>::type key_modifier_on( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::eina::string_view>>::type font_available_list() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::canvas::Object>>::type objects_in_rectangle_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<Evas_Coord>::type w,  ::efl::eolian::in_traits<Evas_Coord>::type h,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_name_find( ::efl::eolian::in_traits< ::efl::eina::string_view>::type name) const;
   ::efl::eolian::return_traits<void>::type font_path_append( ::efl::eolian::in_traits< ::efl::eina::string_view>::type path) const;
   ::efl::eolian::return_traits<int>::type touch_point_list_nth_id_get( ::efl::eolian::in_traits< unsigned int>::type n) const;
   ::efl::eolian::return_traits<void>::type font_path_clear() const;
   ::efl::eolian::return_traits<void>::type smart_objects_calculate() const;
   ::efl::eolian::return_traits<void>::type touch_point_list_nth_xy_get( ::efl::eolian::in_traits< unsigned int>::type n,  ::efl::eolian::out_traits<Evas_Coord>::type x,  ::efl::eolian::out_traits<Evas_Coord>::type y) const;
   ::efl::eolian::return_traits<void>::type key_lock_del( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type damage_rectangle_add( ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y,  ::efl::eolian::in_traits<int>::type w,  ::efl::eolian::in_traits<int>::type h) const;
   ::efl::eolian::return_traits<void>::type sync() const;
   ::efl::eolian::return_traits<  ::efl::eina::range_list< ::efl::eina::string_view>>::type font_path_list() const;
   ::efl::eolian::return_traits<void>::type image_cache_reload() const;
   ::efl::eolian::return_traits<int>::type coord_world_x_to_screen( ::efl::eolian::in_traits<Evas_Coord>::type x) const;
   ::efl::eolian::return_traits<void>::type image_cache_flush() const;
   ::efl::eolian::return_traits<Evas_Coord>::type coord_screen_y_to_world( ::efl::eolian::in_traits<int>::type y) const;
   ::efl::eolian::return_traits<void>::type key_modifier_del( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<Evas_Touch_Point_State>::type touch_point_list_nth_state_get( ::efl::eolian::in_traits< unsigned int>::type n) const;
   ::efl::eolian::return_traits<void>::type focus_in() const;
   ::efl::eolian::return_traits<void>::type obscured_rectangle_add( ::efl::eolian::in_traits<int>::type x,  ::efl::eolian::in_traits<int>::type y,  ::efl::eolian::in_traits<int>::type w,  ::efl::eolian::in_traits<int>::type h) const;
   ::efl::eolian::return_traits<void>::type render_dump() const;
   ::efl::eolian::return_traits< ::efl::canvas::Object>::type object_top_in_rectangle_get( ::efl::eolian::in_traits<Evas_Coord>::type x,  ::efl::eolian::in_traits<Evas_Coord>::type y,  ::efl::eolian::in_traits<Evas_Coord>::type w,  ::efl::eolian::in_traits<Evas_Coord>::type h,  ::efl::eolian::in_traits<bool>::type include_pass_events_objects,  ::efl::eolian::in_traits<bool>::type include_hidden_objects) const;
   ::efl::eolian::return_traits<void>::type render() const;
   ::efl::eolian::return_traits<void>::type font_path_prepend( ::efl::eolian::in_traits< ::efl::eina::string_view>::type path) const;
   ::efl::eolian::return_traits<void>::type obscured_clear() const;
   ::efl::eolian::return_traits<Evas_Coord>::type coord_screen_x_to_world( ::efl::eolian::in_traits<int>::type x) const;
   ::efl::eolian::return_traits<void>::type key_lock_add( ::efl::eolian::in_traits< ::efl::eina::string_view>::type keyname) const;
   ::efl::eolian::return_traits<void>::type render_idle_flush() const;
   ::efl::eolian::return_traits<int>::type coord_world_y_to_screen( ::efl::eolian::in_traits<Evas_Coord>::type y) const;
   static Eo_Class const* _eo_class()
   {
      return EVAS_CANVAS_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
#ifdef EVAS_CANVAS_BETA
   static struct render_flush_pre_event
   {
      static Eo_Event_Description const* description()
      { return EVAS_CANVAS_EVENT_RENDER_FLUSH_PRE; }
      typedef void parameter_type;
   } const render_flush_pre_event;
#endif
#ifdef EVAS_CANVAS_BETA
   static struct render_flush_post_event
   {
      static Eo_Event_Description const* description()
      { return EVAS_CANVAS_EVENT_RENDER_FLUSH_POST; }
      typedef void parameter_type;
   } const render_flush_post_event;
#endif
#ifdef EVAS_CANVAS_BETA
   static struct axis_update_event
   {
      static Eo_Event_Description const* description()
      { return EVAS_CANVAS_EVENT_AXIS_UPDATE; }
      typedef void parameter_type;
   } const axis_update_event;
#endif
#ifdef EVAS_CANVAS_BETA
   static struct viewport_resize_event
   {
      static Eo_Event_Description const* description()
      { return EVAS_CANVAS_EVENT_VIEWPORT_RESIZE; }
      typedef void parameter_type;
   } const viewport_resize_event;
#endif
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Canvas,  ::efl::Animator,  ::efl::Canvas,  ::efl::input::Interface,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Canvas const ,  ::efl::Animator const ,  ::efl::Canvas const ,  ::efl::input::Interface const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Canvas) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Canvas>::value, "");
} 
#include "evas_canvas.eo.impl.hh"
#endif
