/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.GPXLogConvert;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.j2se_view.model.BT747Waypoint;
import bt747.j2se_view.model.FileWaypoint;
import bt747.j2se_view.model.ImageData;
import bt747.model.AppSettings;
import bt747.model.Controller;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import gps.convert.ExternalUtils;
import gps.convert.Geoid;
import gps.convert.GeoidIF;
import gps.log.in.GPSInputConversionFactory;
import gps.log.in.GPSLogConvertInterface;
import java.io.File;
import java.io.IOException;
import net.sf.bt747.j2se.app.agps.J2SEAGPS;

public class J2SEController
extends Controller {
    protected static final String platform = System.getProperty("os.name");
    private Model m;

    public J2SEController(Model model) {
        super(model);
        this.setModel(this.m);
    }

    public J2SEController() {
    }

    public static final void setSystemProxies(Model model) {
        boolean bl = model.getBooleanOpt(101);
        try {
            if (System.getProperty("bt747.disableForceSystemProxies") != null) {
                bl = false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        System.setProperty("java.net.useSystemProxies", bl ? "true" : "false");
    }

    public void setModel(Model model) {
        super.setModel(model);
        this.m = model;
        J2SEController.setSystemProxies(model);
        this.updateUseGeoid();
    }

    public void modelEvent(ModelEvent modelEvent) {
        super.modelEvent(modelEvent);
        switch (modelEvent.getType()) {
            case 269: {
                switch (Integer.valueOf((String)modelEvent.getArg())) {
                    case 54: {
                        this.updateUseGeoid();
                    }
                }
            }
        }
    }

    private void updateUseGeoid() {
        GeoidIF geoidIF;
        if (this.m.getBooleanOpt(54)) {
            geoidIF = net.sf.bt747.j2se.app.utils.Geoid.getInstance();
            if (geoidIF == null) {
                Generic.debug("Precise Geoid loading failed");
                super.setBooleanOpt(54, false);
            }
        } else {
            geoidIF = Geoid.getInstance();
        }
        if (geoidIF != null) {
            ExternalUtils.setGeoidIF(geoidIF);
        }
    }

    public static final void tagImage(TaggedFilePathFactory object, ImageData object2) throws IOException {
        if (!((BT747Waypoint)object2).getGpsRecord().hasPosition()) {
            return;
        }
        String string = ((FileWaypoint)object2).getFilePath().getPath();
        String string2 = ((TaggedFilePathFactory)object).getTaggedFilePath$f100de5(string);
        String string3 = new File(string2).getCanonicalPath();
        String string4 = new File(string).getCanonicalPath();
        String string5 = string;
        if (string3.equals(string4) && !((File)(object = new File(string5 = ((TaggedFilePathFactory)object).getOrgFilePath$f100de5(string)))).exists()) {
            new File(string).renameTo((File)object);
        }
        ((ImageData)object2).writeImage(new BT747Path(string5), new BT747Path(string2));
        ImageData imageData = object2;
        object2 = new BT747Path(string2);
        object = imageData;
        new bt747.sys.File((BT747Path)object2).setModificationTime(((FileWaypoint)object).getUtc());
    }

    public static final void addLogFile(File file) {
        try {
            J2SEController.addLogFile(new BT747Path(file.getCanonicalPath()));
            return;
        }
        catch (Exception exception) {
            Generic.debug("Problem adding log file", exception);
            return;
        }
    }

    public final void downloadAndUploadAgpsData() {
        Generic.debug("Getting MTK7d.EPO data.");
        this.downloadAndUploadAgpsData("ftp://tsi0013:wrqttr@210.68.183.169/MTK8d.EPO");
    }

    public final void downloadAndUploadAgpsData(String string) {
        new Thread(new Runnable(this, string){
            private String urlT;
            private /* synthetic */ String val$urlTxt;
            private /* synthetic */ J2SEController this$0;
            {
                this.this$0 = j2SEController;
                this.val$urlTxt = string;
                this.urlT = this.val$urlTxt;
            }

            public final void run() {
                try {
                    byte[] byArray = J2SEAGPS.getBytesFromUrl(this.urlT);
                    this.this$0.setAgpsData(byArray);
                    Generic.debug("MTK7d.EPO data fetched.");
                    return;
                }
                catch (BT747Exception bT747Exception) {
                    this.this$0.m.postEvent(new ModelEvent(38, bT747Exception));
                    return;
                }
            }
        }).start();
    }

    static {
        AppSettings.CONFIG_FILE_NAME = (System.getProperty("user.home").length() != 0 ? System.getProperty("user.home") : (platform.startsWith("Win32") || platform.startsWith("Windows") ? System.getenv("USERPROFILE") : "")) + System.getProperty("file.separator");
        GPSInputConversionFactory.addHandler(new GPXHandlerFactory(0));
    }

    static final class GPXHandlerFactory
    extends GPSInputConversionFactory {
        private GPXHandlerFactory() {
        }

        public final GPSLogConvertInterface getInputConversionInstance(BT747Path bT747Path, int n) {
            if (bT747Path.getPath().toLowerCase().endsWith(".gpx")) {
                return new GPXLogConvert();
            }
            return super.getInputConversionInstance(bT747Path, n);
        }

        /* synthetic */ GPXHandlerFactory(byte by) {
            this();
        }
    }
}

