/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Iterator;
import java.util.List;
import joptsimple.IllegalOptionSpecificationException;

class ParserRules {
    static final char HYPHEN_CHAR = '-';
    static final String HYPHEN = String.valueOf('-');
    static final String DOUBLE_HYPHEN = "--";
    static final String OPTION_TERMINATOR = "--";
    static final String RESERVED_FOR_EXTENSIONS = "W";

    protected ParserRules() {
        throw new UnsupportedOperationException();
    }

    static boolean isShortOptionToken(String argument) {
        return argument.startsWith(HYPHEN) && !HYPHEN.equals(argument) && !ParserRules.isLongOptionToken(argument);
    }

    static boolean isLongOptionToken(String argument) {
        return argument.startsWith("--") && !ParserRules.isOptionTerminator(argument);
    }

    static boolean isOptionTerminator(String argument) {
        return "--".equals(argument);
    }

    static void checkLegalOption(String option) {
        if (option.startsWith(HYPHEN)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option));
        }
        for (int i = 0; i < option.length(); ++i) {
            ParserRules.checkLegalOptionCharacter(option.charAt(i));
        }
    }

    static void checkLegalOptions(List options) {
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            ParserRules.checkLegalOption((String)iter.next());
        }
    }

    private static void checkLegalOptionCharacter(char option) {
        if (!Character.isLetterOrDigit(option) && !ParserRules.isAllowedPunctuation(option)) {
            throw new IllegalOptionSpecificationException(String.valueOf(option));
        }
    }

    private static boolean isAllowedPunctuation(char option) {
        String allowedPunctuation = "?.-";
        return allowedPunctuation.indexOf(option) != -1;
    }
}

