Clazz.declarePackage ("JS");
Clazz.load (["JU.Lst", "$.V3"], "JS.CIPChirality", ["java.util.Arrays", "$.Hashtable", "JU.BS", "$.Measure", "$.P3", "$.P4", "$.PT", "JU.BSUtil", "$.Logger", "JV.JC"], function () {
c$ = Clazz.decorateAsClass (function () {
this.ptID = 0;
this.root = null;
this.currentRule = 1;
this.htPathPoints = null;
this.lstSmallRings = null;
this.nPriorityMax = 0;
this.maxRingSize = 0;
this.vNorm = null;
this.vNorm2 = null;
this.vTemp = null;
if (!Clazz.isClassDefined ("JS.CIPChirality.CIPAtom")) {
JS.CIPChirality.$CIPChirality$CIPAtom$ ();
}
Clazz.instantialize (this, arguments);
}, JS, "CIPChirality");
Clazz.prepareFields (c$, function () {
this.lstSmallRings =  new JU.Lst ();
this.vNorm =  new JU.V3 ();
this.vNorm2 =  new JU.V3 ();
this.vTemp =  new JU.V3 ();
});
Clazz.defineMethod (c$, "getRuleName", 
function () {
return "" + this.currentRule;
});
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "init", 
 function () {
this.ptID = 0;
this.nPriorityMax = this.maxRingSize = 0;
this.lstSmallRings.clear ();
});
Clazz.defineMethod (c$, "getChiralityForAtoms", 
function (atoms, bsAtoms, bsAtropisomeric) {
if (bsAtoms.isEmpty ()) return;
this.init ();
var bsToDo = JU.BSUtil.copy (bsAtoms);
var haveAlkenes = this.preFilterAtomList (atoms, bsToDo);
for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) {
var atom = atoms[i];
var c = atom.getCIPChirality (false);
if (c.length > 0) {
bsToDo.clear (i);
} else {
atom.setCIPChirality (this.getAtomChiralityLimited (atom, null, null, 3));
}}
var lstEZ =  new JU.Lst ();
if (haveAlkenes) {
this.getSmallRings (atoms[bsAtoms.nextSetBit (0)]);
for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) this.getAtomBondChirality (atoms[i], false, 3, lstEZ, bsToDo, bsAtropisomeric);

}for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) {
var a = atoms[i];
a.setCIPChirality (0);
a.setCIPChirality (this.getAtomChiralityLimited (a, null, null, 5));
}
if (haveAlkenes) {
for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) this.getAtomBondChirality (atoms[i], false, 5, lstEZ, bsToDo, bsAtropisomeric);

}if (this.lstSmallRings.size () > 0 && lstEZ.size () > 0) this.clearSmallRingEZ (atoms, lstEZ);
}, "~A,JU.BS,JU.BS");
Clazz.defineMethod (c$, "preFilterAtomList", 
 function (atoms, bsToDo) {
var haveAlkenes = false;
for (var i = bsToDo.nextSetBit (0); i >= 0; i = bsToDo.nextSetBit (i + 1)) {
if (!this.couldBeChiralAtom (atoms[i])) {
bsToDo.clear (i);
continue;
}if (!haveAlkenes && this.couldBeChiralAlkene (atoms[i], null) != -1) haveAlkenes = true;
}
return haveAlkenes;
}, "~A,JU.BS");
Clazz.defineMethod (c$, "couldBeChiralAtom", 
 function (a) {
var mustBePlanar = false;
switch (a.getCovalentBondCount ()) {
default:
return false;
case 2:
return a.getElementNumber () == 7;
case 3:
switch (a.getElementNumber ()) {
case 6:
mustBePlanar = true;
break;
case 15:
case 16:
case 33:
case 34:
case 51:
case 52:
case 83:
case 84:
break;
case 4:
break;
default:
return false;
}
break;
case 4:
break;
}
var edges = a.getEdges ();
var nH = 0;
for (var j = a.getBondCount (); --j >= 0; ) {
if (edges[j].getOtherAtomNode (a).getAtomicAndIsotopeNumber () == 1 && ++nH == 2) {
return false;
}}
var d = this.getTrigonality (a, this.vNorm);
return ((Math.abs (d) < 0.2) == mustBePlanar);
}, "JU.Node");
Clazz.defineMethod (c$, "couldBeChiralAlkene", 
 function (a, b) {
switch (a.getCovalentBondCount ()) {
default:
return -1;
case 2:
if (a.getElementNumber () != 7) return -1;
break;
case 3:
if (!this.isFirstRow (a)) return -1;
break;
}
var bonds = a.getEdges ();
var n = 0;
for (var i = bonds.length; --i >= 0; ) if (bonds[i].getCovalentOrder () == 2) {
if (++n > 1) return -3;
var other = bonds[i].getOtherAtomNode (a);
if (!this.isFirstRow (other)) return -1;
if (b != null && (other !== b || b.getCovalentBondCount () == 1)) {
return -1;
}}
return -2;
}, "JU.Node,JU.Node");
Clazz.defineMethod (c$, "isFirstRow", 
function (a) {
var n = a.getElementNumber ();
return (n > 2 && n <= 10);
}, "JU.Node");
Clazz.defineMethod (c$, "getSmallRings", 
 function (atom) {
this.lstSmallRings =  new JU.Lst ();
this.htPathPoints =  new java.util.Hashtable ();
this.root = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (atom, null, false, false);
this.addSmallRings (this.root);
}, "JU.Node");
Clazz.defineMethod (c$, "addSmallRings", 
 function (a) {
if (a == null || a.isTerminal || a.isDuplicate || a.atom == null || a.atom.getCovalentBondCount () > 4) return;
var bonds = a.atom.getEdges ();
var atom2;
var pt = 0;
for (var i = bonds.length; --i >= 0; ) {
var bond = bonds[i];
if (bond == null || !bond.isCovalent () || (atom2 = bond.getOtherAtomNode (a.atom)).getElementNumber () == 1 || a.parent != null && atom2 === a.parent.atom) continue;
a.addAtom (pt++, atom2, false, false);
}
for (var i = 0; i < pt; i++) this.addSmallRings (a.atoms[i]);

}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "clearSmallRingEZ", 
 function (atoms, lstEZ) {
for (var i = lstEZ.size (); --i >= 0; ) {
var ab = lstEZ.get (i);
for (var j = this.lstSmallRings.size (); --j >= 0; ) {
var ring = this.lstSmallRings.get (j);
if (ring.get (ab[0]) && ring.get (ab[1])) {
atoms[ab[0]].setCIPChirality (3);
atoms[ab[1]].setCIPChirality (3);
}}
}
}, "~A,JU.Lst");
Clazz.defineMethod (c$, "getTrigonality", 
function (a, vNorm) {
var pts =  new Array (3);
var bonds = a.getEdges ();
for (var i = bonds.length, pt = 0; --i >= 0 && pt < 3; ) if (bonds[i].isCovalent ()) pts[pt++] = bonds[i].getOtherAtomNode (a).getXYZ ();

var plane = JU.Measure.getPlaneThroughPoints (pts[0], pts[1], pts[2], vNorm, this.vTemp,  new JU.P4 ());
return JU.Measure.distanceToPlane (plane, a.getXYZ ());
}, "JU.Node,JU.V3");
Clazz.defineMethod (c$, "getAtomChirality", 
function (atom) {
this.init ();
return this.getAtomChiralityLimited (atom, null, null, 3);
}, "JU.Node");
Clazz.defineMethod (c$, "getBondChirality", 
function (bond) {
this.init ();
this.getSmallRings (bond.getOtherAtomNode (null));
return (bond.getCovalentOrder () == 2 ? this.getBondChiralityLimited (bond, null, 3) : 0);
}, "JU.Edge");
Clazz.defineMethod (c$, "getAtomBondChirality", 
 function (atom, allBonds, ruleMax, lstEZ, bsToDo, bsAtrop) {
var index = atom.getIndex ();
var bonds = atom.getEdges ();
if (bsAtrop.get (index)) {
for (var j = bonds.length; --j >= 0; ) {
var atom1 = bonds[j].getOtherAtomNode (atom);
var index1 = atom1.getIndex ();
if (!allBonds && index1 < index || !bsAtrop.get (index1)) continue;
this.getAxialOrEZChirality (atom, atom1, true, ruleMax);
break;
}
return;
}for (var j = bonds.length; --j >= 0; ) {
var bond = bonds[j];
if (bond.getCovalentOrder () == 2) {
var atom2 = this.getLastCumuleneAtom (bond, atom, null);
var index2 = atom2.getIndex ();
if ((allBonds || index2 > index) && this.getBondChiralityLimited (bond, atom, ruleMax) != 0) {
lstEZ.addLast ( Clazz.newIntArray (-1, [index, index2]));
}}}
}, "JU.Node,~B,~N,JU.Lst,JU.BS,JU.BS");
Clazz.defineMethod (c$, "getLastCumuleneAtom", 
 function (bond, atom, nSP2) {
var atom2 = bond.getOtherAtomNode (atom);
if (nSP2 != null) nSP2[0] = 2;
while (true) {
if (atom2.getCovalentBondCount () != 2) return atom2;
var edges = atom2.getEdges ();
for (var i = edges.length; --i >= 0; ) {
var atom3 = (bond = edges[i]).getOtherAtomNode (atom2);
if (atom3 === atom) continue;
if (bond.getCovalentOrder () != 2) return atom2;
if (nSP2 != null) nSP2[0]++;
atom = atom2;
atom2 = atom3;
break;
}
}
}, "JU.Edge,JU.Node,~A");
Clazz.defineMethod (c$, "getAtomChiralityLimited", 
 function (atom, cipAtom, parent, ruleMax) {
var rs = 0;
var isChiral = false;
var isAlkene = false;
try {
if (cipAtom == null) {
this.htPathPoints =  new java.util.Hashtable ();
cipAtom = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (atom, null, false, isAlkene);
var nSubs = atom.getCovalentBondCount ();
var elemNo = atom.getElementNumber ();
isAlkene = (nSubs == 3 && elemNo <= 10);
if (nSubs != (parent == null ? 4 : 3) - (nSubs == 3 && !isAlkene ? 1 : 0)) return rs;
} else {
atom = cipAtom.atom;
isAlkene = cipAtom.isAlkene;
}this.root = cipAtom;
cipAtom.parent = parent;
this.currentRule = 1;
if (cipAtom.set ()) {
for (this.currentRule = 1; this.currentRule <= ruleMax && !isChiral; this.currentRule++) {
if (JU.Logger.debugging) JU.Logger.info ("-Rule " + this.getRuleName () + " CIPChirality for " + cipAtom + "-----");
if (this.currentRule == 4) {
cipAtom.resetAuxiliaryChirality ();
cipAtom.createAuxiliaryRSCenters (true);
}isChiral = false;
cipAtom.sortSubstituents ();
isChiral = true;
if (JU.Logger.debugging) {
JU.Logger.info (this.currentRule + ">>>>" + cipAtom);
for (var i = 0; i < cipAtom.bondCount; i++) {
if (cipAtom.atoms[i] == null) JU.Logger.info (cipAtom.atoms[i] + " " + Integer.toHexString (cipAtom.prevPriorities[i]));
}
}if (cipAtom.achiral) {
isChiral = false;
break;
}for (var i = 0; i < cipAtom.bondCount - 1; i++) {
if (cipAtom.prevPriorities[i] == cipAtom.prevPriorities[i + 1]) {
isChiral = false;
break;
}}
if (this.currentRule == 5) cipAtom.isPseudo = cipAtom.canBePseudo;
}
if (isChiral) {
rs = (!isAlkene ? cipAtom.checkHandedness () : cipAtom.atoms[0].isDuplicate ? 2 : 1);
if (cipAtom.isPseudo && !isAlkene) rs = rs | 4;
}if (JU.Logger.debugging) JU.Logger.info (atom + " " + rs + "\n----------------------------------");
}} catch (e) {
System.out.println (e + " in CIPChirality");
{
alert(e);
}return 3;
}
return rs;
}, "JU.Node,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,~N");
Clazz.defineMethod (c$, "getBondChiralityLimited", 
 function (bond, a, ruleMax) {
if (JU.Logger.debugging) JU.Logger.info ("get Bond Chirality " + bond);
if (a == null) a = bond.getOtherAtomNode (null);
var b = bond.getOtherAtomNode (a);
if (this.couldBeChiralAlkene (a, b) == -1) return 0;
var nSP2 =  Clazz.newIntArray (1, 0);
b = this.getLastCumuleneAtom (bond, a, nSP2);
var isCumulene = (nSP2[0] > 2);
var isAxial = isCumulene && (nSP2[0] % 2 == 1);
return this.getAxialOrEZChirality (a, b, isAxial, ruleMax);
}, "JU.Edge,JU.Node,~N");
Clazz.defineMethod (c$, "getAxialOrEZChirality", 
 function (a, b, isAxial, ruleMax) {
this.htPathPoints =  new java.util.Hashtable ();
var a1 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (a, null, false, true);
var b1 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (b, null, false, true);
a1.canBePseudo = a1.isOddCumulene = isAxial;
var atop = this.getAtomChiralityLimited (a, a1, b1, ruleMax) - 1;
this.htPathPoints =  new java.util.Hashtable ();
var a2 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (a, null, false, true);
var b2 = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (b, null, false, true);
b2.canBePseudo = b2.isOddCumulene = isAxial;
var btop = this.getAtomChiralityLimited (b, b2, a2, ruleMax) - 1;
var c = 0;
if (atop >= 0 && btop >= 0) {
if (isAxial) {
c = (this.isPos (b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 34 : 33);
if ((a2.ties == null) != (b2.ties == null)) c |= 4;
} else {
c = (this.isCis (b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 8 : 16);
}}if (c != 0) {
a.setCIPChirality (c);
b.setCIPChirality (c);
if (JU.Logger.debugging) JU.Logger.info (a + "-" + b + " " + JV.JC.getCIPChiralityName (c));
}return c;
}, "JU.Node,JU.Node,~B,~N");
Clazz.defineMethod (c$, "isCis", 
function (a, b, c, d) {
JU.Measure.getNormalThroughPoints (a.atom.getXYZ (), b.atom.getXYZ (), c.atom.getXYZ (), this.vNorm, this.vTemp);
var vNorm2 =  new JU.V3 ();
JU.Measure.getNormalThroughPoints (b.atom.getXYZ (), c.atom.getXYZ (), d.atom.getXYZ (), vNorm2, this.vTemp);
return (this.vNorm.dot (vNorm2) > 0);
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "isPos", 
function (a, b, c, d) {
return (JU.Measure.computeTorsion (a.atom.getXYZ (), b.atom.getXYZ (), c.atom.getXYZ (), d.atom.getXYZ (), true) > 0);
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "sign", 
function (score) {
return (score < 0 ? -1 : score > 0 ? 1 : 0);
}, "~N");
c$.$CIPChirality$CIPAtom$ = function () {
Clazz.pu$h(self.c$);
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.atom = null;
this.id = 0;
this.parent = null;
this.rootSubstituent = null;
this.elemNo = 0;
this.massNo = 0;
this.sphere = 0;
this.bsPath = null;
this.myPath = "";
this.rootDistance = 0;
this.nAtoms = 0;
this.nPriorities = 0;
this.h1Count = 0;
this.knownAtomChirality = "~";
this.isSet = false;
this.isDuplicate = true;
this.isTerminal = false;
this.isAlkene = false;
this.alkeneParent = null;
this.isAlkeneAtom2 = false;
this.doCheckPseudo = false;
this.isPseudo = false;
this.achiral = false;
this.bondCount = 0;
this.atoms = null;
this.priorities = null;
this.prevPriorities = null;
this.rule4List = null;
this.lonePair = null;
this.atomIndex = 0;
this.auxEZ = -1;
this.auxParentReversed = null;
this.auxPseudo = null;
this.canBePseudo = true;
this.ties = null;
this.isOddCumulene = false;
this.nextSP2 = null;
Clazz.instantialize (this, arguments);
}, JS.CIPChirality, "CIPAtom", null, [Comparable, Cloneable]);
Clazz.prepareFields (c$, function () {
this.atoms =  new Array (4);
this.priorities =  Clazz.newIntArray (4, 0);
this.prevPriorities =  Clazz.newIntArray (4, 0);
});
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "create", 
function (a, b, c, d) {
this.id = ++this.b$["JS.CIPChirality"].ptID;
this.parent = b;
if (a == null) return this;
this.isAlkene = d;
this.atom = a;
this.elemNo = a.getElementNumber ();
this.massNo = a.getNominalMass ();
this.atomIndex = a.getIndex ();
this.bondCount = a.getCovalentBondCount ();
if (this.bondCount == 3 && !d && this.elemNo > 10) this.getLonePair ();
this.canBePseudo = (this.bondCount == 4 || this.bondCount == 3 && this.lonePair != null);
var e = a.getCIPChirality (false);
if (e.equals ("") || e.equals ("r") || e.equals ("s")) e = "~";
 else if (e.equals ("E")) e = "T";
 else if (e.equals ("Z")) e = "C";
this.knownAtomChirality = e;
if (b != null) this.sphere = b.sphere + 1;
if (this.sphere == 1) this.rootSubstituent = this;
 else if (b != null) this.rootSubstituent = b.rootSubstituent;
this.bsPath = (b == null ?  new JU.BS () : JU.BSUtil.copy (b.bsPath));
var f = c;
if (b == null) {
this.bsPath.set (this.atomIndex);
this.rootDistance = 0;
} else if (a === this.b$["JS.CIPChirality"].root.atom) {
this.rootDistance = 0;
if (this.sphere > this.b$["JS.CIPChirality"].maxRingSize) this.b$["JS.CIPChirality"].maxRingSize = this.sphere;
c = true;
} else if (this.bsPath.get (this.atomIndex)) {
c = true;
this.rootDistance = this.b$["JS.CIPChirality"].htPathPoints.get (this.rootSubstituent.atom.toString () + a).intValue ();
} else {
this.bsPath.set (this.atomIndex);
this.rootDistance = b.rootDistance + 1;
this.b$["JS.CIPChirality"].htPathPoints.put (this.rootSubstituent.atom.toString () + a,  new Integer (this.rootDistance));
}this.isDuplicate = c;
this.myPath = (b != null ? b.myPath + "-" : "") + this;
if (JU.Logger.debugging) JU.Logger.info ("new CIPAtom " + b + "->" + this);
if (c && !f) this.updateRingList ();
return this;
}, "JU.Node,JS.CIPChirality.CIPAtom,~B,~B");
Clazz.defineMethod (c$, "getLonePair", 
 function () {
var a = this.b$["JS.CIPChirality"].getTrigonality (this.atom, this.b$["JS.CIPChirality"].vNorm);
if (Math.abs (a) > 0.2) {
this.lonePair =  new JU.P3 ();
this.b$["JS.CIPChirality"].vNorm.scale (a);
this.lonePair.add2 (this.atom.getXYZ (), this.b$["JS.CIPChirality"].vNorm);
}});
Clazz.defineMethod (c$, "updateRingList", 
 function () {
var a = JU.BSUtil.newAndSetBit (this.atomIndex);
var b = this;
var c = -1;
while ((b = b.parent) != null && c != this.atomIndex) {
a.set (c = b.atomIndex);
}
if (a.cardinality () < 8) {
for (var d = this.b$["JS.CIPChirality"].lstSmallRings.size (); --d >= 0; ) if (this.b$["JS.CIPChirality"].lstSmallRings.get (d).equals (a)) return;

this.b$["JS.CIPChirality"].lstSmallRings.addLast (a);
}});
Clazz.defineMethod (c$, "set", 
function () {
if (this.isSet) return true;
this.isSet = true;
if (this.isDuplicate) return true;
var a = this.atom.getBondCount ();
var b = this.atom.getEdges ();
if (JU.Logger.debuggingHigh) JU.Logger.info ("set " + this);
var c = 0;
for (var d = 0; d < a; d++) {
var e = b[d];
if (!e.isCovalent ()) continue;
var f = e.getOtherAtomNode (this.atom);
var g = (this.parent != null && this.parent.atom === f);
var h = e.getCovalentOrder ();
if (h == 2) {
if (this.elemNo > 10 || !this.b$["JS.CIPChirality"].isFirstRow (f)) h = 1;
 else {
this.isAlkene = true;
if (g) {
this.knownAtomChirality = e.getCIPChirality (false);
if (this.atom.getCovalentBondCount () == 2 && this.atom.getValence () == 4) {
this.parent.isAlkeneAtom2 = false;
} else {
this.isAlkeneAtom2 = true;
}this.alkeneParent = (this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent);
if (this.parent.alkeneParent == null) this.parent.nextSP2 = this;
}}}if (a == 1 && h == 1 && g) {
this.isTerminal = true;
return true;
}switch (h) {
case 3:
if (this.addAtom (c++, f, g, false) == null) {
this.isTerminal = true;
return false;
}case 2:
if (this.addAtom (c++, f, h != 2 || g, h == 2) == null) {
this.isTerminal = true;
return false;
}case 1:
if (!g && this.addAtom (c++, f, h != 1 && this.elemNo <= 10, false) == null) {
this.isTerminal = true;
return false;
}break;
default:
this.isTerminal = true;
return false;
}
}
this.isTerminal = (c == 0);
this.nAtoms = c;
for (; c < this.atoms.length; c++) this.atoms[c] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (null, this, true, false);

var e = this.b$["JS.CIPChirality"].currentRule;
this.b$["JS.CIPChirality"].currentRule = 1;
java.util.Arrays.sort (this.atoms);
this.b$["JS.CIPChirality"].currentRule = e;
return !this.isTerminal;
});
Clazz.defineMethod (c$, "addAtom", 
function (a, b, c, d) {
if (a >= this.atoms.length) {
if (JU.Logger.debugging) JU.Logger.info (" too many bonds on " + this.atom);
return null;
}if (this.parent == null && this.b$["JS.CIPChirality"].currentRule != 0) {
var e = b.getAtomicAndIsotopeNumber ();
if (e == 1) {
if (++this.h1Count > 1) {
if (JU.Logger.debugging) JU.Logger.info (" second H atom found on " + this.atom);
return null;
}}}this.atoms[a] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (b, this, c, d);
if (this.b$["JS.CIPChirality"].currentRule > 2) this.prevPriorities[a] = this.getBasePriority (this.atoms[a]);
return this.atoms[a];
}, "~N,JU.Node,~B,~B");
Clazz.defineMethod (c$, "sortSubstituents", 
function () {
if (JU.Logger.debugging) {
JU.Logger.info (this.b$["JS.CIPChirality"].root + "---sortSubstituents---" + this);
for (var a = 0; a < 4; a++) {
JU.Logger.info (this.b$["JS.CIPChirality"].getRuleName () + ": " + this + "[" + a + "]=" + this.atoms[a].myPath + " " + Integer.toHexString (this.prevPriorities[a]));
}
JU.Logger.info ("---");
}var a =  Clazz.newIntArray (4, 0);
this.ties = null;
for (var b = 0; b < 4; b++) {
this.priorities[b] = 1;
if (this.prevPriorities[b] == 0 && this.b$["JS.CIPChirality"].currentRule > 1) this.prevPriorities[b] = this.getBasePriority (this.atoms[b]);
}
var c = (this.b$["JS.CIPChirality"].currentRule > 3 && this.rule4List != null);
for (var d = 0; d < 4; d++) {
var e = this.atoms[d];
for (var f = d + 1; f < 4; f++) {
var g = this.atoms[f];
var h = (e.atom == null ? 1 : g.atom == null ? -1 : this.prevPriorities[d] == this.prevPriorities[f] ? 0 : this.prevPriorities[f] < this.prevPriorities[d] ? 1 : -1);
if (h == 0) h = (c ? this.checkRule4And5 (d, f) : e.compareTo (g));
if (JU.Logger.debuggingHigh) JU.Logger.info ("ordering " + this.id + "." + d + "." + f + " " + this + "-" + e + " vs " + g + " = " + h);
switch (h) {
case -2147483648:
if (c && this.sphere == 0) this.achiral = true;
a[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this.atom + "." + g + " ends up with tie with " + e);
break;
case 1:
a[d]++;
this.priorities[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this + "." + g + " B-beats " + e);
break;
case -1:
a[f]++;
this.priorities[f]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this + "." + e + " A-beats " + g);
break;
case 0:
h = e.breakTie (g);
switch (this.b$["JS.CIPChirality"].sign (h)) {
case 0:
a[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this + "." + g + " ends up with tie with " + e);
break;
case 1:
a[d]++;
this.priorities[d]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this + "." + g + " wins in tie with " + e);
break;
case -1:
a[f]++;
this.priorities[f]++;
if (JU.Logger.debuggingHigh) JU.Logger.info (this + "." + e + " wins in tie with " + g);
break;
}
break;
}
if (this.doCheckPseudo) {
this.doCheckPseudo = false;
if (this.ties == null) this.ties =  new JU.Lst ();
this.ties.addLast ( Clazz.newIntArray (-1, [d, f]));
}}
}
var e =  new Array (4);
var f =  Clazz.newIntArray (4, 0);
var g =  Clazz.newIntArray (4, 0);
var h =  new JU.BS ();
var i = JS.CIPChirality.PRIORITY_SHIFT[this.b$["JS.CIPChirality"].currentRule];
for (var j = 0; j < 4; j++) {
var k = a[j];
var l = e[k] = this.atoms[j];
var m = this.priorities[j];
f[k] = m;
g[k] = this.prevPriorities[j] | (m << i);
if (l.atom != null) h.set (this.priorities[j]);
}
this.atoms = e;
this.priorities = f;
this.prevPriorities = g;
this.nPriorities = h.cardinality ();
if (this.nPriorities > this.b$["JS.CIPChirality"].nPriorityMax) this.b$["JS.CIPChirality"].nPriorityMax = this.nPriorities;
if (this.ties != null && !this.isOddCumulene) {
switch (this.ties.size ()) {
case 1:
this.checkPseudoHandedness (this.ties.get (0), a);
break;
case 2:
this.canBePseudo = false;
break;
}
}if (JU.Logger.debugging) {
JU.Logger.info (this.atom + " nPriorities = " + this.nPriorities);
for (var k = 0; k < 4; k++) JU.Logger.info (this.myPath + "[" + k + "]=" + this.atoms[k] + " " + this.priorities[k] + " new");

JU.Logger.info ("-------");
}});
Clazz.defineMethod (c$, "breakTie", 
 function (a) {
var b = this.checkDuplicate (a);
if (b != 0) return b * this.sphere;
if ((this.atom == null) != (a.atom == null)) return (this.atom == null ? 1 : -1) * (this.sphere + 1);
if (!this.set () || !a.set () || this.isTerminal && a.isTerminal || this.isDuplicate && a.isDuplicate) return 0;
if (this.isTerminal != a.isTerminal) return (this.isTerminal ? 1 : -1) * (this.sphere + 1);
if (JU.Logger.debugging) JU.Logger.info ("tie for " + this + " and " + a);
if ((b = this.compareShallow (a)) != 0) return b;
this.sortSubstituents ();
a.sortSubstituents ();
return this.compareDeep (a);
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "compareShallow", 
 function (a) {
for (var b = 0; b < this.nAtoms; b++) {
var c = this.atoms[b];
var d = a.atoms[b];
if (c == null || d == null) return (c == null ? 1 : d == null ? -1 : 0);
var e = c.checkCurrentRule (d);
if (e == -2147483648) e = 0;
if (e != 0) {
if (JU.Logger.debugging) JU.Logger.info ("compareShallow " + c + " " + d + ": " + e * this.sphere);
return e * this.sphere;
}}
return 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "compareDeep", 
 function (a) {
var b = (this.nAtoms == 0 ? 1 : 0);
var c = 2147483647;
for (var d = 0; d < this.nAtoms; d++) {
var e = this.atoms[d];
var f = a.atoms[d];
var g = e.breakTie (f);
if (g == 0) continue;
var h = Math.abs (g);
if (h < c) {
c = h;
b = g;
}}
if (JU.Logger.debugging) JU.Logger.info ("compareDeep " + this + " " + a + ": " + b);
return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.overrideMethod (c$, "compareTo", 
function (a) {
var b;
return (a == null ? -1 : (this.atom == null) != (a.atom == null) ? (this.atom == null ? 1 : -1) : (b = this.checkCurrentRule (a)) == -2147483648 ? 0 : b != 0 ? b : this.checkDuplicate (a));
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkDuplicate", 
 function (a) {
return a.isDuplicate == this.isDuplicate ? 0 : a.isDuplicate ? -1 : 1;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkCurrentRule", 
function (a) {
switch (this.b$["JS.CIPChirality"].currentRule) {
default:
case 0:
return a.atom === this.atom ? 0 : a.atom == null ? -1 : this.atom == null ? 1 : 0;
case 1:
var b = this.checkRule1a (a);
return (b == 0 ? this.checkRule1b (a) : b);
case 2:
return this.checkRule2 (a);
case 3:
return this.checkRule3 (a);
case 4:
return 0;
case 5:
return this.checkRule5 (a);
}
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule1a", 
 function (a) {
return a.atom === this.atom ? 0 : a.atom == null ? -1 : this.atom == null ? 1 : a.elemNo < this.elemNo ? -1 : a.elemNo > this.elemNo ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule1b", 
 function (a) {
return !a.isDuplicate || !this.isDuplicate ? 0 : a.rootDistance < this.rootDistance ? 1 : a.rootDistance > this.rootDistance ? -1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule2", 
 function (a) {
return a.massNo < this.massNo ? -1 : a.massNo > this.massNo ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule3", 
 function (a) {
var b;
var c;
return this.parent == null || !this.parent.isAlkeneAtom2 || !a.parent.isAlkeneAtom2 || this.isDuplicate || a.isDuplicate || !this.isCumulativeType (-2) || !a.isCumulativeType (-2) ? -2147483648 : this.parent === a.parent ? this.b$["JS.CIPChirality"].sign (this.breakTie (a)) : (b = this.parent.getEZaux ()) < (c = a.parent.getEZaux ()) ? -1 : b > c ? 1 : 0;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "isCumulativeType", 
 function (a) {
return (this.parent != null && this.parent.isAlkeneAtom2 && ((this.parent.alkeneParent.sphere + this.parent.sphere) % 2) == (a == -2 ? 1 : 2));
}, "~N");
Clazz.defineMethod (c$, "getEZaux", 
 function () {
if (this.auxEZ == -1 && (this.auxEZ = this.alkeneParent.auxEZ) == -1) {
var a = null;
var b = null;
var c = null;
this.auxEZ = 24;
this.sortSubstituents ();
b = this.getTopAtom ();
if (b != null) {
if (this.auxParentReversed == null) {
if (JU.Logger.debugging) JU.Logger.info ("reversing path for " + this.alkeneParent);
c = this.alkeneParent.clone ();
c.addReturnPath (this.alkeneParent.nextSP2, this.alkeneParent);
} else {
c = this.auxParentReversed;
}c.sortSubstituents ();
a = c.getTopAtom ();
if (a != null) {
this.auxEZ = (this.b$["JS.CIPChirality"].isCis (b, this, c, a) ? 8 : 16);
}}}this.alkeneParent.auxEZ = this.auxEZ;
if (JU.Logger.debugging) JU.Logger.info ("getZaux " + this.alkeneParent + " " + this.auxEZ);
return this.auxEZ;
});
Clazz.defineMethod (c$, "getReturnPath", 
 function (a) {
var b =  new JU.Lst ();
while (a.parent != null && a.parent.atoms[0] != null) {
if (JU.Logger.debugging) JU.Logger.info ("path:" + a.parent.atom + "->" + a.atom);
b.addLast (a = a.parent);
}
b.addLast (null);
return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "addReturnPath", 
 function (a, b) {
var c = this.getReturnPath (b);
var d = this;
for (var e = 0, f = c.size (); e < f; e++) {
var g = c.get (e);
if (g == null) {
g = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (null, this, true, this.isAlkene);
} else {
var h = g.sphere;
g = g.clone ();
g.sphere = h + 1;
}d.replaceParentSubstituent (a, g);
if (a == null) break;
a = a.parent;
d = g;
}
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkRule4And5", 
 function (a, b) {
if (this.rule4List[a] == null && this.rule4List[b] == null) return 0;
if (this.rule4List[a] == null || this.rule4List[b] == null) return this.rule4List[b] == null ? -1 : 1;
return this.compareMataPair (a, b);
}, "~N,~N");
Clazz.defineMethod (c$, "compareMataPair", 
 function (a, b) {
var c = (this.b$["JS.CIPChirality"].currentRule == 5);
var d = this.rule4List[a];
var e = this.rule4List[b];
if (d != null && d.indexOf ("?") == 1) {
d = this.getMataList (a, c);
e = this.getMataList (b, c);
if (d.length != e.length) {
return (d.length < e.length ? -1 : 1);
}if (c) return d.compareTo (e);
if (d.indexOf ("|") >= 0 || e.indexOf ("|") >= 0) {
var f = JU.PT.split (d, "|");
var g = JU.PT.split (e, "|");
var h = 2147483647;
var i = 0;
d = f[0];
e = g[0];
for (var j = 0; j < 2; j++) {
for (var k = 0; k < 2; k++) {
var l = this.compareRule4PairStr (f[j], g[k], true);
i += l;
if (l != 0 && Math.abs (l) <= h) {
h = Math.abs (l);
d = f[j];
e = g[k];
}}
}
if (i == 0) return 0;
}} else {
d = JU.PT.rep (d.substring (1), "~", "");
e = JU.PT.rep (e.substring (1), "~", "");
}return this.compareRule4PairStr (d, e, false);
}, "~N,~N");
Clazz.defineMethod (c$, "compareRule4PairStr", 
 function (a, b, c) {
System.out.println (this + " Rule 4b comparing " + a + " " + b);
this.doCheckPseudo = false;
var d = a.length;
if (d == 0 || d != b.length) return 0;
var e = a.charAt (0);
var f = b.charAt (0);
for (var g = 1; g < d; g++) {
var h = (e == a.charAt (g));
var i = (f == b.charAt (g));
if (h != i) return (c ? g : 1) * (h ? -1 : 1);
}
if (c) return 0;
if (e == f) return -2147483648;
if (!this.canBePseudo) this.b$["JS.CIPChirality"].root.canBePseudo = false;
this.doCheckPseudo = this.canBePseudo && (e == 'R' || e == 'S');
return e < f ? -1 : 1;
}, "~S,~S,~B");
Clazz.defineMethod (c$, "getMataList", 
 function (a, b) {
var c = this.atoms[a].rule4List;
var d = 0;
for (var e = c.length; --e >= 0; ) if (c[e] != null) d++;

var f =  new Array (d);
for (var g = c.length; --g >= 0; ) if (c[g] != null) f[--d] = c[g];

java.util.Arrays.sort (f);
var h = (b ? "R" : this.getMataRef (f));
switch (h.length) {
default:
case 0:
System.out.println ("???");
return "???";
case 1:
return this.getMataSequence (f, h, b);
case 2:
return this.getMataSequence (f, "R", false) + "|" + this.getMataSequence (f, "S", false);
}
}, "~N,~B");
Clazz.defineMethod (c$, "getMataSequence", 
 function (a, b, c) {
var d = (c ? a : this.getMataSortedList (a, b));
var e = d.length;
var f = 0;
for (var g = 0; g < e; g++) {
var h = d[g];
if (h.length > f) f = h.length;
}
var h = "";
var i;
for (var j = 1; j < f; j++) {
for (var k = 0; k < e; k++) {
var l = d[k];
if (j < l.length && (i = l.charAt (j)) != '~' && i != ';') h += i;
}
if (c) {
for (var l = 0; l < e; l++) {
var m = d[l];
if (j < m.length) d[l] = m.substring (0, j) + "~" + m.substring (j + 1);
}
java.util.Arrays.sort (d);
}}
return h;
}, "~A,~S,~B");
Clazz.defineMethod (c$, "getMataSortedList", 
 function (a, b) {
var c = a.length;
var d =  new Array (c);
for (var e = 0; e < c; e++) d[e] = JU.PT.rep (a[e], b, "A");

java.util.Arrays.sort (d);
for (var f = 0; f < c; f++) d[f] = JU.PT.rep (d[f], "A", b);

if (JU.Logger.debuggingHigh) for (var g = 0; g < c; g++) JU.Logger.info ("Sorted Mata list " + g + " " + d[g]);

return d;
}, "~A,~S");
Clazz.defineMethod (c$, "getMataRef", 
 function (a) {
var b = 2147483647;
for (var c = 0; c < a.length; c++) {
var d = a[c];
var e = 1;
for (var f = d.length; e < f; e++) if (d.charAt (e) != '~') break;

if (e < b) b = e;
}
switch (a.length) {
case 1:
return a[0].substring (b, b + 1);
case 2:
var d = a[0].charAt (0);
var e = a[1].charAt (0);
var f = a[0].charAt (b);
var g = a[1].charAt (b);
return (f == g || g == '~' || d < e && f != '~' ? "" + f : d == e ? "RS" : "" + g);
case 3:
var h = a[0].charAt (0);
var i = a[1].charAt (0);
var j = a[2].charAt (0);
var k = a[0].charAt (b);
var l = a[1].charAt (b);
var m = a[2].charAt (b);
if (h == i && i == j) return (k == l || l == '~' ? "" + k : l == m ? "" + m : "RS");
if (h == i) return (h == '~' ? "" + m : k == l || l == '~' ? "" + k : "RS");
if (i == j) return (h != '~' ? "" + k : l == m || m == '~' ? "" + l : "RS");
return "" + (k != '~' ? k : l != '~' ? l : m);
}
return "";
}, "~A");
Clazz.defineMethod (c$, "createAuxiliaryRSCenters", 
function (a) {
if (this.auxParentReversed != null) this.auxParentReversed.createAuxiliaryRSCenters (true);
if (this.auxPseudo != null) this.auxPseudo.createAuxiliaryRSCenters (true);
var b = -1;
var c = "";
var d = (a ? "" : "~");
var e = true;
if (this.atom != null) {
this.rule4List =  new Array (4);
var f =  Clazz.newIntArray (4, 0);
var g = 0;
for (var h = 0; h < 4; h++) {
var i = this.atoms[h];
if (i != null && !i.isDuplicate && !i.isTerminal) {
var j = i.createAuxiliaryRSCenters (false);
this.rule4List[h] = this.priorities[h] + j;
if ("sr".indexOf (j) >= 0 || j.indexOf ("R") >= 0 || j.indexOf ("S") >= 0) {
f[g] = h;
g++;
c += j + ";";
} else {
this.rule4List[h] = null;
}}}
var i = 0;
switch (g) {
case 0:
c = "";
break;
case 1:
break;
case 2:
if (!a) {
switch (i = (this.compareRule4aEnantiomers (this.rule4List[f[0]], this.rule4List[f[1]]))) {
case 2147483647:
e = false;
break;
case -2147483648:
e = false;
i = 0;
break;
case 0:
c = "";
break;
case -1:
case 1:
c = "";
break;
}
}break;
case 3:
case 4:
e = false;
}
if (!e) {
d = "?" + this.sphere;
c = "[" + c + "]";
} else if (!a && (this.bondCount == 4 && this.nPriorities >= 3 - Math.abs (i) || this.bondCount == 3 && this.elemNo > 10 && this.nPriorities >= 2 - Math.abs (i))) {
var j = this.clone ();
if (j.set ()) {
j.addReturnPath (null, this);
var k = this.b$["JS.CIPChirality"].currentRule;
this.b$["JS.CIPChirality"].currentRule = 1;
j.sortSubstituents ();
this.b$["JS.CIPChirality"].currentRule = k;
b = j.checkHandedness ();
d = (b == 1 ? "R" : b == 2 ? "S" : "~");
if (i != 0) d = d.toLowerCase ();
}}}d += c;
return d;
}, "~B");
Clazz.defineMethod (c$, "compareRule4aEnantiomers", 
 function (a, b) {
if (a.indexOf ("R") < 0 && a.indexOf ("S") < 0 || a.charAt (0) != b.charAt (0)) return -2147483648;
var c = a.length;
if (c != b.length) return -2147483648;
if (a.equals (b)) return 0;
var d = 0;
for (var e = 1; e < c; e++) {
var f = " RS".indexOf (a.charAt (e));
var g = f + " RS".indexOf (b.charAt (e));
if (g != 0 && g != 3) return 2147483647;
if (d == 0) d = (f == 1 ? -1 : 1);
}
return d;
}, "~S,~S");
Clazz.defineMethod (c$, "checkPseudoHandedness", 
 function (a, b) {
var c = a[0];
var d = a[1];
var e;
if (this.auxPseudo == null) {
e = this.clone ();
e.atoms[b[c]] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (null, e, false, this.isAlkene);
e.atoms[b[d]] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null).create (null, e, false, this.isAlkene);
e.addReturnPath (null, this);
} else {
e = this.auxPseudo;
}var f = this.b$["JS.CIPChirality"].currentRule;
this.b$["JS.CIPChirality"].currentRule = 1;
e.sortSubstituents ();
this.b$["JS.CIPChirality"].currentRule = f;
e.atoms[this.bondCount - 2] = this.atoms[Math.min (b[c], b[d])];
e.atoms[this.bondCount - 1] = this.atoms[Math.max (b[c], b[d])];
var g = e.checkHandedness ();
if (JU.Logger.debugging) {
for (var h = 0; h < 4; h++) JU.Logger.info ("pseudo " + g + " " + this.priorities[h] + " " + this.atoms[h].myPath);

}if (g == 1 || g == 2) {
this.isPseudo = true;
}}, "~A,~A");
Clazz.defineMethod (c$, "getBasePriority", 
 function (a) {
var b = 0;
if (a.atom == null) {
b = 0x7FFFF << JS.CIPChirality.PRIORITY_SHIFT[2];
} else {
b = ((127 - a.elemNo) << JS.CIPChirality.PRIORITY_SHIFT[0]) | ((255 - a.massNo) << JS.CIPChirality.PRIORITY_SHIFT[2]);
}return b;
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "resetAuxiliaryChirality", 
function () {
this.auxEZ = -1;
for (var a = 0; a < 4; a++) if (this.atoms[a] != null && this.atoms[a].atom != null) this.atoms[a].resetAuxiliaryChirality ();

if (this.auxParentReversed != null) this.auxParentReversed.resetAuxiliaryChirality ();
if (this.auxPseudo != null) this.auxPseudo.resetAuxiliaryChirality ();
});
Clazz.defineMethod (c$, "replaceParentSubstituent", 
 function (a, b) {
for (var c = 0; c < 4; c++) if (this.atoms[c] === a || a == null && this.atoms[c].atom == null) {
this.atoms[c] = b;
if (JU.Logger.debugging) JU.Logger.info ("replace " + this + "[" + c + "]=" + b);
this.prevPriorities[c] = this.getBasePriority (this.atoms[c]);
this.parent = a;
return;
}
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "getTopAtom", 
 function () {
var a = (this.atoms[0].isDuplicate ? 1 : 0);
return this.priorities[a] == this.priorities[a + 1] ? null : this.priorities[a] < this.priorities[a + 1] ? this.atoms[a] : this.atoms[a + 1];
});
Clazz.defineMethod (c$, "getWorkingChirality", 
 function () {
return ("rs".indexOf (this.knownAtomChirality) >= 0 ? "~" : this.knownAtomChirality);
});
Clazz.defineMethod (c$, "checkRule5", 
 function (a) {
if (this.isTerminal || this.isDuplicate) return 0;
var b = ";srSR;".indexOf (this.getWorkingChirality ());
var c = ";srSR;".indexOf (a.getWorkingChirality ());
return (b == c ? 0 : b > c ? -1 : 1);
}, "JS.CIPChirality.CIPAtom");
Clazz.defineMethod (c$, "checkHandedness", 
function () {
var a = this.atoms[0].atom.getXYZ ();
var b = this.atoms[1].atom.getXYZ ();
var c = this.atoms[2].atom.getXYZ ();
var d = (this.lonePair == null ? this.atoms[3].atom.getXYZ () : this.lonePair);
var e = JU.Measure.getNormalThroughPoints (a, b, c, this.b$["JS.CIPChirality"].vNorm, this.b$["JS.CIPChirality"].vTemp);
return (JU.Measure.distanceToPlaneV (this.b$["JS.CIPChirality"].vNorm, e, d) > 0 ? 1 : 2);
});
Clazz.defineMethod (c$, "clone", 
function () {
var a = null;
try {
a = Clazz.superCall (this, JS.CIPChirality.CIPAtom, "clone", []);
} catch (e) {
if (Clazz.exceptionOf (e, CloneNotSupportedException)) {
} else {
throw e;
}
}
a.id = this.b$["JS.CIPChirality"].ptID++;
a.atoms =  new Array (4);
a.priorities =  Clazz.newIntArray (4, 0);
a.prevPriorities =  Clazz.newIntArray (4, 0);
for (var b = 0; b < 4; b++) {
a.priorities[b] = this.priorities[b];
if (this.atoms[b] != null) {
a.atoms[b] = this.atoms[b];
a.prevPriorities[b] = this.getBasePriority (this.atoms[b]);
}}
if (JU.Logger.debugging) JU.Logger.info ("cloning " + this + " as " + a);
return a;
});
Clazz.defineMethod (c$, "toString", 
function () {
return (this.atom == null ? "<null>" : "[" + this.b$["JS.CIPChirality"].currentRule + "." + this.sphere + "." + this.atom.getAtomName () + (this.isDuplicate ? "*" : "") + "]");
});
c$ = Clazz.p0p ();
};
Clazz.defineStatics (c$,
"NO_CHIRALITY", 0,
"TIED", 0,
"B_WINS", 1,
"A_WINS", -1,
"DIASTEREOMERIC", 2147483647,
"IGNORE", -2147483648,
"NOT_RELEVANT", -2147483648,
"STEREO_SAME", 2147483647,
"STEREO_UNDETERMINED", -1,
"STEREO_RS", -1,
"STEREO_EZ", -2,
"STEREO_ALLENE", -3,
"STEREO_R", 1,
"STEREO_S", 2,
"STEREO_M", 33,
"STEREO_P", 34,
"STEREO_Z", 8,
"STEREO_E", 16,
"STEREO_BOTH_RS", 3,
"STEREO_BOTH_EZ", 24,
"RULE_0", 0,
"RULE_1", 1,
"RULE_2", 2,
"RULE_3", 3,
"RULE_4", 4,
"RULE_5", 5,
"TRIGONALITY_MIN", 0.2,
"PRIORITY_SHIFT",  Clazz.newIntArray (-1, [24, 20, 12, 8, 4, 0]));
});
