/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.binding.ConstantField;
import org.jruby.javasupport.binding.ConstructorInvokerInstaller;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.binding.InstanceMethodInvokerInstaller;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.javasupport.binding.NamedInstaller;
import org.jruby.javasupport.binding.Priority;

final class ClassInitializer
extends Initializer {
    ClassInitializer(Ruby runtime, Class<?> javaClass) {
        super(runtime, javaClass);
    }

    @Override
    public RubyClass initialize(RubyModule proxy2) {
        RubyClass proxyClass = (RubyClass)proxy2;
        Initializer.State state2 = new Initializer.State(this.runtime, this.javaClass.getSuperclass());
        ClassInitializer.setupClassFields(this.javaClass, state2);
        this.setupClassMethods(this.javaClass, state2);
        this.setupClassConstructors(this.javaClass, state2);
        this.runtime.getJavaSupport().getStaticAssignedNames().get(this.javaClass).putAll(state2.staticNames);
        this.runtime.getJavaSupport().getInstanceAssignedNames().get(this.javaClass).putAll(state2.instanceNames);
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
        Class<?> enclosingClass = this.javaClass.getEnclosingClass();
        RubyModule parent = enclosingClass != null ? Java.getProxyClass(this.runtime, enclosingClass) : Java.getJavaPackageModule(this.runtime, this.javaClass.getPackage());
        proxy2.setParent(parent);
        if (this.javaClass.isMemberClass()) {
            proxy2.setBaseName(this.javaClass.getSimpleName());
        } else {
            String baseName = this.javaClass.getSimpleName();
            if (enclosingClass != null) {
                int offset2;
                String className = this.javaClass.getName();
                int length2 = className.length();
                if (length2 > (offset2 = enclosingClass.getName().length()) && className.charAt(offset2) != '$') {
                    baseName = className.substring(offset2);
                } else if (length2 > offset2 + 1) {
                    baseName = className.substring(offset2 + 1);
                }
            }
            proxy2.setBaseName(baseName);
        }
        ClassInitializer.installClassFields(proxyClass, state2);
        ClassInitializer.installClassInstanceMethods(proxyClass, state2);
        ClassInitializer.installClassConstructors(proxyClass, state2);
        ClassInitializer.installClassClasses(this.javaClass, proxyClass);
        proxyClass.getName();
        return proxyClass;
    }

    private static void installClassInstanceMethods(RubyClass proxy2, Initializer.State state2) {
        ClassInitializer.installClassStaticMethods(proxy2, state2);
        for (Map.Entry<String, NamedInstaller> entry : state2.instanceInstallers.entrySet()) {
            entry.getValue().install(proxy2);
        }
    }

    private static void setupClassFields(Class<?> javaClass, Initializer.State state2) {
        Field[] fields2 = JavaClass.getFields(javaClass);
        int i2 = fields2.length;
        while (--i2 >= 0) {
            Field field2 = fields2[i2];
            if (javaClass != field2.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field2)) {
                state2.constantFields.add(new ConstantField(field2));
                continue;
            }
            int modifiers2 = field2.getModifiers();
            if (Modifier.isStatic(modifiers2)) {
                ClassInitializer.addField(state2.staticInstallers, state2.staticNames, field2, Modifier.isFinal(modifiers2), true);
                continue;
            }
            ClassInitializer.addField(state2.instanceInstallers, state2.instanceNames, field2, Modifier.isFinal(modifiers2), false);
        }
    }

    private void setupClassMethods(Class<?> javaClass, Initializer.State state2) {
        Map<String, List<Method>> nameMethods = ClassInitializer.getMethods(javaClass);
        for (Map.Entry<String, List<Method>> entry : nameMethods.entrySet()) {
            List<Method> methods2 = entry.getValue();
            int i2 = methods2.size();
            while (--i2 >= 0) {
                Method method = methods2.get(i2);
                String name2 = method.getName();
                if (Modifier.isStatic(method.getModifiers())) {
                    ClassInitializer.prepareStaticMethod(javaClass, state2, method, name2);
                    continue;
                }
                this.prepareInstanceMethod(javaClass, state2, method, name2);
            }
        }
        ClassInitializer.handleScalaSingletons(javaClass, state2);
        ClassInitializer.assignStaticAliases(state2);
        ClassInitializer.assignInstanceAliases(state2);
    }

    private void setupClassConstructors(Class<?> javaClass, Initializer.State state2) {
        Constructor[] constructors2 = JavaClass.getConstructors(javaClass);
        ConstructorInvokerInstaller constructorInstaller = new ConstructorInvokerInstaller("__jcreate!");
        int i2 = constructors2.length;
        while (--i2 >= 0) {
            constructorInstaller.addConstructor(constructors2[i2], javaClass);
        }
        state2.constructorInstaller = constructorInstaller;
    }

    private void prepareInstanceMethod(Class<?> javaClass, Initializer.State state2, Method method, String name2) {
        AssignedName assignedName = state2.instanceNames.get(name2);
        if (INSTANCE_RESERVED_NAMES.containsKey(method.getName())) {
            ClassInitializer.setupInstanceMethods(state2.instanceInstallers, javaClass, method, name2 + "__method");
            return;
        }
        if (assignedName == null) {
            state2.instanceNames.put(name2, new AssignedName(name2, Priority.METHOD));
        } else {
            if (Priority.METHOD.lessImportantThan(assignedName)) {
                return;
            }
            if (!Priority.METHOD.asImportantAs(assignedName)) {
                state2.instanceInstallers.remove(name2);
                state2.instanceInstallers.remove(name2 + '=');
                state2.instanceNames.put(name2, new AssignedName(name2, Priority.METHOD));
            }
        }
        ClassInitializer.setupInstanceMethods(state2.instanceInstallers, javaClass, method, name2);
    }

    private static void setupInstanceMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new InstanceMethodInvokerInstaller(name2);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    private static void assignInstanceAliases(Initializer.State state2) {
        for (Map.Entry<String, NamedInstaller> entry : state2.instanceInstallers.entrySet()) {
            if (entry.getValue().type != 4) continue;
            MethodInstaller methodInstaller = (MethodInstaller)entry.getValue();
            if (entry.getKey().endsWith("__method")) continue;
            if (methodInstaller.hasLocalMethod()) {
                ClassInitializer.assignAliases(methodInstaller, state2.instanceNames);
            }
            if (!entry.getKey().equals("equals")) continue;
            methodInstaller.setLocalMethod(true);
            methodInstaller.addAlias("==");
        }
    }

    private static void installClassConstructors(RubyModule proxy2, Initializer.State state2) {
        if (state2.constructorInstaller != null) {
            state2.constructorInstaller.install(proxy2);
        }
    }
}

