/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.BasicTable;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorPreferencesRepository;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorUIConfRepository;
import net.sourceforge.glsof.filemonitor.thread.AbstractMonitorTableUpdater;
import net.sourceforge.glsof.filemonitor.thread.LocalMonitorTableUpdater;
import net.sourceforge.glsof.filemonitor.thread.RemoteMonitorTableUpdater;

public class MonitorTable
extends BasicTable
implements Observer {
    public static final String[] COLUMN_NAMES = new String[]{Messages.NLS("PROCESS"), "PID", "TID", "PGID", "PPID", Messages.NLS("USER"), "FD", Messages.NLS("TYPE"), Messages.NLS("DEVICE"), Messages.NLS("SIZE"), "NLINK", Messages.NLS("NODE"), Messages.NLS("NAME"), Messages.NLS("STATUS")};
    private boolean _autoscroll;
    private AbstractMonitorTableUpdater _threadUpdater;
    private FileMonitorPreferencesRepository _preferencesRepository;

    public MonitorTable(FileMonitorPreferencesRepository preferencesRepository) {
        super(new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }, COLUMN_NAMES);
        this._preferencesRepository = preferencesRepository;
        this.getColumn(COLUMN_NAMES[COLUMN_NAMES.length - 1]).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (JComponent)value;
            }
        });
        this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        this.setFillsViewportHeight(true);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    MonitorTable.this.createColumnsMenuContent(menu);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        if (FileMonitorPreferencesRepository.getCurrentPreferences() != null) {
            this.showColumns(this.getColumns());
        }
        this.setAutoscroll(FileMonitorUIConfRepository.getUiConf().isAutoscroll());
    }

    JPanel pack() {
        JPanel tablePanel = new JPanel(new GridLayout(0, 1));
        tablePanel.add(new JScrollPane(this));
        return tablePanel;
    }

    private void createColumnsMenuContent(JPopupMenu columns) {
        if (FileMonitorPreferencesRepository.getCurrentPreferences() == null) {
            return;
        }
        final List<Boolean> views = this.getColumns();
        int i = 0;
        while (i < COLUMN_NAMES.length - 1) {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(COLUMN_NAMES[i]);
            item.setUI(new CheckBoxMenuItemUI());
            columns.add(item);
            item.setSelected(views.get(i));
            final int index = i++;
            item.addActionListener(new ActionListener(){
                final int _index;
                {
                    this._index = index;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    views.set(this._index, item.isSelected());
                    MonitorTable.this.showColumn((Boolean)views.get(index), index);
                    MonitorTable.this._preferencesRepository.updateColumns(views);
                }
            });
        }
    }

    private List<Boolean> getColumns() {
        List<Boolean> columns = FileMonitorPreferencesRepository.getCurrentPreferences().getColumns();
        for (int diff = COLUMN_NAMES.length - columns.size() - 1; diff > 0; --diff) {
            columns.add(true);
        }
        return columns;
    }

    public void addRows(List<Object[]> rows) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        for (Object[] row : rows) {
            model.addRow(row);
        }
        if (this._autoscroll) {
            this.scrollRectToVisible(this.getCellRect(this.getRowCount() - 1, 0, true));
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int hitRowIndex = this.rowAtPoint(e.getPoint());
        return hitRowIndex == -1 ? "" : this.getRowToolTipText(hitRowIndex).toString();
    }

    private StringBuilder getRowToolTipText(int hitRowIndex) {
        List<Boolean> views = FileMonitorPreferencesRepository.getCurrentPreferences().getColumns();
        StringBuilder tip = new StringBuilder("<html>");
        int visibleIndex = 0;
        for (int i = 0; i < views.size(); ++i) {
            if (!views.get(i).booleanValue()) continue;
            TableCellRenderer renderer = this.getCellRenderer(hitRowIndex, visibleIndex);
            String cellText = ((DefaultTableCellRenderer.UIResource)this.prepareRenderer(renderer, hitRowIndex, visibleIndex)).getText();
            tip.append(COLUMN_NAMES[i]).append(": ").append(cellText).append("<br>");
            ++visibleIndex;
        }
        TableCellRenderer renderer = this.getCellRenderer(hitRowIndex, this.getColumnCount() - 1);
        String cellText = ((JLabel)this.prepareRenderer(renderer, hitRowIndex, this.getColumnCount() - 1)).getText();
        tip.append(COLUMN_NAMES[COLUMN_NAMES.length - 1]).append(": ").append(cellText);
        return tip;
    }

    private void setAutoscroll(boolean autoscroll) {
        this._autoscroll = autoscroll;
    }

    @Override
    public void update(Observer.NOTIFY notify, Object ... params) {
        if (notify == Observer.NOTIFY.CLEAR) {
            this.clear();
        } else if (notify == Observer.NOTIFY.AUTOSCROLL) {
            this.setAutoscroll((Boolean)params[0]);
        } else if (notify == Observer.NOTIFY.START) {
            this._threadUpdater = FileMonitorPreferencesRepository.getCurrentPreferences().getLocation().isRemote() ? new RemoteMonitorTableUpdater(this) : new LocalMonitorTableUpdater(this);
            this._threadUpdater.execute();
        } else if ((notify == Observer.NOTIFY.STOP || notify == Observer.NOTIFY.CLOSE) && this._threadUpdater != null) {
            this._threadUpdater.stop();
        }
    }

    private static class CheckBoxMenuItemUI
    extends BasicCheckBoxMenuItemUI {
        private CheckBoxMenuItemUI() {
        }

        @Override
        protected void doClick(MenuSelectionManager msm) {
            this.menuItem.doClick(0);
        }

        public static ComponentUI createUI(JComponent c) {
            return new CheckBoxMenuItemUI();
        }
    }
}

