/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.DataInputStream;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class Dsn6BinaryReader
extends MapFileReader {
    private float byteFactor;
    private int xyCount;
    private int nBrickX;
    private int nBrickY;
    private int brickLayerVoxelCount;
    private int brickLayerByteCount;
    private int brickRowByteCount;
    private byte[] brickLayer;
    private int pt;

    Dsn6BinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader brNull) {
        this.init2MFR(sg, this.br);
        this.binarydoc = this.newBinaryDocument();
        Object[] o2 = (Object[])sg.getReaderData();
        String fileName = (String)o2[0];
        String data = (String)o2[1];
        if (data == null) {
            this.binarydoc.setStream(sg.atomDataServer.getBufferedInputStream(fileName), true);
        } else {
            this.binarydoc.setStreamData(new DataInputStream(Rdr.getBIS((byte[])data.getBytes())), true);
        }
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        int i;
        short[] header = new short[19];
        for (i = 0; i < 19; ++i) {
            header[i] = this.binarydoc.readShort();
        }
        if (header[18] != 100) {
            this.binarydoc.setStream(null, false);
            for (i = 0; i < 19; ++i) {
                header[i] = this.binarydoc.swapBytesS(header[i]);
            }
        }
        this.nxyzStart[0] = header[0];
        this.nxyzStart[1] = header[1];
        this.nxyzStart[2] = header[2];
        this.nx = header[3];
        this.ny = header[4];
        this.nz = header[5];
        this.na = header[6];
        this.nb = header[7];
        this.nc = header[8];
        this.a = header[9];
        this.b = header[10];
        this.c = header[11];
        this.alpha = header[12];
        this.beta = header[13];
        this.gamma = header[14];
        float header16 = header[15];
        float header17 = header[16];
        float scalingFactor = header[17];
        float header19 = header[18];
        this.maps = 3;
        this.mapr = 2;
        this.mapc = 1;
        this.dmin = (0.0f - header17) * header19 / header16;
        this.dmax = (255.0f - header17) * header19 / header16;
        this.drange = this.dmax - this.dmin;
        this.byteFactor = this.drange / 255.0f;
        float dminError1 = (0.0f - header17 - 0.5f) * header19 / (header16 - 0.5f);
        float dminError2 = (0.0f - header17 + 0.5f) * header19 / (header16 + 0.5f);
        float dmaxError1 = (255.0f - header17 - 0.5f) * header19 / (header16 - 0.5f);
        float dmaxError2 = (255.0f - header17 + 0.5f) * header19 / (header16 + 0.5f);
        float dminError = (float)Math.round((dminError2 - dminError1) / 0.002f) * 0.001f;
        float dmaxError = (float)Math.round((dmaxError2 - dmaxError1) / 0.002f) * 0.001f;
        Logger.info((String)("DNS6 dmin,dmax = " + this.dmin + "+/-" + dminError + "," + this.dmax + "+/-" + dmaxError));
        this.a /= scalingFactor;
        this.b /= scalingFactor;
        this.c /= scalingFactor;
        this.alpha /= scalingFactor;
        this.beta /= scalingFactor;
        this.gamma /= scalingFactor;
        this.binarydoc.seek(512L);
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
        this.xyCount = this.nx * this.ny;
        this.brickLayerVoxelCount = this.xyCount * 8;
        this.nBrickX = (this.nx + 7) / 8;
        this.nBrickY = (this.ny + 7) / 8;
        this.brickRowByteCount = this.nBrickX * 512;
        this.brickLayerByteCount = this.brickRowByteCount * this.nBrickY;
        this.brickLayer = new byte[this.brickLayerByteCount];
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("DNS6/O progressive brick data reader\n");
        this.jvxlFileHeaderBuffer.append("see http://www.uoxray.uoregon.edu/tnt/manual/node104.html\n");
    }

    private void readBrickLayer() throws Exception {
        this.binarydoc.readByteArray(this.brickLayer, 0, this.brickLayerByteCount);
        this.pt = 0;
        this.nBytes = this.binarydoc.getPosition();
    }

    private float getBrickValue(int pt) {
        int y = pt / this.nx % this.ny;
        int bY = y / 8;
        int x = pt % this.nx;
        int bX = x / 8;
        int z = pt / this.xyCount;
        int brickZ = z % 8;
        int brickY = y % 8;
        int brickX = x % 8;
        int bPt = bY * 512 * this.nBrickX + bX * 512 + brickZ * 64 + brickY * 8 + brickX;
        bPt = bPt % 2 == 0 ? ++bPt : --bPt;
        float value = (this.brickLayer[bPt] + 256) % 256;
        return this.dmin + value * this.byteFactor;
    }

    @Override
    protected float nextVoxel() throws Exception {
        if (this.pt % this.brickLayerVoxelCount == 0) {
            this.readBrickLayer();
        }
        return this.getBrickValue(this.pt++);
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        for (int i = 0; i < nPoints; ++i) {
            this.binarydoc.readByte();
        }
    }
}

