/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.ttl.IndicesTTLService;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.NodeModule;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.MetaDataUpgrader;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.TaskResultsService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.tribe.TribeService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting("node.data", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting("node.master", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_INGEST_SETTING = Setting.boolSetting("node.ingest", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting<Settings> NODE_ATTRIBUTES = Setting.groupSetting("node.attr.", settings -> {
        Map<String, String> settingsMap = settings.getAsMap();
        for (Map.Entry<String, String> entry : settingsMap.entrySet()) {
            String value = entry.getValue();
            if (!Character.isWhitespace(value.charAt(0)) && !Character.isWhitespace(value.charAt(value.length() - 1))) continue;
            throw new IllegalArgumentException("node.attr." + entry.getKey() + " cannot have leading or trailing whitespace [" + value + "]");
        }
    }, Setting.Property.NodeScope);
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting<String>("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                return s;
            }
        }
        throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
    }, Setting.Property.NodeScope);
    private static final String CLIENT_TYPE = "node";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;

    public static final Settings addNodeNameIfNeeded(Settings settings, String nodeId) {
        if (NODE_NAME_SETTING.exists(settings)) {
            return settings;
        }
        return Settings.builder().put(settings).put(NODE_NAME_SETTING.getKey(), nodeId.substring(0, 7)).build();
    }

    public Node(Settings preparedSettings) {
        this(InternalSettingsPreparer.prepareEnvironment(preparedSettings, null));
    }

    public Node(Environment environment) {
        this(environment, Collections.emptyList());
    }

    protected Node(Environment environment, Collection<Class<? extends Plugin>> classpathPlugins) {
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        boolean success = false;
        Logger logger = Loggers.getLogger(Node.class, NODE_NAME_SETTING.get(environment.settings()));
        logger.info("initializing ...");
        try {
            Consumer<Binder> httpBind;
            HttpServerTransport httpServerTransport;
            Settings tmpSettings = Settings.builder().put(environment.settings()).put(Client.CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE).build();
            tmpSettings = TribeService.processSettings(tmpSettings);
            try {
                this.nodeEnvironment = new NodeEnvironment(tmpSettings, environment);
                resourcesToClose.add(this.nodeEnvironment);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to created node environment", ex);
            }
            boolean hadPredefinedNodeName = NODE_NAME_SETTING.exists(tmpSettings);
            Logger logger2 = Loggers.getLogger(Node.class, tmpSettings, new String[0]);
            String nodeId = this.nodeEnvironment.nodeId();
            tmpSettings = Node.addNodeNameIfNeeded(tmpSettings, nodeId);
            if (DiscoveryNode.nodeRequiresLocalStorage(tmpSettings)) {
                Node.checkForIndexDataInDefaultPathData(tmpSettings, this.nodeEnvironment, logger2);
            }
            String nodeName = NODE_NAME_SETTING.get(tmpSettings);
            if (!hadPredefinedNodeName) {
                logger2.info("node name [{}] derived from node ID [{}]; set [{}] to override", (Object)nodeName, (Object)nodeId, (Object)NODE_NAME_SETTING.getKey());
            } else {
                logger2.info("node name [{}], node ID [{}]", (Object)nodeName, (Object)nodeId);
            }
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            logger2.info("version[{}], pid[{}], build[{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Node.displayVersion(Version.CURRENT, Build.CURRENT.isSnapshot()), jvmInfo.pid(), Build.CURRENT.shortHash(), Build.CURRENT.date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, Constants.JAVA_VERSION, Constants.JVM_VERSION});
            Node.warnIfPreRelease(Version.CURRENT, Build.CURRENT.isSnapshot(), logger2);
            if (logger2.isDebugEnabled()) {
                logger2.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)environment.configFile(), (Object)Arrays.toString(environment.dataFiles()), (Object)environment.logsFile(), (Object)environment.pluginsFile());
            }
            if (JsonXContent.unquotedFieldNamesSet) {
                DeprecationLogger dLogger = new DeprecationLogger(logger2);
                dLogger.deprecated("[{}] has been set, but will be removed in Elasticsearch 6.0.0", "elasticsearch.json.allow_unquoted_field_names");
            }
            this.pluginsService = new PluginsService(tmpSettings, environment.modulesFile(), environment.pluginsFile(), classpathPlugins);
            this.settings = this.pluginsService.updatedSettings();
            this.localNodeFactory = new LocalNodeFactory(this.settings, this.nodeEnvironment.nodeId());
            this.environment = new Environment(this.settings);
            Environment.assertEquivalent(environment, this.environment);
            List<ExecutorBuilder<?>> executorBuilders = this.pluginsService.getExecutorBuilders(this.settings);
            ThreadPool threadPool = new ThreadPool(this.settings, executorBuilders.toArray(new ExecutorBuilder[0]));
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            DeprecationLogger.setThreadContext(threadPool.getThreadContext());
            resourcesToClose.add(() -> DeprecationLogger.removeThreadContext(threadPool.getThreadContext()));
            ArrayList additionalSettings = new ArrayList();
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>();
            additionalSettings.addAll(this.pluginsService.getPluginSettings());
            additionalSettingsFilter.addAll(this.pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(this.settings, threadPool);
            ResourceWatcherService resourceWatcherService = new ResourceWatcherService(this.settings, threadPool);
            ScriptModule scriptModule = ScriptModule.create(this.settings, this.environment, resourceWatcherService, this.pluginsService.filterPlugins(ScriptPlugin.class));
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            additionalSettings.addAll(scriptModule.getSettings());
            SettingsModule settingsModule = new SettingsModule(this.settings, additionalSettings, additionalSettingsFilter);
            scriptModule.registerClusterSettingsListeners(settingsModule.getClusterSettings());
            resourcesToClose.add(resourceWatcherService);
            NetworkService networkService = new NetworkService(this.settings, this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            ClusterService clusterService = new ClusterService(this.settings, settingsModule.getClusterSettings(), threadPool, (Supplier<DiscoveryNode>)((Supplier)this.localNodeFactory::getNode));
            clusterService.addListener(scriptModule.getScriptService());
            resourcesToClose.add(clusterService);
            IngestService ingestService = new IngestService(this.settings, threadPool, this.environment, scriptModule.getScriptService(), analysisModule.getAnalysisRegistry(), this.pluginsService.filterPlugins(IngestPlugin.class));
            ClusterInfoService clusterInfoService = this.newClusterInfoService(this.settings, clusterService, threadPool, this.client);
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            MonitorService monitorService = new MonitorService(this.settings, this.nodeEnvironment, threadPool);
            modules.add(new NodeModule(this, monitorService));
            ClusterModule clusterModule = new ClusterModule(this.settings, clusterService, this.pluginsService.filterPlugins(ClusterPlugin.class));
            modules.add(clusterModule);
            IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class));
            modules.add(indicesModule);
            SearchModule searchModule = new SearchModule(this.settings, false, this.pluginsService.filterPlugins(SearchPlugin.class));
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), settingsModule.getClusterSettings());
            resourcesToClose.add(circuitBreakerService);
            ActionModule actionModule = new ActionModule(false, this.settings, clusterModule.getIndexNameExpressionResolver(), settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class), this.client, circuitBreakerService);
            modules.add(actionModule);
            modules.add(new GatewayModule());
            BigArrays bigArrays = this.createBigArrays(this.settings, circuitBreakerService);
            resourcesToClose.add(bigArrays);
            modules.add(settingsModule);
            List<NamedWriteableRegistry.Entry> namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), indicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList());
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            TribeService tribeService = new TribeService(this.settings, clusterService, nodeId, namedWriteableRegistry, s -> this.newTribeClientNode((Settings)s, classpathPlugins));
            resourcesToClose.add(tribeService);
            modules.add(new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), xContentRegistry));
            MetaStateService metaStateService = new MetaStateService(this.settings, this.nodeEnvironment, xContentRegistry);
            IndicesService indicesService = new IndicesService(this.settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, settingsModule.getClusterSettings(), analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptModule.getScriptService(), clusterService, this.client, metaStateService);
            Collection pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, resourceWatcherService, scriptModule.getScriptService(), xContentRegistry).stream()).collect(Collectors.toList());
            Collection customMetaDataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getCustomMetaDataUpgrader).collect(Collectors.toList());
            RestController restController = actionModule.getRestController();
            NetworkModule networkModule = new NetworkModule(this.settings, false, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, restController);
            MetaDataUpgrader metaDataUpgrader = new MetaDataUpgrader(customMetaDataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            TransportService transportService = this.newTransportService(this.settings, transport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings());
            SearchTransportService searchTransportService = new SearchTransportService(this.settings, settingsModule.getClusterSettings(), transportService);
            if (networkModule.isHttpEnabled()) {
                httpServerTransport = networkModule.getHttpServerTransportSupplier().get();
                httpBind = b -> b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
            } else {
                httpBind = b -> b.bind(HttpServerTransport.class).toProvider(Providers.of(null));
                httpServerTransport = null;
            }
            DiscoveryModule discoveryModule = new DiscoveryModule(this.settings, threadPool, transportService, namedWriteableRegistry, networkService, clusterService, this.pluginsService.filterPlugins(DiscoveryPlugin.class));
            NodeService nodeService = new NodeService(this.settings, threadPool, monitorService, discoveryModule.getDiscovery(), transportService, indicesService, this.pluginsService, circuitBreakerService, scriptModule.getScriptService(), httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter());
            modules.add(b -> {
                b.bind(NodeService.class).toInstance(nodeService);
                b.bind(NamedXContentRegistry.class).toInstance(xContentRegistry);
                b.bind(PluginsService.class).toInstance(this.pluginsService);
                b.bind(Client.class).toInstance(this.client);
                b.bind(NodeClient.class).toInstance(this.client);
                b.bind(Environment.class).toInstance(this.environment);
                b.bind(ThreadPool.class).toInstance(threadPool);
                b.bind(NodeEnvironment.class).toInstance(this.nodeEnvironment);
                b.bind(TribeService.class).toInstance(tribeService);
                b.bind(ResourceWatcherService.class).toInstance(resourceWatcherService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(ScriptService.class).toInstance(scriptModule.getScriptService());
                b.bind(AnalysisRegistry.class).toInstance(analysisModule.getAnalysisRegistry());
                b.bind(IngestService.class).toInstance(ingestService);
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(MetaDataUpgrader.class).toInstance(metaDataUpgrader);
                b.bind(MetaStateService.class).toInstance(metaStateService);
                b.bind(IndicesService.class).toInstance(indicesService);
                b.bind(SearchService.class).toInstance(this.newSearchService(clusterService, indicesService, threadPool, scriptModule.getScriptService(), bigArrays, searchModule.getFetchPhase()));
                b.bind(SearchTransportService.class).toInstance(searchTransportService);
                b.bind(SearchPhaseController.class).toInstance(new SearchPhaseController(this.settings, bigArrays, scriptModule.getScriptService()));
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                b.bind(NetworkService.class).toInstance(networkService);
                b.bind(UpdateHelper.class).toInstance(new UpdateHelper(this.settings, scriptModule.getScriptService()));
                b.bind(MetaDataIndexUpgradeService.class).toInstance(new MetaDataIndexUpgradeService(this.settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings()));
                b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
                b.bind(Discovery.class).toInstance(discoveryModule.getDiscovery());
                RecoverySettings recoverySettings = new RecoverySettings(this.settings, settingsModule.getClusterSettings());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                b.bind(PeerRecoverySourceService.class).toInstance(new PeerRecoverySourceService(this.settings, transportService, indicesService, recoverySettings, clusterService));
                b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(this.settings, threadPool, transportService, recoverySettings, clusterService));
                httpBind.accept(b);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
            });
            this.injector = modules.createInjector();
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(this.injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            this.client.initialize(this.injector.getInstance(new Key<Map<GenericAction, TransportAction>>(){}), () -> clusterService.localNode().getId());
            if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
                logger2.debug("initializing HTTP handlers ...");
                actionModule.initRestHandlers(() -> clusterService.state().nodes());
            }
            logger2.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    static void checkForIndexDataInDefaultPathData(Settings settings, NodeEnvironment nodeEnv, Logger logger) throws IOException {
        if (!Environment.PATH_DATA_SETTING.exists(settings) || !Environment.DEFAULT_PATH_DATA_SETTING.exists(settings)) {
            return;
        }
        boolean clean = true;
        for (String defaultPathData : Environment.DEFAULT_PATH_DATA_SETTING.get(settings)) {
            NodeEnvironment.NodePath nodePath;
            Set<String> availableIndexFolders;
            Path defaultNodeDirectory = NodeEnvironment.resolveNodePath(Node.getPath(defaultPathData), nodeEnv.getNodeLockId());
            if (!Files.exists(defaultNodeDirectory, new LinkOption[0]) || Node.isDefaultPathDataInPathData(nodeEnv, defaultNodeDirectory) || (availableIndexFolders = nodeEnv.availableIndexFoldersForPath(nodePath = new NodeEnvironment.NodePath(defaultNodeDirectory))).isEmpty()) continue;
            clean = false;
            logger.error("detected index data in default.path.data [{}] where there should not be any", (Object)nodePath.indicesPath);
            for (String availableIndexFolder : availableIndexFolders) {
                logger.info("index folder [{}] in default.path.data [{}] must be moved to any of {}", (Object)availableIndexFolder, (Object)nodePath.indicesPath, Arrays.stream(nodeEnv.nodePaths()).map(np -> np.indicesPath).collect(Collectors.toList()));
            }
        }
        if (clean) {
            return;
        }
        String message = String.format(Locale.ROOT, "detected index data in default.path.data %s where there should not be any; check the logs for details", Environment.DEFAULT_PATH_DATA_SETTING.get(settings));
        throw new IllegalStateException(message);
    }

    private static boolean isDefaultPathDataInPathData(NodeEnvironment nodeEnv, Path defaultNodeDirectory) throws IOException {
        for (NodeEnvironment.NodePath dataPath : nodeEnv.nodePaths()) {
            if (!Files.isSameFile(dataPath.path, defaultNodeDirectory)) continue;
            return true;
        }
        return false;
    }

    @SuppressForbidden(reason="read path that is not configured in environment")
    private static Path getPath(String path) {
        return PathUtils.get(path, new String[0]);
    }

    static void warnIfPreRelease(Version version, boolean isSnapshot, Logger logger) {
        if (!version.isRelease() || isSnapshot) {
            logger.warn("version [{}] is a pre-release version of Elasticsearch and is not suitable for production", (Object)Node.displayVersion(version, isSnapshot));
        }
    }

    private static String displayVersion(Version version, boolean isSnapshot) {
        return version + (isSnapshot ? "-SNAPSHOT" : "");
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings) {
        return new TransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.settings;
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        if (!this.lifecycle.moveToStarted()) {
            return this;
        }
        final Logger logger = Loggers.getLogger(Node.class, NODE_NAME_SETTING.get(this.settings));
        logger.info("starting ...");
        this.injector.getInstance(Discovery.class).setAllocationService(this.injector.getInstance(AllocationService.class));
        this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
        this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
        this.injector.getInstance(IndicesService.class).start();
        this.injector.getInstance(IndicesClusterStateService.class).start();
        this.injector.getInstance(IndicesTTLService.class).start();
        this.injector.getInstance(SnapshotsService.class).start();
        this.injector.getInstance(SnapshotShardsService.class).start();
        this.injector.getInstance(RoutingService.class).start();
        this.injector.getInstance(SearchService.class).start();
        this.injector.getInstance(MonitorService.class).start();
        ClusterService clusterService = this.injector.getInstance(ClusterService.class);
        NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
        nodeConnectionsService.start();
        clusterService.setNodeConnectionsService(nodeConnectionsService);
        this.injector.getInstance(GatewayAllocator.class).setReallocation(clusterService, this.injector.getInstance(RoutingService.class));
        this.injector.getInstance(ResourceWatcherService.class).start();
        this.injector.getInstance(GatewayService.class).start();
        Discovery discovery = this.injector.getInstance(Discovery.class);
        clusterService.setDiscoverySettings(discovery.getDiscoverySettings());
        clusterService.addInitialStateBlock(discovery.getDiscoverySettings().getNoMasterBlock());
        clusterService.setClusterStatePublisher(discovery::publish);
        TribeService tribeService = this.injector.getInstance(TribeService.class);
        tribeService.start();
        TransportService transportService = this.injector.getInstance(TransportService.class);
        transportService.getTaskManager().setTaskResultsService(this.injector.getInstance(TaskResultsService.class));
        transportService.start();
        this.validateNodeBeforeAcceptingRequests(this.settings, transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).collect(Collectors.toList()));
        clusterService.addStateApplier(transportService.getTaskManager());
        clusterService.start();
        assert (this.localNodeFactory.getNode() != null);
        assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        discovery.start();
        transportService.acceptIncomingRequests();
        discovery.startInitialJoin();
        final TimeValue initialStateTimeout = DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.get(this.settings);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, logger, thread.getThreadContext());
            if (clusterState.nodes().getMasterNodeId() == null) {
                logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getMasterNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
            this.injector.getInstance(HttpServerTransport.class).start();
        }
        if (WRITE_PORTS_FILE_SETTING.get(this.settings).booleanValue()) {
            if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
                HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
                this.writePortsFile("http", http.boundAddress());
            }
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
        }
        tribeService.startNodes();
        SearchTransportService searchTransportService = this.injector.getInstance(SearchTransportService.class);
        searchTransportService.start();
        logger.info("started");
        return this;
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        Logger logger = Loggers.getLogger(Node.class, NODE_NAME_SETTING.get(this.settings));
        logger.info("stopping ...");
        this.injector.getInstance(TribeService.class).stop();
        this.injector.getInstance(ResourceWatcherService.class).stop();
        if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
            this.injector.getInstance(HttpServerTransport.class).stop();
        }
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(Discovery.class).stop();
        this.injector.getInstance(IndicesTTLService.class).stop();
        this.injector.getInstance(RoutingService.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(NodeConnectionsService.class).stop();
        this.injector.getInstance(MonitorService.class).stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        this.injector.getInstance(SearchTransportService.class).stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        this.injector.getInstance(IndicesService.class).stop();
        logger.info("stopped");
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.moveToClosed()) {
            return;
        }
        Logger logger = Loggers.getLogger(Node.class, NODE_NAME_SETTING.get(this.settings));
        logger.info("closing ...");
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("tribe"));
        toClose.add(this.injector.getInstance(TribeService.class));
        toClose.add(() -> stopWatch.stop().start("node_service"));
        toClose.add(this.injector.getInstance(NodeService.class));
        toClose.add(() -> stopWatch.stop().start("http"));
        if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
            toClose.add(this.injector.getInstance(HttpServerTransport.class));
        }
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add(this.injector.getInstance(SnapshotsService.class));
        toClose.add(this.injector.getInstance(SnapshotShardsService.class));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close(this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add(this.injector.getInstance(IndicesClusterStateService.class));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add(this.injector.getInstance(IndicesTTLService.class));
        toClose.add(this.injector.getInstance(IndicesService.class));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add(() -> stopWatch.stop().start("routing"));
        toClose.add(this.injector.getInstance(RoutingService.class));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add(this.injector.getInstance(ClusterService.class));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add(this.injector.getInstance(NodeConnectionsService.class));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add(this.injector.getInstance(Discovery.class));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.injector.getInstance(MonitorService.class));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add(this.injector.getInstance(GatewayService.class));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add(this.injector.getInstance(SearchService.class));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add(this.injector.getInstance(TransportService.class));
        toClose.add(() -> stopWatch.stop().start("search_transport_service"));
        toClose.add(this.injector.getInstance(SearchTransportService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add(this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> {
            try {
                this.injector.getInstance(ThreadPool.class).awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        toClose.add(() -> stopWatch.stop().start("thread_pool_force_shutdown"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdownNow());
        toClose.add(() -> stopWatch.stop());
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(this.injector.getInstance(BigArrays.class));
        if (logger.isTraceEnabled()) {
            logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint());
        }
        IOUtils.close(toClose);
        logger.info("closed");
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(Settings settings, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsFile().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, Charset.forName("UTF-8"), new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                if (inetAddress instanceof Inet6Address && inetAddress.isLinkLocalAddress()) continue;
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsFile().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    public static CircuitBreakerService createCircuitBreakerService(Settings settings, ClusterSettings clusterSettings) {
        String type = BREAKER_TYPE_KEY.get(settings);
        if (type.equals("hierarchy")) {
            return new HierarchyCircuitBreakerService(settings, clusterSettings);
        }
        if (type.equals("none")) {
            return new NoneCircuitBreakerService();
        }
        throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
    }

    BigArrays createBigArrays(Settings settings, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(settings, circuitBreakerService);
    }

    protected SearchService newSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, fetchPhase);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings);
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected Node newTribeClientNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
        return new Node(new Environment(settings), classpathPlugins);
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        return new InternalClusterInfoService(settings, clusterService, threadPool, client);
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;

        private LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            this.localNode.set((Object)DiscoveryNode.createLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }
}

