#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hxt-regex-xmlschema
version: 9.2.0.3
id: hxt-regex-xmlschema-9.2.0.3-DrZkVaqhcka8zPjgBegtWX
key: hxt-regex-xmlschema-9.2.0.3-DrZkVaqhcka8zPjgBegtWX
license: MIT
copyright: Copyright (c) 2010- Uwe Schmidt
maintainer: Uwe Schmidt <uwe@fh-wedel.de>
stability: stable
homepage: http://www.haskell.org/haskellwiki/Regular_expressions_for_XML_Schema
synopsis: A regular expression library for W3C XML Schema regular expressions
description:
    This library supports full W3C XML Schema regular expressions
    inclusive all Unicode character sets and blocks.
    The complete grammar can be found under <http://www.w3.org/TR/xmlschema11-2/#regexs>.
    It is implemented by the technique of derivations of regular expressions.
    .
    The W3C syntax is extended to support not only union of regular sets,
    but also intersection, set difference, exor.
    Matching of subexpressions is also supported.
    .
    The library can be used for constricting lightweight scanners and tokenizers.
    It is a standalone library, no external regex libraries are used.
    .
    Extensions in 9.2: The library does nor only support String'\''s, but also
    ByteString'\''s and Text in strict and lazy variants
category: Text
author: Uwe Schmidt
exposed: True
exposed-modules:
    Text.Regex.Glob.String Text.Regex.Glob.Generic
    Text.Regex.Glob.Generic.RegexParser Text.Regex.XMLSchema.String
    Text.Regex.XMLSchema.Generic Text.Regex.XMLSchema.Generic.Matching
    Text.Regex.XMLSchema.Generic.RegexParser
    Text.Regex.XMLSchema.Generic.Regex
    Text.Regex.XMLSchema.Generic.StringLike
abi: 4ad6d9d5e5c98c8b50d5275d62b57007
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/hxt-regex-xmlschema-9.2.0.3
library-dirs: /usr/lib/ghc-8.0.1/site-local/hxt-regex-xmlschema-9.2.0.3
data-dir: /usr/share/arm-linux-ghc-8.0.1/hxt-regex-xmlschema-9.2.0.3
hs-libraries: HShxt-regex-xmlschema-9.2.0.3-DrZkVaqhcka8zPjgBegtWX
depends:
    base-4.9.0.0 bytestring-0.10.8.1
    hxt-charproperties-9.2.0.1-L1rhanzXQ304SfBOSkeXkX
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ
haddock-interfaces: /usr/share/doc/haskell-hxt-regex-xmlschema/html/hxt-regex-xmlschema.haddock
haddock-html: /usr/share/doc/haskell-hxt-regex-xmlschema/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
