/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test {
    public static final int ROLE_UNKNOWN = 1701;
    public static final int ROLE_EMPTY = 1702;
    public static final int WRONG_TYPE = 1703;
    public static final int HIGH_COUNT = 1704;
    public static final int LOW_COUNT = 1705;
    public static final int ROLE_MISSING = 1706;
    public static final int RELATION_UNKNOWN = 1707;
    public static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static final Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset taggingPreset : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (!(taggingPresetItem instanceof Roles)) continue;
                relationpresets.add(taggingPreset);
                continue block0;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        Map<Roles.Role, String> map = RelationChecker.buildAllRoles(relation);
        if (map.isEmpty() && relation.hasTag("type", "route") && relation.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1")).primitives(relation).build());
        } else if (map.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Relation type is unknown", new Object[0])).primitives(relation).build());
        }
        Map<String, RoleInfo> map2 = RelationChecker.buildRoleInfoMap(relation);
        if (map2.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1708).message(I18n.tr("Relation is empty", new Object[0])).primitives(relation).build());
        } else if (!map.isEmpty()) {
            this.checkRoles(relation, map, map2);
        }
    }

    private static Map<String, RoleInfo> buildRoleInfoMap(Relation relation) {
        HashMap<String, RoleInfo> hashMap = new HashMap<String, RoleInfo>();
        for (RelationMember relationMember : relation.getMembers()) {
            String string = relationMember.getRole();
            RoleInfo roleInfo = (RoleInfo)hashMap.get(string);
            if (roleInfo == null) {
                roleInfo = new RoleInfo();
                hashMap.put(string, roleInfo);
            }
            roleInfo.total++;
        }
        return hashMap;
    }

    private static Map<Roles.Role, String> buildAllRoles(Relation relation) {
        LinkedHashMap<Roles.Role, String> linkedHashMap = new LinkedHashMap<Roles.Role, String>();
        for (TaggingPreset taggingPreset : relationpresets) {
            boolean bl = TaggingPresetItem.matches(Utils.filteredCollection(taggingPreset.data, KeyedItem.class), relation.getKeys());
            Roles roles = Utils.find(taggingPreset.data, Roles.class);
            if (!bl || roles == null) continue;
            for (Roles.Role role : roles.roles) {
                linkedHashMap.put(role, taggingPreset.name);
            }
        }
        return linkedHashMap;
    }

    private boolean checkMemberType(Roles.Role role, RelationMember relationMember) {
        if (role.types != null) {
            switch (relationMember.getDisplayType()) {
                case NODE: {
                    return role.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return role.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return role.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: {
                    return role.types.contains((Object)TaggingPresetType.MULTIPOLYGON);
                }
                case RELATION: {
                    return role.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(Map<Roles.Role, String> map, RelationMember relationMember, Relation relation) {
        String string = relationMember.getRole();
        String string2 = null;
        EnumSet<TaggingPresetType> enumSet = EnumSet.noneOf(TaggingPresetType.class);
        TestError testError = null;
        for (Map.Entry<Roles.Role, String> entry : map.entrySet()) {
            Roles.Role role = entry.getKey();
            if (!role.isRole(string)) continue;
            string2 = entry.getValue();
            enumSet.addAll(role.types);
            if (this.checkMemberType(role, relationMember)) {
                if (role.memberExpression == null) {
                    return true;
                }
                OsmPrimitive osmPrimitive = relationMember.getMember();
                if (!osmPrimitive.isUsable()) {
                    return true;
                }
                if (role.memberExpression.match(osmPrimitive)) {
                    return true;
                }
                testError = TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role of relation member does not match expression ''{0}'' in template {1}"), role.memberExpression, string2).primitives(relationMember.getMember().isUsable() ? relationMember.getMember() : relation).build();
                continue;
            }
            if (!OsmPrimitiveType.RELATION.equals((Object)relationMember.getType()) || relationMember.getMember().isUsable() || !role.types.contains((Object)TaggingPresetType.MULTIPOLYGON)) continue;
            return true;
        }
        if (string2 == null) {
            return true;
        }
        if (testError != null) {
            this.errors.add(testError);
        } else {
            String string3 = enumSet.stream().map(taggingPresetType -> I18n.tr(taggingPresetType.getName(), new Object[0])).collect(Collectors.joining("/"));
            this.errors.add(TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Type ''{0}'' of relation member with role ''{1}'' does not match accepted types ''{2}'' in template {3}"), new Object[]{relationMember.getType(), relationMember.getRole(), string3, string2}).primitives(relationMember.getMember().isUsable() ? relationMember.getMember() : relation).build());
        }
        return false;
    }

    private void checkRoles(Relation relation, Map<Roles.Role, String> map, Map<String, RoleInfo> map2) {
        for (RelationMember object : relation.getMembers()) {
            this.checkMemberExpressionAndType(map, object, relation);
        }
        for (Roles.Role role2 : map.keySet()) {
            String string = role2.key;
            if (string.isEmpty()) {
                string = I18n.tr("<empty>", new Object[0]);
            }
            this.checkRoleCounts(relation, role2, string, map2.get(role2.key));
        }
        if ("network".equals(relation.get("type")) && !"bicycle".equals(relation.get("route"))) {
            return;
        }
        for (String string : map2.keySet()) {
            boolean bl = false;
            for (Roles.Role role3 : map.keySet()) {
                if (!role3.isRole(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            String string2 = map.keySet().stream().map(role -> role.key).collect(Collectors.joining("/"));
            if (!string.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1701).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' unknown in templates ''{1}''"), string, string2).primitives(relation).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1702).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Empty role type found when expecting one of ''{0}''"), string2).primitives(relation).build());
        }
    }

    private void checkRoleCounts(Relation relation, Roles.Role role, String string, RoleInfo roleInfo) {
        long l;
        long l2 = roleInfo == null ? 0L : (long)roleInfo.total;
        if (l2 != (l = role.getValidCount(l2))) {
            if (l2 == 0L) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1706).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' missing"), string).primitives(relation).build());
            } else if (l > l2) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1705).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too low ({1})"), string, l2).primitives(relation).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1704).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too high ({1})"), string, l2).primitives(relation).build());
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError) && !testError.getPrimitives().iterator().next().isDeleted()) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total;

        private RoleInfo() {
        }
    }
}

