/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import proguard.obfuscate.MappingReader;
import proguard.retrace.FrameInfo;
import proguard.retrace.FramePattern;
import proguard.retrace.FrameRemapper;

public class ReTrace {
    private static final String USAGE = "Usage: java proguard.ReTrace [-regex <regex>] [-verbose] <mapping_file> [<stacktrace_file>]";
    private static final String REGEX_OPTION = "-regex";
    private static final String VERBOSE_OPTION = "-verbose";
    public static final String STACK_TRACE_EXPRESSION = "(?:.*?\\bat\\s+%c\\.%m\\s*\\(%s(?::%l)?\\)\\s*(?:~\\[.*\\])?)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)";
    private final String regularExpression;
    private final boolean verbose;
    private final File mappingFile;

    public ReTrace(String string, boolean bl, File file) {
        this.regularExpression = string;
        this.verbose = bl;
        this.mappingFile = file;
    }

    public void retrace(LineNumberReader lineNumberReader, PrintWriter printWriter) throws IOException {
        String string;
        FramePattern framePattern = new FramePattern(this.regularExpression, this.verbose);
        FrameRemapper frameRemapper = new FrameRemapper();
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        mappingReader.pump(frameRemapper);
        while ((string = lineNumberReader.readLine()) != null) {
            FrameInfo frameInfo = framePattern.parse(string);
            if (frameInfo != null) {
                Iterator<FrameInfo> iterator = frameRemapper.transform(frameInfo).iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    String string3;
                    FrameInfo frameInfo2 = iterator.next();
                    String string4 = framePattern.format(string, frameInfo2);
                    String string5 = string3 = string2 != null && frameInfo.getLineNumber() == 0 ? this.trim(string4, string2) : string4;
                    if (string3 != null) {
                        printWriter.println(string3);
                    }
                    string2 = string4;
                }
                continue;
            }
            printWriter.println(string);
        }
        printWriter.flush();
    }

    private String trim(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = this.firstNonCommonIndex(string, string2);
        if (n == string.length()) {
            return null;
        }
        n = this.lastNonIdentifierIndex(string, n) + 1;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }

    private int firstNonCommonIndex(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return n;
    }

    private int lastNonIdentifierIndex(String string, int n) {
        while (n >= 0 && Character.isJavaIdentifierPart(string.charAt(n))) {
            --n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        int n;
        if (stringArray.length < 1) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        String string = STACK_TRACE_EXPRESSION;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (((String)object).equals(REGEX_OPTION)) {
                string = stringArray[++n];
                continue;
            }
            if (!((String)object).equals(VERBOSE_OPTION)) break;
            bl = true;
        }
        if (n >= stringArray.length) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        object = new File(stringArray[n++]);
        File file = n < stringArray.length ? new File(stringArray[n]) : null;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new InputStreamReader(file == null ? System.in : new FileInputStream(file), "UTF-8")));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            try {
                new ReTrace(string, bl, (File)object).retrace(lineNumberReader, printWriter);
            }
            finally {
                if (file != null) {
                    lineNumberReader.close();
                }
            }
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            } else {
                System.err.println("Error: " + iOException.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

