# From 3.1 to 4.0
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/3.1-to-4.0.md) for the most up to date instructions.*

## Important changes

- Support for SQLite was dropped
- Support for Gitolite 2 was dropped
- Projects are organized in namespaces
- The GitLab post-receive hook needs to be updated
- The configuration file needs to be updated
- Availability of `python2` executable

Most of projects has post-receive file as symlink to Gitolite `/home/git/.gitolite/hooks/post-receive`. But some of them may have a real file. In this case you should rewrite it with symlink to Gitolite hook.

I wrote a bash script which will do it automatically for you. Just make sure all path inside is valid for you

## 1. Stop GitLab & Resque

    sudo service gitlab stop

## 2. Update GitLab

```bash

# Get latest code
sudo -u gitlab -H git fetch
sudo -u gitlab -H git checkout 4-0-stable

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u gitlab -H vim Gemfile

# Install gems for MySQL
sudo -u gitlab -H bundle install --without development test postgres

# Update repos permissions
sudo chmod -R ug+rwXs /home/git/repositories/
sudo chown -R git:git /home/git/repositories/

# Migrate db
sudo -u gitlab -H bundle exec rake db:migrate RAILS_ENV=production

# Enable namespaces (**Warning!** All projects in groups will be moved to subdirectories)
sudo -u gitlab -H bundle exec rake gitlab:enable_namespaces RAILS_ENV=production

```

## 3. Update post-receive hooks  (Requires Gitolite v3 )

Step 1: Rewrite post-receive hook

```bash
sudo cp ./lib/hooks/post-receive /home/git/.gitolite/hooks/common/post-receive
sudo chown git:git /home/git/.gitolite/hooks/common/post-receive
```

Step 2: Update project hooks to be symlinks to the Gitolite hook

```bash
# 1. Check paths in script
sudo -u gitlab -H vim lib/support/rewrite-hooks.sh

# 2. Run script
sudo -u git -H lib/support/rewrite-hooks.sh
```

## 4. Replace config with new one

    # backup old one
    sudo -u gitlab -H cp config/gitlab.yml config/gitlab.yml.old

    # copy new one
    sudo -u gitlab -H cp config/gitlab.yml.example config/gitlab.yml

    # edit it
    sudo -u gitlab -H vim config/gitlab.yml

## 5. Disable ssh known_host check for own domain

    echo "Host localhost
       StrictHostKeyChecking no
       UserKnownHostsFile=/dev/null" | sudo tee -a /etc/ssh/ssh_config

    echo "Host YOUR_DOMAIN_NAME
       StrictHostKeyChecking no
       UserKnownHostsFile=/dev/null" | sudo tee -a /etc/ssh/ssh_config

## 6. Check GitLab's status

    sudo -u gitlab -H bundle exec rake gitlab:check RAILS_ENV=production

## 7. Start GitLab & Resque

    sudo service gitlab start
