

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:GeoJson (geojson){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">GeoJson (geojson)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_ggv_log.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_geonet.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_geojson"></a>GeoJson (geojson)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          write tracks
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_geojson.html#fmt_geojson_o_compact" title="compact option">compact</a> .</p><p>
This module supports a subset of the <a class="ulink" href="http://geojson.org/" target="_top">GeoJSON</a> format.
</p><p>
GeoJSON is a poor fit for GPSBabel's internal data structures as GPSBabel 
was designed more around common GPS features (waypoints, tracks, routes) 
than about GIS-style concepts like MultiPolygons or Geometry Collections.
In reality, for all but the most simple uses (such as converting a format
that GPSBabel supports well to something like Leaflet, you should not expect
high fidelity transfers through this format.
</p><p>
Initially, only write support for waypoints and tracks is available.  
Waypoints are converted to a FeatureCollection of Points.  
The properties for name and description are written, where available.
Tracks are converted to a LineString.
</p><p>
Potential future work includes the ability to read Point Features and/or
LineStrings as these would map into our concept of waypoints and 
routes/tracks.
The potentially nested/recursive nature of GeoJSON in general would be 
an awkward implementation.
</p><p>
Initial development was free-handed by looking at the <a class="ulink" href="https://tools.ietf.org/html/rfc7946 " target="_top">GeoJSON RFC</a>. Corner cases were handled by
using <a class="ulink" href="http://www.gdal.org/ogr2ogr.html" target="_top">GDAL's ogr2ogr</a>
to convert GPX to JSON and compare the output. The results were then
 <a class="ulink" href="http://geojsonlint.com/" target="_top">JSON validated</a> and viewed on
 <a class="ulink" href="http://geojson.io/" target="_top">JSON web viewer</a>.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_geojson_o_compact"></a><code class="option">compact</code> option</h3></div></div></div><p>
      Compact Output. Default is off..
    </p><p>
 This option, when set, reduces the amount of whitespace in the 
 generated GeoJSON. This reduces the size, especially when uncompressed,
 but reduces the readibility to humans.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_ggv_log.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_geonet.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Geogrid-Viewer tracklogs (.log) (ggv_log) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> GEOnet Names Server (GNS) (geonet)</td></tr></table></div>
  
      {/literal}{/block}
  