/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class NameFinder {
    public static final String NOMINATIM_URL = "https://nominatim.openstreetmap.org/search?format=xml&q=";

    private NameFinder() {
    }

    public static List<SearchResult> queryNominatim(String string) throws IOException {
        return NameFinder.query(new URL(NOMINATIM_URL + Utils.encodeUrl(string)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SearchResult> query(URL uRL) throws IOException {
        HttpClient httpClient = HttpClient.create(uRL);
        httpClient.connect();
        try (BufferedReader bufferedReader = httpClient.getResponse().getContentReader();){
            List<SearchResult> list = NameFinder.parseSearchResults(bufferedReader);
            return list;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new UncheckedParseException(exception);
        }
    }

    public static List<SearchResult> parseSearchResults(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = new InputSource(reader);
        NameFinderResultParser nameFinderResultParser = new NameFinderResultParser();
        Utils.parseSafeSAX(inputSource, nameFinderResultParser);
        return nameFinderResultParser.getResult();
    }

    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult;
        private StringBuilder description;
        private int depth;
        private final List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            try {
                if (!"searchresults".equals(string3)) {
                    if (this.depth == 2 && "named".equals(string3)) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = attributes.getValue("name");
                        this.currentResult.info = attributes.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(attributes.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if (this.depth == 3 && "description".equals(string3)) {
                        this.description = new StringBuilder();
                    } else if (this.depth == 4 && "named".equals(string3)) {
                        String string4 = attributes.getValue("info");
                        if ("city".equals(string4) || "town".equals(string4) || "village".equals(string4)) {
                            this.currentResult.nearestPlace = attributes.getValue("name");
                        }
                    } else if ("place".equals(string3) && attributes.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = attributes.getValue("display_name");
                        this.currentResult.description = this.currentResult.name;
                        this.currentResult.info = attributes.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.nearestPlace = I18n.tr(attributes.getValue("type"), new Object[0]);
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        String[] stringArray = attributes.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[3]));
                        String string5 = attributes.getValue("osm_id");
                        String string6 = attributes.getValue("osm_type");
                        if (string5 != null && string6 != null) {
                            this.currentResult.osmId = new SimplePrimitiveId(Long.parseLong(string5), OsmPrimitiveType.from(string6));
                        }
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.error(numberFormatException);
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                Main.error(nullPointerException);
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags.", new Object[0]), nullPointerException);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.description != null && "description".equals(string3)) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.description != null) {
                this.description.append(cArray, n, n2);
            }
        }

        public List<SearchResult> getResult() {
            return Collections.unmodifiableList(this.data);
        }
    }

    public static class SearchResult {
        private String name;
        private String info;
        private String nearestPlace;
        private String description;
        private double lat;
        private double lon;
        private int zoom;
        private Bounds bounds;
        private PrimitiveId osmId;

        public final String getName() {
            return this.name;
        }

        public final String getInfo() {
            return this.info;
        }

        public final String getNearestPlace() {
            return this.nearestPlace;
        }

        public final String getDescription() {
            return this.description;
        }

        public final double getLat() {
            return this.lat;
        }

        public final double getLon() {
            return this.lon;
        }

        public final int getZoom() {
            return this.zoom;
        }

        public final Bounds getBounds() {
            return this.bounds;
        }

        public final PrimitiveId getOsmId() {
            return this.osmId;
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }
}

