/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ImageryHandler
extends RequestHandler.RawURLParseRequestHandler {
    public static final String command = "imagery";

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load an imagery layer from the following URL:", new Object[0]) + "<br>" + (String)this.args.get("url");
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"title", "type", "cookies", "min_zoom", "max_zoom"};
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_IMAGERY;
    }

    protected static ImageryInfo findBingEntry() {
        for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getDefaultLayers()) {
            if (!ImageryInfo.ImageryType.BING.equals((Object)imageryInfo.getImageryType())) continue;
            return imageryInfo;
        }
        return null;
    }

    protected ImageryInfo buildImageryInfo() {
        String string;
        String string2;
        ImageryInfo imageryInfo;
        String string3 = (String)this.args.get("url");
        String string4 = (String)this.args.get("title");
        String string5 = (String)this.args.get("type");
        ImageryInfo imageryInfo2 = imageryInfo = ImageryInfo.ImageryType.BING.getTypeString().equals(string5) ? ImageryHandler.findBingEntry() : null;
        if ((string4 == null || string4.isEmpty()) && imageryInfo != null) {
            string4 = imageryInfo.getName();
        }
        if (string4 == null || string4.isEmpty()) {
            string4 = I18n.tr("Remote imagery", new Object[0]);
        }
        String string6 = (String)this.args.get("cookies");
        ImageryInfo imageryInfo3 = new ImageryInfo(string4, string3, string5, null, string6);
        if (imageryInfo != null) {
            imageryInfo3.setIcon(imageryInfo.getIcon());
        }
        if ((string2 = (String)this.args.get("min_zoom")) != null && !string2.isEmpty()) {
            try {
                imageryInfo3.setDefaultMinZoom(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Main.error(numberFormatException);
            }
        }
        if ((string = (String)this.args.get("max_zoom")) != null && !string.isEmpty()) {
            try {
                imageryInfo3.setDefaultMaxZoom(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                Main.error(numberFormatException);
            }
        }
        return imageryInfo3;
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        ImageryInfo imageryInfo = this.buildImageryInfo();
        if (Main.isDisplayingMapView()) {
            for (ImageryLayer imageryLayer : Main.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                if (!imageryLayer.getInfo().equals(imageryInfo)) continue;
                Main.info("Imagery layer already exists: " + imageryInfo);
                return;
            }
        }
        GuiHelper.runInEDT(() -> {
            try {
                Main.getLayerManager().addLayer(ImageryLayer.create(imageryInfo));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.error((Throwable)illegalArgumentException, false);
            }
        });
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String string = this.args != null ? (String)this.args.get("url") : null;
        String string2 = this.args != null ? (String)this.args.get("type") : null;
        String string3 = this.args != null ? (String)this.args.get("cookies") : null;
        try {
            ImageryLayer.create(new ImageryInfo(null, string, string2, null, string3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RequestHandler.RequestHandlerBadRequestException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    @Override
    public String getUsage() {
        return "adds an imagery layer (e.g. WMS, TMS)";
    }

    @Override
    public String[] getUsageExamples() {
        String string = Utils.join("|", Utils.transform(Arrays.asList(ImageryInfo.ImageryType.values()), ImageryInfo.ImageryType::getTypeString));
        return new String[]{"/imagery?title=osm&type=tms&url=https://a.tile.openstreetmap.org/%7Bzoom%7D/%7Bx%7D/%7By%7D.png", "/imagery?title=landsat&type=wms&url=http://irs.gis-lab.info/?layers=landsat&SRS=%7Bproj%7D&WIDTH=%7Bwidth%7D&HEIGHT=%7Bheight%7D&BBOX=%7Bbbox%7D", "/imagery?title=...&type={" + string + "}&url=....[&cookies=...][&min_zoom=...][&max_zoom=...]"};
    }
}

