# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB::Server
    module Share
      module Command
        module Trans2
          #@todo Check FID and no shortcut assuming the request always come for the valid FID
          module QueryFileInformation

            # Handles an TRANS2_QUERY_FILE_INFORMATION subcommand, used to get information about
            # an specific file or directory, using its FID.
            #
            # @param c [Socket] The client sending the request.
            # @param buff [String] The data including the client request.
            # @return [Integer] The number of bytes returned to the client as response.
            def smb_cmd_trans2_query_file_information(c, buff)
              smb = @state[c]

              params = CONST::SMB_TRANS2_QUERY_FILE_PARAMETERS.make_struct
              params.from_s(buff)

              loi = params.v['InformationLevel']
              fid = params.v['FID']

              case loi
              when CONST::SMB_QUERY_FILE_STANDARD_INFO, CONST::SMB_QUERY_FILE_STANDARD_INFO_ALIAS, CONST::SMB_QUERY_FILE_INTERNAL_INFO_ALIAS
                return smb_cmd_trans_query_file_info_standard(c, fid)
              when CONST::SMB_QUERY_FILE_BASIC_INFO, CONST::SMB_QUERY_FILE_BASIC_INFO_ALIAS, CONST::SMB_SET_FILE_BASIC_INFO_ALIAS
                return smb_cmd_trans_query_file_info_basic(c, fid)
              else
                # Send STATUS_SUCCESS with the hope of going ahead
                vprint_status("SMB Share - #{smb[:ip]} Unknown TRANS2_QUERY_FILE_INFORMATION with loi: #{loi.to_s(16)}")
                return smb_error(CONST::SMB_COM_TRANSACTION2, c, CONST::SMB_STATUS_SUCCESS)
              end
            end
          end
        end
      end
    end
  end
end
