/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

abstract class BulkRequestHandler {
    protected final Logger logger;
    protected final Client client;

    protected BulkRequestHandler(Client client) {
        this.client = client;
        this.logger = Loggers.getLogger(this.getClass(), client.settings(), new String[0]);
    }

    public abstract void execute(BulkRequest var1, long var2);

    public abstract boolean awaitClose(long var1, TimeUnit var3) throws InterruptedException;

    public static BulkRequestHandler syncHandler(Client client, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener) {
        return new SyncBulkRequestHandler(client, backoffPolicy, listener);
    }

    public static BulkRequestHandler asyncHandler(Client client, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, int concurrentRequests) {
        return new AsyncBulkRequestHandler(client, backoffPolicy, listener, concurrentRequests);
    }

    private static class AsyncBulkRequestHandler
    extends BulkRequestHandler {
        private final BackoffPolicy backoffPolicy;
        private final BulkProcessor.Listener listener;
        private final Semaphore semaphore;
        private final int concurrentRequests;

        private AsyncBulkRequestHandler(Client client, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, int concurrentRequests) {
            super(client);
            this.backoffPolicy = backoffPolicy;
            assert (concurrentRequests > 0);
            this.listener = listener;
            this.concurrentRequests = concurrentRequests;
            this.semaphore = new Semaphore(concurrentRequests);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(final BulkRequest bulkRequest, final long executionId) {
            boolean bulkRequestSetupSuccessful = false;
            boolean acquired = false;
            try {
                this.listener.beforeBulk(executionId, bulkRequest);
                this.semaphore.acquire();
                acquired = true;
                Retry.on(EsRejectedExecutionException.class).policy(this.backoffPolicy).withAsyncBackoff(this.client, bulkRequest, new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse response) {
                        try {
                            listener.afterBulk(executionId, bulkRequest, response);
                        }
                        finally {
                            semaphore.release();
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            listener.afterBulk(executionId, bulkRequest, e);
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                });
                bulkRequestSetupSuccessful = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            finally {
                if (!bulkRequestSetupSuccessful && acquired) {
                    this.semaphore.release();
                }
            }
        }

        @Override
        public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.semaphore.tryAcquire(this.concurrentRequests, timeout, unit)) {
                this.semaphore.release(this.concurrentRequests);
                return true;
            }
            return false;
        }
    }

    private static class SyncBulkRequestHandler
    extends BulkRequestHandler {
        private final BulkProcessor.Listener listener;
        private final BackoffPolicy backoffPolicy;

        SyncBulkRequestHandler(Client client, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener) {
            super(client);
            this.backoffPolicy = backoffPolicy;
            this.listener = listener;
        }

        @Override
        public void execute(BulkRequest bulkRequest, long executionId) {
            block4: {
                boolean afterCalled = false;
                try {
                    this.listener.beforeBulk(executionId, bulkRequest);
                    BulkResponse bulkResponse = Retry.on(EsRejectedExecutionException.class).policy(this.backoffPolicy).withSyncBackoff(this.client, bulkRequest);
                    afterCalled = true;
                    this.listener.afterBulk(executionId, bulkRequest, bulkResponse);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
                    if (!afterCalled) {
                        this.listener.afterBulk(executionId, bulkRequest, e);
                    }
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
                    if (afterCalled) break block4;
                    this.listener.afterBulk(executionId, bulkRequest, e);
                }
            }
        }

        @Override
        public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }
    }
}

