/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.Capabilities;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.SimpleNode;
import org.gjt.sp.jedit.bsh.StringUtil;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;

public class This
implements Serializable,
Runnable {
    NameSpace namespace;
    transient Interpreter declaringInterpreter;

    static This getThis(NameSpace nameSpace, Interpreter interpreter) {
        try {
            Class<?> clazz;
            if (Capabilities.canGenerateInterfaces()) {
                clazz = Class.forName("org.gjt.sp.jedit.bsh.XThis");
            } else if (Capabilities.haveSwing()) {
                clazz = Class.forName("org.gjt.sp.jedit.bsh.JThis");
            } else {
                return new This(nameSpace, interpreter);
            }
            return (This)Reflect.constructObject(clazz, new Object[]{nameSpace, interpreter});
        }
        catch (Exception exception) {
            throw new InterpreterError("internal error 1 in This: " + exception);
        }
    }

    public Object getInterface(Class clazz) throws UtilEvalError {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + clazz);
    }

    public Object getInterface(Class[] classArray) throws UtilEvalError {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isInstance(this)) continue;
            throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + classArray[i]);
        }
        return this;
    }

    protected This(NameSpace nameSpace, Interpreter interpreter) {
        this.namespace = nameSpace;
        this.declaringInterpreter = interpreter;
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public String toString() {
        return "'this' reference to Bsh object: " + this.namespace;
    }

    @Override
    public void run() {
        try {
            this.invokeMethod("run", new Object[0]);
        }
        catch (EvalError evalError) {
            this.declaringInterpreter.error("Exception in runnable:" + evalError);
        }
    }

    public Object invokeMethod(String string, Object[] objectArray) throws EvalError {
        return this.invokeMethod(string, objectArray, null, null, null, false);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode, boolean bl) throws EvalError {
        Object[] objectArray2;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] == null ? Primitive.NULL : objectArray[i];
            }
            objectArray = objectArray2;
        }
        if (interpreter == null) {
            interpreter = this.declaringInterpreter;
        }
        if (callStack == null) {
            callStack = new CallStack(this.namespace);
        }
        if (simpleNode == null) {
            simpleNode = SimpleNode.JAVACODE;
        }
        objectArray2 = Types.getTypes(objectArray);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(string, (Class[])objectArray2, bl);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(objectArray, interpreter, callStack, simpleNode);
        }
        if (string.equals("toString")) {
            return this.toString();
        }
        if (string.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (string.equals("equals")) {
            Object object = objectArray[0];
            return new Boolean(this == object);
        }
        try {
            bshMethod = this.namespace.getMethod("invoke", new Class[]{null, null});
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
        }
        throw new EvalError("Method " + StringUtil.methodString(string, (Class[])objectArray2) + " not found in bsh scripted object: " + this.namespace.getName(), simpleNode, callStack);
    }

    public static void bind(This this_, NameSpace nameSpace, Interpreter interpreter) {
        this_.namespace.setParent(nameSpace);
        this_.declaringInterpreter = interpreter;
    }

    static boolean isExposedThisMethod(String string) {
        return string.equals("getClass") || string.equals("invokeMethod") || string.equals("getInterface") || string.equals("wait") || string.equals("notify") || string.equals("notifyAll");
    }
}

