/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.UIManager;
import javax.swing.colorchooser.SwatchPanel;

class RecentSwatchPanel
extends SwatchPanel {
    RecentSwatchPanel() {
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize", this.getLocale());
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor", this.getLocale());
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
    }

    public void setMostRecentColor(Color c) {
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        this.repaint();
    }
}

