/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MissionaryMessage
extends DOMMessage {
    private final String unitId;
    private final String directionString;
    private final boolean denounce;

    public MissionaryMessage(Unit unit, Direction direction, boolean denounce) {
        super(MissionaryMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf(direction);
        this.denounce = denounce;
    }

    public MissionaryMessage(Game game, Element element) {
        super(MissionaryMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
        this.denounce = Boolean.parseBoolean(element.getAttribute("denounce"));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit.MoveType type;
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        ServerIndianSettlement is = (ServerIndianSettlement)tile.getIndianSettlement();
        if (is == null) {
            return DOMMessage.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit missionary = is.getMissionary();
        if (this.denounce) {
            if (missionary == null) {
                return DOMMessage.clientError("Denouncing an empty mission at: " + is.getId());
            }
            if (missionary.getOwner() == player) {
                return DOMMessage.clientError("Denouncing our own missionary at: " + is.getId());
            }
            if (!unit.hasAbility("model.ability.denounceHeresy")) {
                return DOMMessage.clientError("Unit lacks denouncement ability: " + this.unitId);
            }
        } else {
            if (missionary != null) {
                return DOMMessage.clientError("Establishing extra mission at: " + is.getId());
            }
            if (!unit.hasAbility("model.ability.establishMission")) {
                return DOMMessage.clientError("Unit lacks establish mission ability: " + this.unitId);
            }
        }
        if ((type = unit.getMoveType(is.getTile())) != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return DOMMessage.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return this.denounce ? server.getInGameController().denounceMission(serverPlayer, unit, is) : server.getInGameController().establishMission(serverPlayer, unit, is);
    }

    @Override
    public Element toXMLElement() {
        return MissionaryMessage.createMessage(MissionaryMessage.getXMLElementTagName(), "unitId", this.unitId, "direction", this.directionString, "denounce", Boolean.toString(this.denounce));
    }

    public static String getXMLElementTagName() {
        return "missionary";
    }
}

