/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gradle.api.internal.file.AbstractFileResource;
import org.gradle.internal.resource.ResourceExceptions;

public class FileResource
extends AbstractFileResource {
    public FileResource(File file) {
        super(file);
    }

    public InputStream read() {
        if (this.file.isDirectory()) {
            throw ResourceExceptions.readFolder((File)this.file);
        }
        try {
            FileInputStream fis = new FileInputStream(this.file);
            return new BufferedInputStream(fis);
        }
        catch (FileNotFoundException e) {
            throw ResourceExceptions.readMissing((File)this.file, (Throwable)e);
        }
    }
}

