/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Incubating;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.io.StreamByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class MapBasedBuildCache
implements BuildCache {
    private final String description;
    private final ConcurrentMap<String, byte[]> delegate;

    public MapBasedBuildCache(String description, ConcurrentMap<String, byte[]> delegate) {
        this.description = description;
        this.delegate = delegate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        byte[] bytes = (byte[])this.delegate.get(key.getHashCode());
        if (bytes == null) {
            return false;
        }
        try {
            reader.readFrom(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new BuildCacheException("loading " + key, e);
        }
        return true;
    }

    @Override
    public void store(BuildCacheKey key, BuildCacheEntryWriter output) throws BuildCacheException {
        StreamByteBuffer buffer = new StreamByteBuffer();
        try {
            output.writeTo(buffer.getOutputStream());
        }
        catch (IOException e) {
            throw new BuildCacheException("storing " + key, e);
        }
        this.delegate.put(key.getHashCode(), buffer.readAsByteArray());
    }

    @Override
    public void close() throws IOException {
    }
}

