/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan;

import org.gradle.BuildAdapter;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public final class BuildScanRequestListener
extends BuildAdapter {
    private static final String BUILD_SCAN_PLUGIN_NAME_PATTERN = "com\\.gradle\\..*\\.BuildScanPlugin";

    public void projectsEvaluated(Gradle gradle) {
        Project rootProject = gradle.getRootProject();
        if (!this.hasBuildScanPluginApplied(rootProject)) {
            throw new GradleException("Build scan cannot be created since the build scan plugin has not been applied.\nFor more information on how to apply the build scan plugin, please visit https://gradle.com/get-started.");
        }
    }

    private boolean hasBuildScanPluginApplied(Project rootProject) {
        return CollectionUtils.any((Iterable)rootProject.getPlugins(), (Spec)new Spec<Plugin>(){

            public boolean isSatisfiedBy(Plugin plugin) {
                return plugin.getClass().getName().matches(BuildScanRequestListener.BUILD_SCAN_PLUGIN_NAME_PATTERN);
            }
        });
    }
}

