/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorBuilder;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultMutableMavenModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata
implements MutableMavenModuleResolveMetadata {
    private String packaging;
    private boolean relocated;
    private String snapshotTimestamp;

    public DefaultMutableMavenModuleResolveMetadata(ModuleComponentIdentifier componentIdentifier, Set<IvyArtifactName> artifacts) {
        this(componentIdentifier, MutableModuleDescriptorState.createModuleDescriptor(componentIdentifier, artifacts), "jar", false, (Collection<? extends DependencyMetadata>)ImmutableList.of());
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleDescriptorState moduleDescriptor, String packaging, boolean relocated, Collection<DependencyMetadata> dependencies) {
        this(moduleDescriptor.getComponentIdentifier(), moduleDescriptor, packaging, relocated, dependencies);
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleComponentIdentifier componentIdentifier, ModuleDescriptorState descriptor, String packaging, boolean relocated, Collection<? extends DependencyMetadata> dependencies) {
        super(componentIdentifier, descriptor, GradlePomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS, (List<? extends DependencyMetadata>)ImmutableList.copyOf(dependencies));
        this.packaging = packaging;
        this.relocated = relocated;
    }

    DefaultMutableMavenModuleResolveMetadata(MavenModuleResolveMetadata metadata) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
    }

    @Override
    public MavenModuleResolveMetadata asImmutable() {
        return new DefaultMavenModuleResolveMetadata(this);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }
}

