/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.util.PsiNavigationSupport;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.NavigationItem;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.project.ProjectCoreUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class LazyParseablePsiElement
extends LazyParseableElement
implements NavigationItem,
PsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseablePsiElement");

    public LazyParseablePsiElement(@NotNull IElementType type2, @Nullable CharSequence buffer) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "<init>"));
        }
        super(type2, buffer);
        this.setPsi(this);
    }

    @Override
    @NotNull
    public LazyParseablePsiElement clone() {
        LazyParseablePsiElement clone = (LazyParseablePsiElement)super.clone();
        clone.setPsi(clone);
        LazyParseablePsiElement lazyParseablePsiElement = clone;
        if (lazyParseablePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "clone"));
        }
        return lazyParseablePsiElement;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getChildren"));
        }
        return psiElementArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass2) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass2.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass2) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass2.isInstance(cur)) continue;
            result2.add(cur);
        }
        Object[] objectArray = result2.toArray((Object[])Array.newInstance(aClass2, result2.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Override
    public PsiElement getFirstChild() {
        TreeElement child = this.getFirstChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        TreeElement child = this.getLastChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "acceptChildren"));
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor2);
        }
    }

    @Override
    public PsiElement getParent() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent == null) {
            return null;
        }
        if (treeParent instanceof PsiElement) {
            return (PsiElement)((Object)treeParent);
        }
        return treeParent.getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file2 = SharedImplUtil.getContainingFile(this);
        if (file2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file2;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        LeafElement leaf = this.findLeafElementAt(offset2);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset2);
    }

    @Override
    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    @Override
    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "add"));
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "addBefore"));
        }
        return this.addInnerBefore(element, anchor2);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "addAfter"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "addRangeBefore"));
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, "Parent not found for " + this);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "replace"));
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "accept"));
        }
        visitor2.visitElement(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "processDeclarations"));
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        LazyParseablePsiElement lazyParseablePsiElement = this;
        if (lazyParseablePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getNavigationElement"));
        }
        return lazyParseablePsiElement;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file2 = this.getContainingFile();
        return file2 != null && file2.isPhysical();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        assert (this.isValid());
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getUseScope"));
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getProject"));
            }
            return project2;
        }
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project3 = manager.getProject();
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getProject"));
        }
        return project3;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        LazyParseablePsiElement lazyParseablePsiElement = this;
        if (lazyParseablePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LazyParseablePsiElement", "getNode"));
        }
        return lazyParseablePsiElement;
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

