#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: foundation
version: 0.0.8
id: foundation-0.0.8-9gswsO1cN1KLmRw0ulG1Ny
key: foundation-0.0.8-9gswsO1cN1KLmRw0ulG1Ny
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/haskell-foundation/foundation
synopsis: Alternative prelude with batteries and no dependencies
description:
    A custom prelude with no dependencies apart from base.
    .
    This package has the following goals:
    .
    * provide a base like sets of modules that provide a consistent set of features and bugfixes across multiple versions of GHC (unlike base).
    .
    * provide a better and more efficient prelude than base'\''s prelude.
    .
    * be self-sufficient: no external dependencies apart from base.
    .
    * provide better data-types: packed unicode string by default, arrays.
    .
    * Better numerical classes that better represent mathematical thing (No more all-in-one Num).
    .
    * Better I/O system with less Lazy IO
    .
    * Usual partial functions distinguished through type system
category: foundation
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Foundation Foundation.Numerical Foundation.Array
    Foundation.Array.Internal Foundation.Bits
    Foundation.Class.Bifunctor Foundation.Class.Storable
    Foundation.Conduit Foundation.Conduit.Textual
    Foundation.Convertible Foundation.String Foundation.String.ASCII
    Foundation.String.Read Foundation.IO Foundation.IO.FileMap
    Foundation.VFS Foundation.VFS.Path Foundation.VFS.FilePath
    Foundation.VFS.URI Foundation.Math.Trigonometry Foundation.Hashing
    Foundation.Foreign Foundation.Collection Foundation.Primitive
    Foundation.List.DList Foundation.Monad Foundation.Monad.Reader
    Foundation.Monad.State Foundation.Network.IPv4
    Foundation.Network.IPv6 Foundation.System.Info Foundation.Strict
    Foundation.Parser Foundation.Random Foundation.Check
    Foundation.UUID Foundation.System.Entropy
    Foundation.System.Bindings Foundation.System.Bindings.Posix
    Foundation.System.Bindings.PosixDef Foundation.System.Bindings.Hs
    Foundation.System.Bindings.Linux Foundation.Tuple.Nth
    Foundation.List.SList Foundation.Primitive.Nat
hidden-modules: Foundation.Boot.Builder Foundation.Boot.List
                Foundation.String.Internal Foundation.String.UTF8
                Foundation.String.Encoding.Encoding
                Foundation.String.Encoding.UTF16 Foundation.String.Encoding.UTF32
                Foundation.String.Encoding.ASCII7
                Foundation.String.Encoding.ISO_8859_1 Foundation.String.UTF8Table
                Foundation.String.ModifiedUTF8 Foundation.Tuple
                Foundation.Hashing.FNV Foundation.Hashing.SipHash
                Foundation.Hashing.Hasher Foundation.Hashing.Hashable
                Foundation.Check.Gen Foundation.Check.Arbitrary
                Foundation.Check.Property Foundation.Collection.Buildable
                Foundation.Collection.List Foundation.Collection.Element
                Foundation.Collection.InnerFunctor Foundation.Collection.Collection
                Foundation.Collection.Copy Foundation.Collection.Sequential
                Foundation.Collection.Keyed Foundation.Collection.Indexed
                Foundation.Collection.Foldable Foundation.Collection.Mutable
                Foundation.Collection.Zippable Foundation.Collection.Mappable
                Foundation.Conduit.Internal Foundation.Internal.Base
                Foundation.Internal.ByteSwap Foundation.Internal.CallStack
                Foundation.Internal.Environment Foundation.Internal.Error
                Foundation.Internal.Primitive Foundation.Internal.IsList
                Foundation.Internal.Identity Foundation.Internal.Proxy
                Foundation.Internal.PrimTypes Foundation.Internal.MonadTrans
                Foundation.Internal.Natural Foundation.Internal.NumLiteral
                Foundation.Numerical.Primitives Foundation.Numerical.Number
                Foundation.Numerical.Additive Foundation.Numerical.Subtractive
                Foundation.Numerical.Multiplicative Foundation.Numerical.Floating
                Foundation.IO.File Foundation.IO.Terminal
                Foundation.Primitive.Base16 Foundation.Primitive.Endianness
                Foundation.Primitive.Types Foundation.Primitive.Types.OffsetSize
                Foundation.Primitive.Monad Foundation.Primitive.NormalForm
                Foundation.Primitive.Utils Foundation.Primitive.IntegralConv
                Foundation.Primitive.Floating Foundation.Primitive.FinalPtr
                Foundation.Monad.MonadIO Foundation.Monad.Exception
                Foundation.Monad.Transformer Foundation.Monad.Identity
                Foundation.Monad.Base Foundation.Array.Chunked.Unboxed
                Foundation.Array.Common Foundation.Array.Unboxed
                Foundation.Array.Unboxed.Mutable Foundation.Array.Unboxed.ByteArray
                Foundation.Array.Boxed Foundation.Array.Bitmap
                Foundation.Foreign.MemoryMap Foundation.Foreign.MemoryMap.Types
                Foundation.Partial Foundation.System.Entropy.Common
                Foundation.System.Bindings.Network
                Foundation.Foreign.MemoryMap.Posix Foundation.System.Entropy.Unix
abi: 0654f8b2e31c5889e940ca0a33d1167b
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/foundation-0.0.8
library-dirs: /usr/lib/ghc-8.0.1/site-local/foundation-0.0.8
data-dir: /usr/share/arm-linux-ghc-8.0.1/foundation-0.0.8
hs-libraries: HSfoundation-0.0.8-9gswsO1cN1KLmRw0ulG1Ny
depends:
    base-4.9.0.0 ghc-prim-0.5.0.0
haddock-interfaces: /usr/share/doc/haskell-foundation/html/foundation.haddock
haddock-html: /usr/share/doc/haskell-foundation/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
