/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.draw.DrawHelper;
import com.baselet.element.facet.specific.sequence_aio.ExecutionSpecification;
import com.baselet.element.facet.specific.sequence_aio.LifelineDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.LifelineHorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;
import com.baselet.element.facet.specific.sequence_aio.SequenceDiagramCheckedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lifeline {
    private static final double ACTOR_DIMENSION = 10.0;
    private static final PointDouble ACTOR_SIZE = new PointDouble(DrawHelper.armLength(10.0) * 2.0, DrawHelper.headToLegLength(10.0));
    private static final double ACTIVE_CLASS_DOUBLE_BORDER_GAP = 10.0;
    private static final double HEAD_VERTICAL_BORDER_PADDING = 5.0;
    private static final double HEAD_HORIZONTAL_BORDER_PADDING = 5.0;
    private static final double EXECUTIONSPECIFICATION_WIDTH = 20.0;
    private static final double EXECUTIONSPECIFICATION_OVERLAPP = 8.0;
    private static final double DESTROY_SIZE = 20.0;
    private static final Logger log = LoggerFactory.getLogger(Lifeline.class);
    private final String[] text;
    private final int index;
    private final LifelineHeadType headType;
    private boolean createdOnStart;
    private Integer created;
    private Integer destroyed;
    private boolean execSpecFromStart;
    private final LinkedHashMap<Integer, LifelineOccurrence> lifeline;
    private final List<ExecutionSpecification> activeAreas;

    public Lifeline(String text, int index, LifelineHeadType headType, boolean createdOnStart, boolean execSpecFromStart) {
        this.text = text.split("\n");
        this.index = index;
        this.headType = headType;
        this.createdOnStart = createdOnStart;
        this.created = null;
        this.destroyed = null;
        this.execSpecFromStart = execSpecFromStart;
        this.lifeline = new LinkedHashMap();
        this.activeAreas = new ArrayList<ExecutionSpecification>();
    }

    public int getIndex() {
        return this.index;
    }

    public void setCreatedOnStart(boolean createdOnStart) {
        this.createdOnStart = createdOnStart;
    }

    public boolean isCreatedOnStart() {
        return this.createdOnStart;
    }

    public void setCreated(Integer created) {
        this.created = created;
    }

    public Integer getCreated() {
        return this.created;
    }

    public void setDestroyed(Integer destroyed) {
        this.destroyed = destroyed;
    }

    public Integer getDestroyed() {
        return this.destroyed;
    }

    public boolean isExecSpecFromStart() {
        return this.execSpecFromStart;
    }

    public void setExecSpecFromStart(boolean execSpecFromStart) {
        this.execSpecFromStart = execSpecFromStart;
    }

    public void addLifelineOccurrenceAtTick(LifelineOccurrence occurrence, Integer tick) throws SequenceDiagramCheckedException {
        if (!(this.isCreatedOnStart() || this.created != null && this.created < tick)) {
            throw new SequenceDiagramCheckedException("The lifeline can not contain occurrences before it is created.");
        }
        if (this.lifeline.containsKey(tick)) {
            throw new SequenceDiagramCheckedException("The lifeline already contains an occurence at the tick " + tick);
        }
        this.lifeline.put(tick, occurrence);
    }

    public void addExecutionSpecification(ExecutionSpecification execSpec) {
        int i = 0;
        while (i < this.activeAreas.size() && this.activeAreas.get(i).getStartTick() < execSpec.getStartTick()) {
            ++i;
        }
        this.activeAreas.add(i, execSpec);
    }

    public double getLifelineLeftPartWidth(int tick) {
        return this.getCurrentlyActiveExecutionSpecifications(tick) > 0 ? 10.0 : 0.0;
    }

    public double getLifelineRightPartWidth(int tick) {
        int currentlyActiveExecSpec = this.getCurrentlyActiveExecutionSpecifications(tick);
        if (currentlyActiveExecSpec == 0) {
            return 0.0;
        }
        return (double)(currentlyActiveExecSpec - 1) * 12.0 + 10.0;
    }

    public double getMinWidth(DrawHandler drawHandler) {
        double minWidth = 20.0;
        for (LifelineOccurrence llOccurrence : this.lifeline.values()) {
            minWidth = Math.max(minWidth, llOccurrence.getMinWidth(drawHandler));
        }
        if (this.activeAreas.size() == 1) {
            minWidth = Math.max(minWidth, 20.0);
        } else if (this.activeAreas.size() > 1) {
            int maxSimultaneousExecSpec = 0;
            for (ExecutionSpecification activeArea : this.activeAreas) {
                maxSimultaneousExecSpec = Math.max(maxSimultaneousExecSpec, this.getCurrentlyActiveExecutionSpecifications(activeArea.getStartTick()));
            }
            minWidth = Math.max(minWidth, (double)(maxSimultaneousExecSpec - 1) * 12.0 * 2.0 + 20.0);
        }
        minWidth = Math.max(minWidth, this.getHeadMinWidth(drawHandler));
        return minWidth;
    }

    private int getCurrentlyActiveExecutionSpecifications(int tick) {
        int currentlyActiveExecSpec = 0;
        int i = 0;
        while (i < this.activeAreas.size() && tick >= this.activeAreas.get(i).getStartTick()) {
            if (this.activeAreas.get(i).enclosesTick(tick)) {
                ++currentlyActiveExecSpec;
            }
            ++i;
        }
        return currentlyActiveExecSpec;
    }

    public Map<Integer, Double> getAdditionalYHeights(DrawHandler drawHandler, LifelineHorizontalDrawingInfo drawingInfo, double defaultTickHeight) {
        double headAdditionalHeight;
        HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, LifelineOccurrence> e : this.lifeline.entrySet()) {
            PointDouble size = new PointDouble(drawingInfo.getSymmetricWidth(e.getKey()), defaultTickHeight);
            double additionalY = e.getValue().getAdditionalYHeight(drawHandler, size);
            if (!(additionalY > 0.0)) continue;
            ret.put(e.getKey(), additionalY);
        }
        if (!this.createdOnStart && this.created != null && (headAdditionalHeight = this.getHeadMinHeight(drawHandler, drawingInfo.getSymmetricWidth(this.created)) - defaultTickHeight) > 0.0) {
            if (ret.containsKey(this.created)) {
                ret.put(this.created, Math.max((Double)ret.get(this.created), headAdditionalHeight));
            } else {
                ret.put(this.created, headAdditionalHeight);
            }
        }
        if (this.destroyed != null && 20.0 > defaultTickHeight) {
            if (ret.containsKey(this.destroyed)) {
                ret.put(this.destroyed, Math.max((Double)ret.get(this.destroyed), 20.0 - defaultTickHeight));
            } else {
                ret.put(this.destroyed, 20.0 - defaultTickHeight);
            }
        }
        return ret;
    }

    private double getHeadMinWidth(DrawHandler drawHandler) {
        double minWidth = Lifeline.ACTOR_SIZE.x;
        minWidth = Math.max(minWidth, TextSplitter.getTextMinWidth(this.text, drawHandler));
        if (this.headType == LifelineHeadType.STANDARD) {
            minWidth += 10.0;
        } else if (this.headType == LifelineHeadType.ACTIVE_CLASS) {
            minWidth = minWidth + 10.0 + 20.0;
        }
        return minWidth;
    }

    public double getHeadMinHeight(DrawHandler drawHandler, double width) {
        if (this.headType == LifelineHeadType.STANDARD || this.headType == LifelineHeadType.ACTIVE_CLASS) {
            width -= 10.0;
            if (this.headType == LifelineHeadType.ACTIVE_CLASS) {
                width -= 20.0;
            }
        }
        double minHeight = TextSplitter.getSplitStringHeight(this.text, width, drawHandler);
        if (this.headType == LifelineHeadType.ACTOR) {
            minHeight += Lifeline.ACTOR_SIZE.y.doubleValue();
        } else if (this.headType == LifelineHeadType.ACTIVE_CLASS || this.headType == LifelineHeadType.STANDARD) {
            minHeight += 10.0;
        } else {
            log.error("Encountered unhandled enumeration value '" + (Object)((Object)this.headType) + "'.");
        }
        return minHeight;
    }

    public void draw(DrawHandler drawHandler, LifelineDrawingInfo drawingInfo, int lifelineLastTick) {
        if (this.createdOnStart) {
            this.drawHead(drawHandler, drawingInfo.getHorizontalStart(), drawingInfo.getVerticalHeadStart(), drawingInfo.getWidth(), drawingInfo.getHeadHeight());
        } else if (this.created != null) {
            this.drawHead(drawHandler, drawingInfo.getSymmetricHorizontalStart(this.created), drawingInfo.getVerticalStart(this.created), drawingInfo.getSymmetricWidth(this.created), drawingInfo.getTickHeight(this.created));
        }
        if (this.createdOnStart || this.created != null) {
            for (Map.Entry<Integer, LifelineOccurrence> e : this.lifeline.entrySet()) {
                int tick = e.getKey();
                PointDouble topLeftOccurence = new PointDouble(drawingInfo.getSymmetricHorizontalStart(tick), drawingInfo.getVerticalStart(tick));
                PointDouble sizeOccurence = new PointDouble(drawingInfo.getSymmetricWidth(tick), drawingInfo.getTickHeight(tick));
                Line1D llInterruption = e.getValue().draw(drawHandler, topLeftOccurence, sizeOccurence);
                if (llInterruption == null) continue;
                drawingInfo.addInterruptedArea(llInterruption);
            }
            this.drawLifeline(drawHandler, drawingInfo, lifelineLastTick);
        }
    }

    private void drawLifeline(DrawHandler drawHandler, LifelineDrawingInfo drawingInfo, int lifelineLastTick) {
        int currentStartTick = 0;
        int currentActiveCount = 0;
        boolean startInc = false;
        LinkedList<ExecutionSpecification> active = new LinkedList<ExecutionSpecification>();
        if (!this.createdOnStart) {
            currentStartTick = this.created + 1;
        }
        ListIterator<ExecutionSpecification> execSpecIter = this.activeAreas.listIterator();
        ListIterator<Line1D> interruptedAreasIter = drawingInfo.getInterruptedAreas().listIterator();
        LineType oldLt = drawHandler.getLineType();
        if (this.execSpecFromStart && execSpecIter.hasNext()) {
            ExecutionSpecification execSpec = execSpecIter.next();
            if (execSpec.getStartTick() == currentStartTick - 1) {
                active.addFirst(execSpec);
                startInc = true;
            } else {
                execSpecIter.previous();
            }
        }
        double llTopY = drawingInfo.getVerticalStart(currentStartTick) - drawingInfo.getTickVerticalPadding();
        while (active.size() > 0 || execSpecIter.hasNext()) {
            int endTick;
            boolean endInc;
            currentActiveCount = active.size();
            if (active.size() > 0 && execSpecIter.hasNext()) {
                ExecutionSpecification execSpec = execSpecIter.next();
                if (((ExecutionSpecification)active.getFirst()).getEndTick() < execSpec.getStartTick()) {
                    execSpecIter.previous();
                    endInc = false;
                    endTick = ((ExecutionSpecification)active.removeFirst()).getEndTick();
                } else {
                    endInc = true;
                    endTick = execSpec.getStartTick();
                    active.addFirst(execSpec);
                }
            } else if (active.size() > 0) {
                endInc = false;
                endTick = ((ExecutionSpecification)active.removeFirst()).getEndTick();
            } else {
                ExecutionSpecification execSpec = execSpecIter.next();
                endInc = true;
                endTick = execSpec.getStartTick();
                active.addFirst(execSpec);
            }
            double llBottomY = drawingInfo.getVerticalCenter(endTick);
            this.drawLifelinePart(drawHandler, drawingInfo.getHorizontalCenter(), llTopY, startInc, llBottomY, endInc, currentActiveCount, interruptedAreasIter);
            currentStartTick = endTick;
            llTopY = llBottomY;
            startInc = endInc;
        }
        if (this.destroyed == null) {
            this.drawLifelinePart(drawHandler, drawingInfo.getHorizontalCenter(), llTopY, false, drawingInfo.getVerticalEnd(lifelineLastTick), false, 0, interruptedAreasIter);
        } else {
            drawHandler.setLineType(LineType.SOLID);
            double halfSize = 10.0;
            double centerX = drawingInfo.getHorizontalCenter();
            double centerY = drawingInfo.getVerticalCenter(this.destroyed);
            drawHandler.drawLine(centerX - halfSize, centerY - halfSize, centerX + halfSize, centerY + halfSize);
            drawHandler.drawLine(centerX + halfSize, centerY - halfSize, centerX - halfSize, centerY + halfSize);
            if (this.destroyed > currentStartTick) {
                this.drawLifelinePart(drawHandler, drawingInfo.getHorizontalCenter(), llTopY, false, drawingInfo.getVerticalCenter(this.destroyed), false, 0, interruptedAreasIter);
            }
        }
        drawHandler.setLineType(oldLt);
    }

    private void drawLifelinePart(DrawHandler drawHandler, double centerX, double startY, boolean activeCountIncStart, double endY, boolean activeCountIncEnd, int activeCount, ListIterator<Line1D> interruptedAreas) {
        double nextStartY = startY;
        boolean drawHead = true;
        if (interruptedAreas.hasNext()) {
            Line1D area = interruptedAreas.next();
            if (area.contains(nextStartY)) {
                drawHead = false;
                nextStartY = area.getHigh();
            } else {
                interruptedAreas.previous();
            }
        }
        boolean drawingFinished = false;
        boolean drawEnd = false;
        while (!drawingFinished) {
            double currentEndY;
            double currentStartY = nextStartY;
            if (interruptedAreas.hasNext()) {
                Line1D area = interruptedAreas.next();
                if (area.getLow() < endY) {
                    currentEndY = area.getLow();
                    nextStartY = area.getHigh();
                    if (area.getHigh() > endY) {
                        drawingFinished = true;
                        interruptedAreas.previous();
                    }
                } else {
                    interruptedAreas.previous();
                    drawingFinished = true;
                    drawEnd = true;
                    currentEndY = endY;
                }
            } else {
                drawingFinished = true;
                drawEnd = true;
                currentEndY = endY;
            }
            if (activeCount == 0) {
                drawHandler.setLineType(LineType.DASHED);
                drawHandler.drawLine(centerX, currentStartY, centerX, currentEndY);
            } else {
                drawHandler.setLineType(LineType.SOLID);
                double lineX = centerX - 10.0;
                drawHandler.drawLine(lineX, currentStartY, lineX, currentEndY);
                int i = 0;
                while (i < activeCount - 1) {
                    drawHandler.drawLine(lineX += 12.0, currentStartY, lineX, currentEndY);
                    ++i;
                }
                drawHandler.drawLine(lineX += 20.0, currentStartY, lineX, currentEndY);
                if (drawHead && activeCountIncStart) {
                    drawHandler.drawLine(lineX - 20.0, currentStartY, lineX, currentStartY);
                }
                if (drawEnd && !activeCountIncEnd) {
                    drawHandler.drawLine(lineX - 20.0, currentEndY, lineX, currentEndY);
                }
            }
            drawHead = false;
        }
    }

    private void drawHead(DrawHandler drawHandler, double x, double y, double width, double height) {
        if (this.headType == LifelineHeadType.STANDARD || this.headType == LifelineHeadType.ACTIVE_CLASS) {
            drawHandler.drawRectangle(x, y, width, height);
            if (this.headType == LifelineHeadType.ACTIVE_CLASS) {
                drawHandler.drawLine(x + 10.0, y, x + 10.0, y + height);
                drawHandler.drawLine(x + width - 10.0, y, x + width - 10.0, y + height);
                x += 10.0;
                width -= 20.0;
            }
            TextSplitter.drawText(drawHandler, this.text, x += 5.0, y += 5.0, width -= 10.0, height -= 10.0, AlignHorizontal.CENTER, AlignVertical.CENTER);
        } else if (this.headType == LifelineHeadType.ACTOR) {
            DrawHelper.drawActor(drawHandler, (int)(x + width / 2.0), (int)y, 10.0);
            TextSplitter.drawText(drawHandler, this.text, x, y += Lifeline.ACTOR_SIZE.y.doubleValue(), width, height -= Lifeline.ACTOR_SIZE.y.doubleValue(), AlignHorizontal.CENTER, AlignVertical.BOTTOM);
        } else {
            log.error("Encountered unhandled enumeration value '" + (Object)((Object)this.headType) + "'.");
        }
    }

    public static enum LifelineHeadType {
        STANDARD,
        ACTIVE_CLASS,
        ACTOR;

    }
}

