/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class BaseDetailsRenderer
extends BaseRenderer {
    private static final int DEFAULT_DETAILS_GAP = 3;
    private final int detailsGap;
    private final ProfilerRenderer valueRenderer;
    private final LabelRenderer detailsRenderer;
    private final int detailsRendererWidth;

    public BaseDetailsRenderer(ProfilerRenderer profilerRenderer, String string) {
        this(profilerRenderer, string, 3);
    }

    public BaseDetailsRenderer(ProfilerRenderer profilerRenderer, String string, int n) {
        this.detailsGap = n;
        this.valueRenderer = profilerRenderer;
        if (profilerRenderer instanceof LabelRenderer) {
            ((LabelRenderer)profilerRenderer).setMargin(3, 3, 3, 0);
        }
        this.detailsRenderer = new LabelRenderer();
        this.detailsRenderer.setMargin(3, 0, 3, 3);
        this.detailsRenderer.changeFontSize(-1);
        this.detailsRenderer.setForeground(UIUtils.getDisabledLineColor());
        this.detailsRenderer.setText(string);
        this.detailsRendererWidth = this.detailsRenderer.getPreferredSize().width;
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.valueRenderer != null) {
            this.valueRenderer.getComponent().setOpaque(bl);
        }
        if (this.detailsRenderer != null) {
            this.detailsRenderer.setOpaque(bl);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.valueRenderer != null) {
            this.valueRenderer.getComponent().setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.valueRenderer != null) {
            this.valueRenderer.getComponent().setBackground(color);
        }
        this.detailsRenderer.setBackground(color);
    }

    @Override
    public void setHorizontalAlignment(int n) {
        super.setHorizontalAlignment(n);
        JComponent jComponent = this.valueRenderer.getComponent();
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setHorizontalAlignment(n);
        } else if (this.valueRenderer instanceof BaseRenderer) {
            ((BaseRenderer)this.valueRenderer).setHorizontalAlignment(n);
        }
        this.detailsRenderer.setHorizontalAlignment(n);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.valueRenderer.getComponent().getPreferredSize();
        dimension.width += this.detailsGap + this.detailsRendererWidth;
        return dimension;
    }

    @Override
    public void setValue(Object object, int n) {
        String string;
        String string2;
        String string3 = object.toString();
        int n2 = string3.indexOf(40);
        if (n2 == -1) {
            string2 = string3;
            string = "";
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2);
        }
        this.valueRenderer.setValue(string2, n);
        this.detailsRenderer.setValue(string, n);
    }

    public void setValues(Object object, String string, int n) {
        this.valueRenderer.setValue(object, n);
        this.detailsRenderer.setValue(string, n);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.location.x + this.size.width - this.detailsRendererWidth;
        this.detailsRenderer.setSize(this.detailsRendererWidth, this.size.height);
        this.detailsRenderer.move(n, this.location.y);
        this.detailsRenderer.paint(graphics);
        JComponent jComponent = this.valueRenderer.getComponent();
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setSize(dimension.width, this.size.height);
        this.valueRenderer.move(n -= this.detailsGap + dimension.width, this.location.y);
        jComponent.paint(graphics);
    }
}

