/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder
implements JAXPConstants {
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private DOMParser domParser = new DOMParser();

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (documentBuilderFactory.isValidating()) {
            this.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.domParser.setFeature("http://xml.org/sax/features/validation", documentBuilderFactory.isValidating());
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", documentBuilderFactory.isNamespaceAware());
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !documentBuilderFactory.isIgnoringElementContentWhitespace());
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !documentBuilderFactory.isExpandEntityReferences());
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", !documentBuilderFactory.isIgnoringComments());
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", !documentBuilderFactory.isCoalescing());
        this.setDocumentBuilderFactoryAttributes(hashtable);
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Boolean) {
                this.domParser.setFeature(string, (Boolean)v);
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(v)) continue;
                this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                continue;
            }
            this.domParser.setProperty(string, v);
        }
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.domParser.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.domParser.setErrorHandler(this.eh);
        }
        this.domParser.parse(inputSource);
        return this.domParser.getDocument();
    }

    public boolean isNamespaceAware() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }
}

