#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

bonds = {
'ACE': [
   { ### names ###
   '1HH3':0, '3HA' :0, 'HH31':0, 
   '1HA' :1, '2HH3':1, 'HH32':1, 
   '2HA' :2, '3HH3':2, 'HH33':2, 
   'C'   :3, 
   'CA'  :4, 'CH3' :4, 
   'O'   :5, 
   },
   [ ### bonds ###
   ( 0,  4,  1 ),
   ( 1,  4,  1 ),
   ( 2,  4,  1 ),
   ( 3,  4,  1 ),
   ( 3,  5,  2 ),
   ]],
'ALA': [
   { ### names ###
   '1HB' :0, 'HB1' :0, 
   '1H'  :1, '1HT' :1, 'H1'  :1, 'HT1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2H'  :3, '2HT' :3, 'H2'  :3, 'HT2' :3, 
   '3HB' :4, 'HB3' :4, 
   '3H'  :5, '3HT' :5, 'H3'  :5, 'HT3' :5, 
   'C'   :6, 
   'CA'  :7, 
   'CB'  :8, 
   'H'   :9, 'HN'  :9, 
   'HA'  :10, 'HA2' :10, 
   'N'   :11, 
   'O'   :12, 'O1'  :12, 'OT1' :12, 
   'O2'  :13, 'OT'  :13, 'OT2' :13, 'OXT' :13, 
   },
   [ ### bonds ###
   ( 0,  8,  1 ),
   ( 1, 11,  1 ),
   ( 2,  8,  1 ),
   ( 3, 11,  1 ),
   ( 4,  8,  1 ),
   ( 5, 11,  1 ),
   ( 6,  7,  1 ),
   ( 6, 12,  2 ),
   ( 7,  8,  1 ),
   ( 7, 10,  1 ),
   ( 7, 11,  1 ),
   ( 9, 11,  1 ),
   ]],
'ARG': [
   { ### names ###
   '1HH1':0, 'HH11':0, 
   '1HH2':1, 'HH21':1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD' :4, 'HD2' :4, 
   '2HG' :5, 'HG2' :5, 
   '2HH1':6, 'HH12':6, 
   '2HH2':7, 'HH22':7, 
   '2H'  :8, '2HT' :8, 'H2'  :8, 'HT2' :8, 
   '1HB' :9, '3HB' :9, 'HB1' :9, 'HB3' :9, 
   '1HD' :10, '3HD' :10, 'HD1' :10, 'HD3' :10, 
   '1HG' :11, '3HG' :11, 'HG1' :11, 'HG3' :11, 
   '3H'  :12, '3HT' :12, 'H3'  :12, 'HT3' :12, 
   'C'   :13, 
   'CA'  :14, 
   'CB'  :15, 
   'CD'  :16, 
   'CG'  :17, 
   'CZ'  :18, 
   'H'   :19, 'HN'  :19, 
   'HA'  :20, 'HA2' :20, 
   'HE'  :21, 
   'N'   :22, 
   'NE'  :23, 
   'NH1' :24, 
   'NH2' :25, 
   'O'   :26, 'O1'  :26, 'OT1' :26, 
   'O2'  :27, 'OT'  :27, 'OT2' :27, 'OXT' :27, 
   },
   [ ### bonds ###
   ( 0, 24,  1 ),
   ( 1, 25,  1 ),
   ( 2, 22,  1 ),
   ( 3, 15,  1 ),
   ( 4, 16,  1 ),
   ( 5, 17,  1 ),
   ( 6, 24,  1 ),
   ( 7, 25,  1 ),
   ( 8, 22,  1 ),
   ( 9, 15,  1 ),
   (10, 16,  1 ),
   (11, 17,  1 ),
   (12, 22,  1 ),
   (13, 14,  1 ),
   (13, 26,  2 ),
   (14, 15,  1 ),
   (14, 20,  1 ),
   (14, 22,  1 ),
   (15, 17,  1 ),
   (16, 17,  1 ),
   (16, 23,  1 ),
   (18, 23,  1 ),
   (18, 24,  2 ),
   (18, 25,  1 ),
   (19, 22,  1 ),
   (21, 23,  1 ),
   ]],
'ASH': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2H'  :2, '2HT' :2, 'H2'  :2, 'HT2' :2, 
   '1HB' :3, '3HB' :3, 'HB1' :3, 'HB3' :3, 
   '3H'  :4, '3HT' :4, 'H3'  :4, 'HT3' :4, 
   'C'   :5, 
   'CA'  :6, 
   'CB'  :7, 
   'CG'  :8, 
   'H'   :9, 'HN'  :9, 
   'HA'  :10, 'HA2' :10, 
   'HD2' :11, 
   'N'   :12, 
   'O'   :13, 'O1'  :13, 'OT1' :13, 
   'OD1' :14, 
   'OD2' :15, 
   'O2'  :16, 'OT'  :16, 'OT2' :16, 'OXT' :16, 
   },
   [ ### bonds ###
   ( 0, 12,  1 ),
   ( 1,  7,  1 ),
   ( 2, 12,  1 ),
   ( 3,  7,  1 ),
   ( 4, 12,  1 ),
   ( 5,  6,  1 ),
   ( 5, 13,  2 ),
   ( 6,  7,  1 ),
   ( 6, 10,  1 ),
   ( 6, 12,  1 ),
   ( 7,  8,  1 ),
   ( 8, 14,  2 ),
   ( 8, 15,  1 ),
   ( 9, 12,  1 ),
   (11, 15,  1 ),
   ]],
'ASN': [
   { ### names ###
   '1HD2':0, 'HD21':0, 
   '1H'  :1, '1HT' :1, 'H1'  :1, 'HT1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2HD2':3, 'HD22':3, 
   '2H'  :4, '2HT' :4, 'H2'  :4, 'HT2' :4, 
   '1HB' :5, '3HB' :5, 'HB1' :5, 'HB3' :5, 
   '3H'  :6, '3HT' :6, 'H3'  :6, 'HT3' :6, 
   'C'   :7, 
   'CA'  :8, 
   'CB'  :9, 
   'CG'  :10, 
   'H'   :11, 'HN'  :11, 
   'HA'  :12, 'HA2' :12, 
   'N'   :13, 
   'ND2' :14, 
   'O'   :15, 'O1'  :15, 'OT1' :15, 
   'OD1' :16, 
   'O2'  :17, 'OT'  :17, 'OT2' :17, 'OXT' :17, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1, 13,  1 ),
   ( 2,  9,  1 ),
   ( 3, 14,  1 ),
   ( 4, 13,  1 ),
   ( 5,  9,  1 ),
   ( 6, 13,  1 ),
   ( 7,  8,  1 ),
   ( 7, 15,  2 ),
   ( 8,  9,  1 ),
   ( 8, 12,  1 ),
   ( 8, 13,  1 ),
   ( 9, 10,  1 ),
   (10, 14,  1 ),
   (10, 16,  2 ),
   (11, 13,  1 ),
   ]],
'ASP': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2H'  :2, '2HT' :2, 'H2'  :2, 'HT2' :2, 
   '1HB' :3, '3HB' :3, 'HB1' :3, 'HB3' :3, 
   '3H'  :4, '3HT' :4, 'H3'  :4, 'HT3' :4, 
   'C'   :5, 
   'CA'  :6, 
   'CB'  :7, 
   'CG'  :8, 
   'H'   :9, 'HN'  :9, 
   'HA'  :10, 'HA2' :10, 
   'N'   :11, 
   'O'   :12, 'O1'  :12, 'OT1' :12, 
   'OD1' :13, 
   'OD2' :14, 
   'O2'  :15, 'OT'  :15, 'OT2' :15, 'OXT' :15, 
   },
   [ ### bonds ###
   ( 0, 11,  1 ),
   ( 1,  7,  1 ),
   ( 2, 11,  1 ),
   ( 3,  7,  1 ),
   ( 4, 11,  1 ),
   ( 5,  6,  1 ),
   ( 5, 12,  2 ),
   ( 6,  7,  1 ),
   ( 6, 10,  1 ),
   ( 6, 11,  1 ),
   ( 7,  8,  1 ),
   ( 8, 13,  2 ),
   ( 8, 14,  1 ),
   ( 9, 11,  1 ),
   ]],
'CYM': [
   { ### names ###
   '2HB' :0, 'HB2' :0, 
   '3HB' :1, 'HB3' :1, 
   'C'   :2, 
   'CA'  :3, 
   'CB'  :4, 
   'H'   :5, 'HN'  :5, 
   'HA'  :6, 'HA2' :6, 
   'N'   :7, 
   'O'   :8, 
   'SG'  :9, 
   },
   [ ### bonds ###
   ( 0,  4,  1 ),
   ( 1,  4,  1 ),
   ( 2,  3,  1 ),
   ( 2,  8,  2 ),
   ( 3,  4,  1 ),
   ( 3,  6,  1 ),
   ( 3,  7,  1 ),
   ( 4,  9,  1 ),
   ( 5,  7,  1 ),
   ]],
'CYS': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2H'  :2, '2HT' :2, 'H2'  :2, 'HT2' :2, 
   '1HB' :3, '3HB' :3, 'HB1' :3, 'HB3' :3, 
   '3H'  :4, '3HT' :4, 'H3'  :4, 'HT3' :4, 
   'C'   :5, 
   'CA'  :6, 
   'CB'  :7, 
   'H'   :8, 'HN'  :8, 
   'HA'  :9, 'HA2' :9, 
   'HG'  :10, 'HG1' :10, 
   'N'   :11, 
   'O'   :12, 'O1'  :12, 'OT1' :12, 
   'O2'  :13, 'OT'  :13, 'OT2' :13, 'OXT' :13, 
   'SG'  :14, 
   },
   [ ### bonds ###
   ( 0, 11,  1 ),
   ( 1,  7,  1 ),
   ( 2, 11,  1 ),
   ( 3,  7,  1 ),
   ( 4, 11,  1 ),
   ( 5,  6,  1 ),
   ( 5, 12,  2 ),
   ( 6,  7,  1 ),
   ( 6,  9,  1 ),
   ( 6, 11,  1 ),
   ( 7, 14,  1 ),
   ( 8, 11,  1 ),
   (10, 14,  1 ),
   ]],
'CYX': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2H'  :2, '2HT' :2, 'H2'  :2, 'HT2' :2, 
   '1HB' :3, '3HB' :3, 'HB1' :3, 'HB3' :3, 
   '3H'  :4, '3HT' :4, 'H3'  :4, 'HT3' :4, 
   'C'   :5, 
   'CA'  :6, 
   'CB'  :7, 
   'H'   :8, 'HN'  :8, 
   'HA'  :9, 'HA2' :9, 
   'N'   :10, 
   'O'   :11, 'O1'  :11, 'OT1' :11, 
   'O2'  :12, 'OT'  :12, 'OT2' :12, 'OXT' :12, 
   'SG'  :13, 
   },
   [ ### bonds ###
   ( 0, 10,  1 ),
   ( 1,  7,  1 ),
   ( 2, 10,  1 ),
   ( 3,  7,  1 ),
   ( 4, 10,  1 ),
   ( 5,  6,  1 ),
   ( 5, 11,  2 ),
   ( 6,  7,  1 ),
   ( 6,  9,  1 ),
   ( 6, 10,  1 ),
   ( 7, 13,  1 ),
   ( 8, 10,  1 ),
   ]],
'GLN': [
   { ### names ###
   '1HE2':0, 'HE21':0, 
   '1H'  :1, '1HT' :1, 'H1'  :1, 'HT1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2HE2':3, 'HE22':3, 
   '2HG' :4, 'HG2' :4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '1HB' :6, '3HB' :6, 'HB1' :6, 'HB3' :6, 
   '1HG' :7, '3HG' :7, 'HG1' :7, 'HG3' :7, 
   '3H'  :8, '3HT' :8, 'H3'  :8, 'HT3' :8, 
   'C'   :9, 
   'CA'  :10, 
   'CB'  :11, 
   'CD'  :12, 
   'CG'  :13, 
   'H'   :14, 'HN'  :14, 
   'HA'  :15, 'HA2' :15, 
   'N'   :16, 
   'NE2' :17, 
   'O'   :18, 'O1'  :18, 'OT1' :18, 
   'OE1' :19, 
   'O2'  :20, 'OT'  :20, 'OT2' :20, 'OXT' :20, 
   },
   [ ### bonds ###
   ( 0, 17,  1 ),
   ( 1, 16,  1 ),
   ( 2, 11,  1 ),
   ( 3, 17,  1 ),
   ( 4, 13,  1 ),
   ( 5, 16,  1 ),
   ( 6, 11,  1 ),
   ( 7, 13,  1 ),
   ( 8, 16,  1 ),
   ( 9, 10,  1 ),
   ( 9, 18,  2 ),
   (10, 11,  1 ),
   (10, 15,  1 ),
   (10, 16,  1 ),
   (11, 13,  1 ),
   (12, 13,  1 ),
   (12, 17,  1 ),
   (12, 19,  2 ),
   (14, 16,  1 ),
   ]],
'GLP': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2HG' :2, 'HG2' :2, 
   '2H'  :3, '2HT' :3, 'H2'  :3, 'HT2' :3, 
   '1HB' :4, '3HB' :4, 'HB1' :4, 'HB3' :4, 
   '1HG' :5, '3HG' :5, 'HG1' :5, 'HG3' :5, 
   '3H'  :6, '3HT' :6, 'H3'  :6, 'HT3' :6, 
   'C'   :7, 
   'CA'  :8, 
   'CB'  :9, 
   'CD'  :10, 
   'CG'  :11, 
   'H'   :12, 'HN'  :12, 
   'HA'  :13, 'HA2' :13, 
   'HE2' :14, 
   'N'   :15, 
   'O'   :16, 'O1'  :16, 'OT1' :16, 
   'OE1' :17, 
   'OE2' :18, 
   'O2'  :19, 'OT'  :19, 'OT2' :19, 'OXT' :19, 
   },
   [ ### bonds ###
   ( 0, 15,  1 ),
   ( 1,  9,  1 ),
   ( 2, 11,  1 ),
   ( 3, 15,  1 ),
   ( 4,  9,  1 ),
   ( 5, 11,  1 ),
   ( 6, 15,  1 ),
   ( 7,  8,  1 ),
   ( 7, 16,  2 ),
   ( 8,  9,  1 ),
   ( 8, 13,  1 ),
   ( 8, 15,  1 ),
   ( 9, 11,  1 ),
   (10, 11,  1 ),
   (10, 17,  2 ),
   (10, 18,  1 ),
   (12, 15,  1 ),
   (14, 18,  1 ),
   ]],
'GLU': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2HG' :2, 'HG2' :2, 
   '2H'  :3, '2HT' :3, 'H2'  :3, 'HT2' :3, 
   '1HB' :4, '3HB' :4, 'HB1' :4, 'HB3' :4, 
   '1HG' :5, '3HG' :5, 'HG1' :5, 'HG3' :5, 
   '3H'  :6, '3HT' :6, 'H3'  :6, 'HT3' :6, 
   'C'   :7, 
   'CA'  :8, 
   'CB'  :9, 
   'CD'  :10, 
   'CG'  :11, 
   'H'   :12, 'HN'  :12, 
   'HA'  :13, 'HA2' :13, 
   'N'   :14, 
   'O'   :15, 'O1'  :15, 'OT1' :15, 
   'OE1' :16, 
   'OE2' :17, 
   'O2'  :18, 'OT'  :18, 'OT2' :18, 'OXT' :18, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1,  9,  1 ),
   ( 2, 11,  1 ),
   ( 3, 14,  1 ),
   ( 4,  9,  1 ),
   ( 5, 11,  1 ),
   ( 6, 14,  1 ),
   ( 7,  8,  1 ),
   ( 7, 15,  2 ),
   ( 8,  9,  1 ),
   ( 8, 13,  1 ),
   ( 8, 14,  1 ),
   ( 9, 11,  1 ),
   (10, 11,  1 ),
   (10, 16,  2 ),
   (10, 17,  1 ),
   (12, 14,  1 ),
   ]],
'GLY': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2H'  :1, '2HT' :1, 'H2'  :1, 'HT2' :1, 
   '1HA' :2, '3HA' :2, 'HA1' :2, 'HA3' :2, 
   '3H'  :3, '3HT' :3, 'H3'  :3, 'HT3' :3, 
   'C'   :4, 
   'CA'  :5, 
   'H'   :6, 'HN'  :6, 
   '2HA' :7, 'HA'  :7, 'HA2' :7, 
   'N'   :8, 
   'O'   :9, 'O1'  :9, 'OT1' :9, 
   'O2'  :10, 'OT'  :10, 'OT2' :10, 'OXT' :10, 
   },
   [ ### bonds ###
   ( 0,  8,  1 ),
   ( 1,  8,  1 ),
   ( 2,  5,  1 ),
   ( 3,  8,  1 ),
   ( 4,  5,  1 ),
   ( 4,  9,  2 ),
   ( 5,  7,  1 ),
   ( 5,  8,  1 ),
   ( 6,  8,  1 ),
   ]],
'HID': [
   { ### names ###
   '1HD' :0, 'HD1' :0, 
   '1HE' :1, 'HE1' :1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD' :4, 'HD2' :4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '1HB' :6, '3HB' :6, 'HB1' :6, 'HB3' :6, 
   '3H'  :7, '3HT' :7, 'H3'  :7, 'HT3' :7, 
   'C'   :8, 
   'CA'  :9, 
   'CB'  :10, 
   'CD2' :11, 
   'CE1' :12, 
   'CG'  :13, 
   'H'   :14, 'HN'  :14, 
   'HA'  :15, 'HA2' :15, 
   'N'   :16, 
   'ND1' :17, 
   'NE2' :18, 
   'O'   :19, 'O1'  :19, 'OT1' :19, 
   'O2'  :20, 'OT'  :20, 'OT2' :20, 'OXT' :20, 
   },
   [ ### bonds ###
   ( 0, 17,  1 ),
   ( 1, 12,  1 ),
   ( 2, 16,  1 ),
   ( 3, 10,  1 ),
   ( 4, 11,  1 ),
   ( 5, 16,  1 ),
   ( 6, 10,  1 ),
   ( 7, 16,  1 ),
   ( 8,  9,  1 ),
   ( 8, 19,  2 ),
   ( 9, 10,  1 ),
   ( 9, 15,  1 ),
   ( 9, 16,  1 ),
   (10, 13,  1 ),
   (11, 13,  2 ),
   (11, 18,  1 ),
   (12, 17,  1 ),
   (12, 18,  2 ),
   (13, 17,  1 ),
   (14, 16,  1 ),
   ]],
'HIE': [
   { ### names ###
   '1HE' :0, 'HE1' :0, 
   '1H'  :1, '1HT' :1, 'H1'  :1, 'HT1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2HD' :3, 'HD1' :3, 'HD2' :3, 
   '2HE' :4, 'HE2' :4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '1HB' :6, '3HB' :6, 'HB1' :6, 'HB3' :6, 
   '3H'  :7, '3HT' :7, 'H3'  :7, 'HT3' :7, 
   'C'   :8, 
   'CA'  :9, 
   'CB'  :10, 
   'CD2' :11, 
   'CE1' :12, 
   'CG'  :13, 
   'H'   :14, 'HN'  :14, 
   'HA'  :15, 'HA2' :15, 
   'N'   :16, 
   'ND1' :17, 
   'NE2' :18, 
   'O'   :19, 'O1'  :19, 'OT1' :19, 
   'O2'  :20, 'OT'  :20, 'OT2' :20, 'OXT' :20, 
   },
   [ ### bonds ###
   ( 0, 12,  1 ),
   ( 1, 16,  1 ),
   ( 2, 10,  1 ),
   ( 3, 11,  1 ),
   ( 4, 18,  1 ),
   ( 5, 16,  1 ),
   ( 6, 10,  1 ),
   ( 7, 16,  1 ),
   ( 8,  9,  1 ),
   ( 8, 19,  2 ),
   ( 9, 10,  1 ),
   ( 9, 15,  1 ),
   ( 9, 16,  1 ),
   (10, 13,  1 ),
   (11, 13,  2 ),
   (11, 18,  1 ),
   (12, 17,  2 ),
   (12, 18,  1 ),
   (13, 17,  1 ),
   (14, 16,  1 ),
   ]],
'HIP': [
   { ### names ###
   '1HD' :0, 'HD1' :0, 
   '1HE' :1, 'HE1' :1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD' :4, 'HD2' :4, 
   '2HE' :5, 'HE2' :5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '1HB' :7, '3HB' :7, 'HB1' :7, 'HB3' :7, 
   '3H'  :8, '3HT' :8, 'H3'  :8, 'HT3' :8, 
   'C'   :9, 
   'CA'  :10, 
   'CB'  :11, 
   'CD2' :12, 
   'CE1' :13, 
   'CG'  :14, 
   'H'   :15, 'HN'  :15, 
   'HA'  :16, 'HA2' :16, 
   'N'   :17, 
   'ND1' :18, 
   'NE2' :19, 
   'O'   :20, 'O1'  :20, 'OT1' :20, 
   'O2'  :21, 'OT'  :21, 'OT2' :21, 'OXT' :21, 
   },
   [ ### bonds ###
   ( 0, 18,  1 ),
   ( 1, 13,  1 ),
   ( 2, 17,  1 ),
   ( 3, 11,  1 ),
   ( 4, 12,  1 ),
   ( 5, 19,  1 ),
   ( 6, 17,  1 ),
   ( 7, 11,  1 ),
   ( 8, 17,  1 ),
   ( 9, 10,  1 ),
   ( 9, 20,  2 ),
   (10, 11,  1 ),
   (10, 16,  1 ),
   (10, 17,  1 ),
   (11, 14,  1 ),
   (12, 14,  2 ),
   (12, 19,  1 ),
   (13, 18,  2 ),
   (13, 19,  1 ),
   (14, 18,  1 ),
   (15, 17,  1 ),
   ]],
'ILE': [
   { ### names ###
   '1HD1':0, 'HD1' :0, 'HD11':0, 
   '1HG2':1, 'HG21':1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HD1':3, 'HD12':3, 'HD2' :3, 
   '2HG1':4, 'HG12':4, 
   '2HG2':5, 'HG22':5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '3HD1':7, 'HD13':7, 'HD3' :7, 
   '1HG1':8, '3HG1':8, 'HG11':8, 'HG13':8, 
   '3HG2':9, 'HG23':9, 
   '3H'  :10, '3HT' :10, 'H3'  :10, 'HT3' :10, 
   'C'   :11, 
   'CA'  :12, 
   'CB'  :13, 
   'CD'  :14, 'CD1' :14, 
   'CG1' :15, 
   'CG2' :16, 
   'H'   :17, 'HN'  :17, 
   'HA'  :18, 'HA2' :18, 
   'HB'  :19, 
   'N'   :20, 
   'O'   :21, 'O1'  :21, 'OT1' :21, 
   'O2'  :22, 'OT'  :22, 'OT2' :22, 'OXT' :22, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1, 16,  1 ),
   ( 2, 20,  1 ),
   ( 3, 14,  1 ),
   ( 4, 15,  1 ),
   ( 5, 16,  1 ),
   ( 6, 20,  1 ),
   ( 7, 14,  1 ),
   ( 8, 15,  1 ),
   ( 9, 16,  1 ),
   (10, 20,  1 ),
   (11, 12,  1 ),
   (11, 21,  2 ),
   (12, 13,  1 ),
   (12, 18,  1 ),
   (12, 20,  1 ),
   (13, 15,  1 ),
   (13, 16,  1 ),
   (13, 19,  1 ),
   (14, 15,  1 ),
   (17, 20,  1 ),
   ]],
'LEU': [
   { ### names ###
   '1HD1':0, 'HD11':0, 
   '1HD2':1, 'HD21':1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD1':4, 'HD12':4, 
   '2HD2':5, 'HD22':5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '1HB' :7, '3HB' :7, 'HB1' :7, 'HB3' :7, 
   '3HD1':8, 'HD13':8, 
   '3HD2':9, 'HD23':9, 
   '3H'  :10, '3HT' :10, 'H3'  :10, 'HT3' :10, 
   'C'   :11, 
   'CA'  :12, 
   'CB'  :13, 
   'CD1' :14, 
   'CD2' :15, 
   'CG'  :16, 
   'H'   :17, 'HN'  :17, 
   'HA'  :18, 'HA2' :18, 
   'HG'  :19, 
   'N'   :20, 
   'O'   :21, 'O1'  :21, 'OT1' :21, 
   'O2'  :22, 'OT'  :22, 'OT2' :22, 'OXT' :22, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1, 15,  1 ),
   ( 2, 20,  1 ),
   ( 3, 13,  1 ),
   ( 4, 14,  1 ),
   ( 5, 15,  1 ),
   ( 6, 20,  1 ),
   ( 7, 13,  1 ),
   ( 8, 14,  1 ),
   ( 9, 15,  1 ),
   (10, 20,  1 ),
   (11, 12,  1 ),
   (11, 21,  2 ),
   (12, 13,  1 ),
   (12, 18,  1 ),
   (12, 20,  1 ),
   (13, 16,  1 ),
   (14, 16,  1 ),
   (15, 16,  1 ),
   (16, 19,  1 ),
   (17, 20,  1 ),
   ]],
'LYS': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '1HZ' :1, 'HZ1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2HD' :3, 'HD2' :3, 
   '2HE' :4, 'HE2' :4, 
   '2HG' :5, 'HG2' :5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '2HZ' :7, 'HZ2' :7, 
   '1HB' :8, '3HB' :8, 'HB1' :8, 'HB3' :8, 
   '1HD' :9, '3HD' :9, 'HD1' :9, 'HD3' :9, 
   '1HE' :10, '3HE' :10, 'HE1' :10, 'HE3' :10, 
   '1HG' :11, '3HG' :11, 'HG1' :11, 'HG3' :11, 
   '3H'  :12, '3HT' :12, 'H3'  :12, 'HT3' :12, 
   '3HZ' :13, 'HZ3' :13, 
   'C'   :14, 
   'CA'  :15, 
   'CB'  :16, 
   'CD'  :17, 
   'CE'  :18, 
   'CG'  :19, 
   'H'   :20, 'HN'  :20, 
   'HA'  :21, 'HA2' :21, 
   'N'   :22, 
   'NZ'  :23, 
   'O'   :24, 'O1'  :24, 'OT1' :24, 
   'O2'  :25, 'OT'  :25, 'OT2' :25, 'OXT' :25, 
   },
   [ ### bonds ###
   ( 0, 22,  1 ),
   ( 1, 23,  1 ),
   ( 2, 16,  1 ),
   ( 3, 17,  1 ),
   ( 4, 18,  1 ),
   ( 5, 19,  1 ),
   ( 6, 22,  1 ),
   ( 7, 23,  1 ),
   ( 8, 16,  1 ),
   ( 9, 17,  1 ),
   (10, 18,  1 ),
   (11, 19,  1 ),
   (12, 22,  1 ),
   (13, 23,  1 ),
   (14, 15,  1 ),
   (14, 24,  2 ),
   (15, 16,  1 ),
   (15, 21,  1 ),
   (15, 22,  1 ),
   (16, 19,  1 ),
   (17, 18,  1 ),
   (17, 19,  1 ),
   (18, 23,  1 ),
   (20, 22,  1 ),
   ]],
'MET': [
   { ### names ###
   '1HE' :0, 'HE1' :0, 
   '1H'  :1, '1HT' :1, 'H1'  :1, 'HT1' :1, 
   '2HB' :2, 'HB2' :2, 
   '2HE' :3, 'HE2' :3, 
   '2HG' :4, 'HG2' :4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '1HB' :6, '3HB' :6, 'HB1' :6, 'HB3' :6, 
   '3HE' :7, 'HE3' :7, 
   '1HG' :8, '3HG' :8, 'HG1' :8, 'HG3' :8, 
   '3H'  :9, '3HT' :9, 'H3'  :9, 'HT3' :9, 
   'C'   :10, 
   'CA'  :11, 
   'CB'  :12, 
   'CE'  :13, 
   'CG'  :14, 
   'H'   :15, 'HN'  :15, 
   'HA'  :16, 'HA2' :16, 
   'N'   :17, 
   'O'   :18, 'O1'  :18, 'OT1' :18, 
   'O2'  :19, 'OT'  :19, 'OT2' :19, 'OXT' :19, 
   'SD'  :20, 
   },
   [ ### bonds ###
   ( 0, 13,  1 ),
   ( 1, 17,  1 ),
   ( 2, 12,  1 ),
   ( 3, 13,  1 ),
   ( 4, 14,  1 ),
   ( 5, 17,  1 ),
   ( 6, 12,  1 ),
   ( 7, 13,  1 ),
   ( 8, 14,  1 ),
   ( 9, 17,  1 ),
   (10, 11,  1 ),
   (10, 18,  2 ),
   (11, 12,  1 ),
   (11, 16,  1 ),
   (11, 17,  1 ),
   (12, 14,  1 ),
   (13, 20,  1 ),
   (14, 20,  1 ),
   (15, 17,  1 ),
   ]],
'NME': [
   { ### names ###
   '1HA' :0, '1HH3':0, 'H02' :0, 'HH31':0, 
   '2HA' :1, '2HH3':1, 'H03' :1, 'HH32':1, 
   '3HA' :2, '3HH3':2, 'H04' :2, 'HH33':2, 
   'C01' :3, 'CA'  :3, 'CH3' :3, 
   'H'   :4, 'H01' :4, 'HN'  :4, 
   'N'   :5, 'N01' :5, 
   },
   [ ### bonds ###
   ( 0,  3,  1 ),
   ( 1,  3,  1 ),
   ( 2,  3,  1 ),
   ( 3,  5,  1 ),
   ( 4,  5,  1 ),
   ]],
'PHE': [
   { ### names ###
   '1HD' :0, 'HD1' :0, 
   '1HE' :1, 'HE1' :1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD' :4, 'HD2' :4, 
   '2HE' :5, 'HE2' :5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '1HB' :7, '3HB' :7, 'HB1' :7, 'HB3' :7, 
   '3H'  :8, '3HT' :8, 'H3'  :8, 'HT3' :8, 
   'C'   :9, 
   'CA'  :10, 
   'CB'  :11, 
   'CD1' :12, 
   'CD2' :13, 
   'CE1' :14, 
   'CE2' :15, 
   'CG'  :16, 
   'CZ'  :17, 
   'H'   :18, 'HN'  :18, 
   'HA'  :19, 'HA2' :19, 
   'HZ'  :20, 
   'N'   :21, 
   'O'   :22, 'O1'  :22, 'OT1' :22, 
   'O2'  :23, 'OT'  :23, 'OT2' :23, 'OXT' :23, 
   },
   [ ### bonds ###
   ( 0, 12,  1 ),
   ( 1, 14,  1 ),
   ( 2, 21,  1 ),
   ( 3, 11,  1 ),
   ( 4, 13,  1 ),
   ( 5, 15,  1 ),
   ( 6, 21,  1 ),
   ( 7, 11,  1 ),
   ( 8, 21,  1 ),
   ( 9, 10,  1 ),
   ( 9, 22,  2 ),
   (10, 11,  1 ),
   (10, 19,  1 ),
   (10, 21,  1 ),
   (11, 16,  1 ),
   (12, 14,  1 ),
   (12, 16,  2 ),
   (13, 15,  2 ),
   (13, 16,  1 ),
   (14, 17,  2 ),
   (15, 17,  1 ),
   (17, 20,  1 ),
   (18, 21,  1 ),
   ]],
'PRO': [
   { ### names ###
   '2H'  :0, 'H2'  :0, 
   '2HB' :1, 'HB2' :1, 
   '2HD' :2, 'HD2' :2, 
   '2HG' :3, 'HG2' :3, 
   '1H'  :4, '3H'  :4, 'H3'  :4, 
   '1HB' :5, '3HB' :5, 'HB1' :5, 'HB3' :5, 
   '1HD' :6, '3HD' :6, 'HD1' :6, 'HD3' :6, 
   '1HG' :7, '3HG' :7, 'HG1' :7, 'HG3' :7, 
   'C'   :8, 
   'CA'  :9, 
   'CB'  :10, 
   'CD'  :11, 
   'CG'  :12, 
   'HA'  :13, 
   'N'   :14, 
   'O'   :15, 'O1'  :15, 'OT1' :15, 
   'O2'  :16, 'OT'  :16, 'OT2' :16, 'OXT' :16, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1, 10,  1 ),
   ( 2, 11,  1 ),
   ( 3, 12,  1 ),
   ( 4, 14,  1 ),
   ( 5, 10,  1 ),
   ( 6, 11,  1 ),
   ( 7, 12,  1 ),
   ( 8,  9,  1 ),
   ( 8, 15,  2 ),
   ( 9, 10,  1 ),
   ( 9, 13,  1 ),
   ( 9, 14,  1 ),
   (10, 12,  1 ),
   (11, 12,  1 ),
   (11, 14,  1 ),
   ]],
'SER': [
   { ### names ###
   '1H'  :0, '1HT' :0, 'H1'  :0, 'HT1' :0, 
   '2HB' :1, 'HB2' :1, 
   '2H'  :2, '2HT' :2, 'H2'  :2, 'HT2' :2, 
   '1HB' :3, '3HB' :3, 'HB1' :3, 'HB3' :3, 
   '3H'  :4, '3HT' :4, 'H3'  :4, 'HT3' :4, 
   'C'   :5, 
   'CA'  :6, 
   'CB'  :7, 
   'H'   :8, 'HN'  :8, 
   'HA'  :9, 'HA2' :9, 
   'HG'  :10, 'HG1' :10, 
   'N'   :11, 
   'O'   :12, 'O1'  :12, 'OT1' :12, 
   'OG'  :13, 
   'O2'  :14, 'OT'  :14, 'OT2' :14, 'OXT' :14, 
   },
   [ ### bonds ###
   ( 0, 11,  1 ),
   ( 1,  7,  1 ),
   ( 2, 11,  1 ),
   ( 3,  7,  1 ),
   ( 4, 11,  1 ),
   ( 5,  6,  1 ),
   ( 5, 12,  2 ),
   ( 6,  7,  1 ),
   ( 6,  9,  1 ),
   ( 6, 11,  1 ),
   ( 7, 13,  1 ),
   ( 8, 11,  1 ),
   (10, 13,  1 ),
   ]],
'THR': [
   { ### names ###
   '1HG' :0, 'HG1' :0, 
   '1HG2':1, 'HG21':1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HG2':3, 'HG22':3, 
   '2H'  :4, '2HT' :4, 'H2'  :4, 'HT2' :4, 
   '3HG2':5, 'HG23':5, 
   '3H'  :6, '3HT' :6, 'H3'  :6, 'HT3' :6, 
   'C'   :7, 
   'CA'  :8, 
   'CB'  :9, 
   'CG2' :10, 
   'H'   :11, 'HN'  :11, 
   'HA'  :12, 'HA2' :12, 
   'HB'  :13, 
   'N'   :14, 
   'O'   :15, 'O1'  :15, 'OT1' :15, 
   'OG1' :16, 
   'O2'  :17, 'OT'  :17, 'OT2' :17, 'OXT' :17, 
   },
   [ ### bonds ###
   ( 0, 16,  1 ),
   ( 1, 10,  1 ),
   ( 2, 14,  1 ),
   ( 3, 10,  1 ),
   ( 4, 14,  1 ),
   ( 5, 10,  1 ),
   ( 6, 14,  1 ),
   ( 7,  8,  1 ),
   ( 7, 15,  2 ),
   ( 8,  9,  1 ),
   ( 8, 12,  1 ),
   ( 8, 14,  1 ),
   ( 9, 10,  1 ),
   ( 9, 13,  1 ),
   ( 9, 16,  1 ),
   (11, 14,  1 ),
   ]],
'TRP': [
   { ### names ###
   '1HD' :0, 'HD1' :0, 
   '1HE' :1, 'HE1' :1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HH' :4, 'HH2' :4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '2HZ' :6, 'HZ2' :6, 
   '1HB' :7, '3HB' :7, 'HB1' :7, 'HB3' :7, 
   '3HE' :8, 'HE3' :8, 
   '3H'  :9, '3HT' :9, 'H3'  :9, 'HT3' :9, 
   '1HZ' :10, '3HZ' :10, 'HZ3' :10, 
   'C'   :11, 
   'CA'  :12, 
   'CB'  :13, 
   'CD1' :14, 
   'CD2' :15, 
   'CE2' :16, 
   'CE3' :17, 
   'CG'  :18, 
   'CH2' :19, 
   'CZ2' :20, 
   'CZ3' :21, 
   'H'   :22, 'HN'  :22, 
   'HA'  :23, 'HA2' :23, 
   'N'   :24, 
   'NE1' :25, 
   'O'   :26, 'O1'  :26, 'OT1' :26, 
   'O2'  :27, 'OT'  :27, 'OT2' :27, 'OXT' :27, 
   },
   [ ### bonds ###
   ( 0, 14,  1 ),
   ( 1, 25,  1 ),
   ( 2, 24,  1 ),
   ( 3, 13,  1 ),
   ( 4, 19,  1 ),
   ( 5, 24,  1 ),
   ( 6, 20,  1 ),
   ( 7, 13,  1 ),
   ( 8, 17,  1 ),
   ( 9, 24,  1 ),
   (10, 21,  1 ),
   (11, 12,  1 ),
   (11, 26,  2 ),
   (12, 13,  1 ),
   (12, 23,  1 ),
   (12, 24,  1 ),
   (13, 18,  1 ),
   (14, 18,  2 ),
   (14, 25,  1 ),
   (15, 16,  2 ),
   (15, 17,  1 ),
   (15, 18,  1 ),
   (16, 20,  1 ),
   (16, 25,  1 ),
   (17, 21,  2 ),
   (19, 20,  2 ),
   (19, 21,  1 ),
   (22, 24,  1 ),
   ]],
'TYR': [
   { ### names ###
   '1HD' :0, 'HD1' :0, 
   '1HE' :1, 'HE1' :1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HB' :3, 'HB2' :3, 
   '2HD' :4, 'HD2' :4, 
   '2HE' :5, 'HE2' :5, 
   '2H'  :6, '2HT' :6, 'H2'  :6, 'HT2' :6, 
   '1HB' :7, '3HB' :7, 'HB1' :7, 'HB3' :7, 
   '3H'  :8, '3HT' :8, 'H3'  :8, 'HT3' :8, 
   'C'   :9, 
   'CA'  :10, 
   'CB'  :11, 
   'CD1' :12, 
   'CD2' :13, 
   'CE1' :14, 
   'CE2' :15, 
   'CG'  :16, 
   'CZ'  :17, 
   'H'   :18, 'HN'  :18, 
   'HA'  :19, 'HA2' :19, 
   'HH'  :20, 
   'N'   :21, 
   'O'   :22, 'O1'  :22, 'OT1' :22, 
   'OH'  :23, 
   'O2'  :24, 'OT'  :24, 'OT2' :24, 'OXT' :24, 
   },
   [ ### bonds ###
   ( 0, 12,  1 ),
   ( 1, 14,  1 ),
   ( 2, 21,  1 ),
   ( 3, 11,  1 ),
   ( 4, 13,  1 ),
   ( 5, 15,  1 ),
   ( 6, 21,  1 ),
   ( 7, 11,  1 ),
   ( 8, 21,  1 ),
   ( 9, 10,  1 ),
   ( 9, 22,  2 ),
   (10, 11,  1 ),
   (10, 19,  1 ),
   (10, 21,  1 ),
   (11, 16,  1 ),
   (12, 14,  1 ),
   (12, 16,  2 ),
   (13, 15,  2 ),
   (13, 16,  1 ),
   (14, 17,  2 ),
   (15, 17,  1 ),
   (17, 23,  1 ),
   (18, 21,  1 ),
   (20, 23,  1 ),
   ]],
'VAL': [
   { ### names ###
   '1HG1':0, 'HG11':0, 
   '1HG2':1, 'HG21':1, 
   '1H'  :2, '1HT' :2, 'H1'  :2, 'HT1' :2, 
   '2HG1':3, 'HG12':3, 
   '2HG2':4, 'HG22':4, 
   '2H'  :5, '2HT' :5, 'H2'  :5, 'HT2' :5, 
   '3HG1':6, 'HG13':6, 
   '3HG2':7, 'HG23':7, 
   '3H'  :8, '3HT' :8, 'H3'  :8, 'HT3' :8, 
   'C'   :9, 
   'CA'  :10, 
   'CB'  :11, 
   'CG1' :12, 
   'CG2' :13, 
   'H'   :14, 'HN'  :14, 
   'HA'  :15, 'HA2' :15, 
   'HB'  :16, 
   'N'   :17, 
   'O'   :18, 'O1'  :18, 'OT1' :18, 
   'O2'  :19, 'OT'  :19, 'OT2' :19, 'OXT' :19, 
   },
   [ ### bonds ###
   ( 0, 12,  1 ),
   ( 1, 13,  1 ),
   ( 2, 17,  1 ),
   ( 3, 12,  1 ),
   ( 4, 13,  1 ),
   ( 5, 17,  1 ),
   ( 6, 12,  1 ),
   ( 7, 13,  1 ),
   ( 8, 17,  1 ),
   ( 9, 10,  1 ),
   ( 9, 18,  2 ),
   (10, 11,  1 ),
   (10, 15,  1 ),
   (10, 17,  1 ),
   (11, 12,  1 ),
   (11, 13,  1 ),
   (11, 16,  1 ),
   (14, 17,  1 ),
   ]],
}
