/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIconSize
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 24;
    }

    @Override
    public int getDataSize() {
        return XIconSize.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIconSize(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XIconSize() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIconSize.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_min_width() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_min_width(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public int get_min_height() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_min_height(int v) {
        log.finest("");
        Native.putInt(this.pData + 4L, v);
    }

    public int get_max_width() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_max_width(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public int get_max_height() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_max_height(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public int get_width_inc() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_width_inc(int v) {
        log.finest("");
        Native.putInt(this.pData + 16L, v);
    }

    public int get_height_inc() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_height_inc(int v) {
        log.finest("");
        Native.putInt(this.pData + 20L, v);
    }

    @Override
    String getName() {
        return "XIconSize";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(240);
        ret.append("min_width = ").append(this.get_min_width()).append(", ");
        ret.append("min_height = ").append(this.get_min_height()).append(", ");
        ret.append("max_width = ").append(this.get_max_width()).append(", ");
        ret.append("max_height = ").append(this.get_max_height()).append(", ");
        ret.append("width_inc = ").append(this.get_width_inc()).append(", ");
        ret.append("height_inc = ").append(this.get_height_inc()).append(", ");
        return ret.toString();
    }
}

