/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.InciteTradeItem;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;
import org.w3c.dom.Element;

public class DiplomaticTrade
extends FreeColObject {
    private final Game game;
    private Player sender;
    private Player recipient;
    private TradeContext context;
    private TradeStatus status;
    private final List<TradeItem> items = new ArrayList<TradeItem>();
    private int version;
    private static final String CONTEXT_TAG = "context";
    private static final String RECIPIENT_TAG = "recipient";
    private static final String SENDER_TAG = "sender";
    private static final String STATUS_TAG = "status";
    private static final String VERSION_TAG = "version";

    public DiplomaticTrade(Game game, TradeContext context, Player sender, Player recipient, List<TradeItem> items, int version) {
        this.setId("");
        this.game = game;
        this.context = context;
        this.sender = sender;
        this.recipient = recipient;
        this.status = TradeStatus.PROPOSE_TRADE;
        this.items.clear();
        if (items != null) {
            this.items.addAll(items);
        }
        this.version = version;
    }

    public DiplomaticTrade(Game game, Element element) {
        this.game = game;
        this.readFromXMLElement(element);
    }

    public TradeContext getContext() {
        return this.context;
    }

    public TradeStatus getStatus() {
        return this.status;
    }

    public void setStatus(TradeStatus status) {
        this.status = status;
    }

    public final Player getSender() {
        return this.sender;
    }

    public final void setSender(Player newSender) {
        this.sender = newSender;
    }

    public final Player getRecipient() {
        return this.recipient;
    }

    public final void setRecipient(Player newRecipient) {
        this.recipient = newRecipient;
    }

    public Player getOtherPlayer(Player player) {
        return this.sender == player ? this.recipient : this.sender;
    }

    public StringTemplate getSendMessage(Player player, Settlement settlement) {
        return StringTemplate.template("model.diplomaticTrade.send." + this.getContext().getKey()).addStringTemplate("%nation%", settlement.getOwner().getNationLabel()).addStringTemplate("%settlement%", settlement.getLocationLabelFor(player));
    }

    public StringTemplate getReceiveMessage(Player player) {
        return StringTemplate.template("model.diplomaticTrade.receive." + this.getContext().getKey()).addStringTemplate("%nation%", player.getNationLabel());
    }

    public void add(TradeItem newItem) {
        if (newItem.isUnique()) {
            this.removeType(newItem.getClass());
        }
        this.items.add(newItem);
    }

    public void remove(TradeItem newItem) {
        this.items.remove(newItem);
    }

    public void remove(int index) {
        this.items.remove(index);
    }

    public void removeType(Class<? extends TradeItem> itemClass) {
        Iterator<TradeItem> itemIterator = this.items.iterator();
        while (itemIterator.hasNext()) {
            if (itemIterator.next().getClass() != itemClass) continue;
            itemIterator.remove();
        }
    }

    public void clear() {
        this.items.clear();
    }

    public final List<TradeItem> getTradeItems() {
        return this.items;
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Iterator<TradeItem> iterator() {
        return this.items.iterator();
    }

    public List<TradeItem> getItemsGivenBy(Player player) {
        return this.items.stream().filter(ti -> ti.getSource() == player).collect(Collectors.toList());
    }

    public Stance getStance() {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof StanceTradeItem);
        return ti == null ? null : ti.getStance();
    }

    public List<Colony> getColoniesGivenBy(Player player) {
        ArrayList<Colony> colonyList = new ArrayList<Colony>();
        for (TradeItem ti : this.items) {
            if (!(ti instanceof ColonyTradeItem) || player != ti.getSource()) continue;
            colonyList.add(ti.getColony(player.getGame()));
        }
        return colonyList;
    }

    public int getGoldGivenBy(Player player) {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof GoldTradeItem && player == i.getSource());
        return ti == null ? -1 : ti.getGold();
    }

    public List<Goods> getGoodsGivenBy(Player player) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (TradeItem ti : this.items) {
            if (!(ti instanceof GoodsTradeItem) || player != ti.getSource()) continue;
            goodsList.add(ti.getGoods());
        }
        return goodsList;
    }

    public Player getVictim() {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof InciteTradeItem);
        return ti == null ? null : ti.getVictim();
    }

    public List<Unit> getUnitsGivenBy(Player player) {
        ArrayList<Unit> unitList = new ArrayList<Unit>();
        for (TradeItem ti : this.items) {
            if (!(ti instanceof UnitTradeItem) || player != ti.getSource()) continue;
            unitList.add(ti.getUnit());
        }
        return unitList;
    }

    public int getVersion() {
        return this.version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(CONTEXT_TAG, this.context);
        xw.writeAttribute(SENDER_TAG, this.sender);
        xw.writeAttribute(RECIPIENT_TAG, this.recipient);
        xw.writeAttribute(STATUS_TAG, this.status);
        xw.writeAttribute(VERSION_TAG, this.version);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TradeItem item : this.items) {
            item.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.context = xr.getAttribute(CONTEXT_TAG, TradeContext.class, null);
        this.sender = xr.getAttribute(this.game, SENDER_TAG, Player.class, (Player)null);
        this.recipient = xr.getAttribute(this.game, RECIPIENT_TAG, Player.class, (Player)null);
        this.status = xr.getAttribute(STATUS_TAG, TradeStatus.class, TradeStatus.REJECT_TRADE);
        this.version = xr.getAttribute(VERSION_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.items.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (ColonyTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new ColonyTradeItem(this.game, xr));
        } else if (GoldTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new GoldTradeItem(this.game, xr));
        } else if (GoodsTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new GoodsTradeItem(this.game, xr));
        } else if (InciteTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new InciteTradeItem(this.game, xr));
        } else if (StanceTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new StanceTradeItem(this.game, xr));
        } else if (UnitTradeItem.getXMLElementTagName().equals(tag)) {
            this.add(new UnitTradeItem(this.game, xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("[").append(this.getId()).append(" ").append((Object)this.context).append(" ").append((Object)this.status).append(" from=").append(this.sender.getId()).append(" to=").append(this.recipient.getId()).append(" version=").append(this.getVersion()).append(" [");
        for (TradeItem item : this.getTradeItems()) {
            sb.append(" ").append(item);
        }
        sb.append(" ]]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return DiplomaticTrade.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "diplomaticTrade";
    }

    public static enum TradeStatus {
        PROPOSE_TRADE,
        ACCEPT_TRADE,
        REJECT_TRADE;

    }

    public static enum TradeContext {
        CONTACT,
        DIPLOMATIC,
        TRADE,
        TRIBUTE;


        public String getKey() {
            return StringUtils.getEnumKey(this);
        }
    }
}

