/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class PrivateerMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PrivateerMission.class.getName());
    private static final String tag = "AI privateer";
    private Location target;
    private static final String TARGET_TAG = "target";

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public int getDistanceToTarget() {
        return this.target == null || this.target.getTile() == null || !this.getUnit().hasTile() ? 1000000 : this.getUnit().getTile().getDistanceTo(this.target.getTile());
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Unit other;
        if (path == null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Location loc = path.getLastNode().getLocation();
        Settlement settlement = loc.getSettlement();
        Tile tile = loc.getTile();
        Unit unit2 = other = tile == null ? null : tile.getDefendingUnit(unit);
        return loc instanceof Europe ? loc : (other != null && PrivateerMission.invalidUnitReason(aiUnit, other) == null ? other : (settlement != null && PrivateerMission.invalidTargetReason(settlement, owner) == null ? settlement : null));
    }

    private static int scoreUnit(AIUnit aiUnit, Unit defender) {
        CombatModel.CombatOdds co;
        Unit attacker = aiUnit.getUnit();
        int value = 100;
        value += defender.getVisibleGoodsCount() * 200;
        if (defender.isOffensiveUnit() && (co = attacker.getGame().getCombatModel().calculateCombatOdds(attacker, defender)) != null) {
            value = (int)((double)value + (co.win - 0.5) * 200.0);
        }
        return value;
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = PrivateerMission.extractTarget(aiUnit, path);
        if (loc instanceof Europe || loc instanceof Colony) {
            return 1000 / (path.getTotalTurns() + 1);
        }
        if (loc instanceof Unit) {
            return PrivateerMission.scoreUnit(aiUnit, (Unit)loc) / (path.getTotalTurns() + 1);
        }
        if (loc instanceof Tile) {
            return 50 / (path.getTotalTurns() + 1);
        }
        return Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value = PrivateerMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (PrivateerMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        return unit.search(start, PrivateerMission.getGoalDecider(aiUnit, deferOK), CostDeciders.avoidIllegal(), range, null);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = PrivateerMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? PrivateerMission.extractTarget(aiUnit, path) : null;
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = PrivateerMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.isCarrier() ? "unit-not-a-carrier" : (!unit.isOffensiveUnit() ? "unit-not-offensive" : (!unit.isEmpty() || !unit.getCompactGoods().isEmpty() ? "unit-has-cargo" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return settlement instanceof Colony ? PrivateerMission.invalidTargetReason(settlement, aiUnit.getUnit().getOwner()) : "target-invalid";
    }

    private static String invalidUnitReason(AIUnit aiUnit, Unit unit) {
        String reason;
        Player player = aiUnit.getUnit().getOwner();
        boolean pirate = aiUnit.getUnit().hasAbility("model.ability.piracy");
        return unit == null ? "target-invalid" : (!unit.isNaval() ? "privateer-ignores-land-unit" : (player.owns(unit) ? "target-ownership" : ((reason = PrivateerMission.invalidAttackReason(aiUnit, unit.getOwner())) != null ? reason : (PrivateerMission.scoreUnit(aiUnit, unit) <= 0 ? "privateer-avoids-trouble" : null))));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return PrivateerMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        Player owner = aiUnit.getUnit().getOwner();
        String reason = PrivateerMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().isInEurope() ? null : (loc == null ? null : (loc instanceof Europe ? PrivateerMission.invalidTargetReason(loc, owner) : (loc instanceof Settlement ? PrivateerMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Unit ? PrivateerMission.invalidUnitReason(aiUnit, (Unit)loc) : (loc instanceof Tile ? (((Tile)loc).isExploredBy(owner) ? "tile-is-explored" : null) : "target-invalid"))))));
    }

    @Override
    public Location getTransportDestination() {
        return null;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Europe || target instanceof Unit) {
            this.target = target;
        }
    }

    @Override
    public Location findTarget() {
        return PrivateerMission.findTarget(this.getAIUnit(), 8, true);
    }

    @Override
    public String invalidReason() {
        return PrivateerMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        AIUnit aiUnit = this.getAIUnit();
        if (aiUnit.hasCargo()) {
            Mission m = this.getEuropeanAIPlayer().getTransportMission(aiUnit);
            return this.lbDone(lb, m != null, " transporting");
        }
        String reason = this.invalidReason();
        if (PrivateerMission.isTargetReason(reason)) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        if (unit.isInEurope()) {
            Settlement settlement = PrivateerMission.getBestSettlement(unit.getOwner());
            Tile tile = settlement != null ? settlement.getTile() : unit.getFullEntryLocation();
            unit.setDestination(tile);
            aiUnit.moveToAmerica();
        }
        if (unit.isAtSea()) {
            return this.lbAt(lb);
        }
        Location newTarget = PrivateerMission.findTarget(aiUnit, 1, true);
        if (newTarget == null) {
            this.moveRandomlyTurn(tag);
            return this.lbAt(lb);
        }
        this.setTarget(newTarget);
        Unit.MoveType mt = this.travelToTarget(newTarget, null, lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_TILE: {
                this.moveRandomly(tag, null);
                return this.lbDodge(lb);
            }
            case ATTACK_UNIT: {
                Direction direction = unit.getTile().getDirection(this.getTarget().getTile());
                if (direction != null) {
                    AIMessage.askAttack(aiUnit, direction);
                    this.lbAttack(lb, this.getTarget());
                } else {
                    Location blocker = PrivateerMission.resolveBlockage(aiUnit, this.getTarget());
                    if (blocker instanceof Unit && PrivateerMission.scoreUnit(aiUnit, (Unit)blocker) > 0) {
                        AIMessage.askAttack(aiUnit, unit.getTile().getDirection(blocker.getTile()));
                        this.lbAttack(lb, blocker);
                    } else {
                        this.moveRandomlyTurn(tag);
                        lb.add(" avoiding ", blocker, ".");
                    }
                }
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        return this.lbAt(lb);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return PrivateerMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "privateerMission";
    }
}

