/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LowMemoryArrayList;
import com.inet.jortho.WordIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DictionaryFactory {
    private final Node root = new Node('\u0000');
    private char[] tree;
    private int size;

    public void loadWordList(URL uRL) throws IOException {
        this.loadWords(new WordIterator(uRL));
    }

    public void loadWords(Iterator<String> iterator) {
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null || string.length() <= 1) continue;
            this.add(string);
        }
    }

    public void add(String string) {
        Node node = this.root;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Node node2 = node.searchCharOrAdd(c);
            if (i == string.length() - 1) {
                node2.isWord = true;
                return;
            }
            node = node2;
        }
    }

    public Dictionary create() {
        this.tree = new char[10000];
        this.root.save(this);
        char[] cArray = new char[this.size];
        System.arraycopy(this.tree, 0, cArray, 0, this.size);
        this.tree = cArray;
        return new Dictionary(this.tree);
    }

    final void checkSize(int n) {
        if (n > this.tree.length) {
            char[] cArray = new char[Math.max(n, 2 * this.tree.length)];
            System.arraycopy(this.tree, 0, cArray, 0, this.size);
            this.tree = cArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node
    extends LowMemoryArrayList<Node> {
        private final char c;
        private boolean isWord;

        Node(char c) {
            this.c = c;
        }

        Node searchCharOrAdd(char c) {
            for (int i = 0; i < this.size(); ++i) {
                Node node = (Node)this.get(i);
                if (node.c < c) continue;
                if (node.c == c) {
                    return node;
                }
                node = new Node(c);
                this.add(i, node);
                return node;
            }
            Node node = new Node(c);
            this.add(node);
            return node;
        }

        int save(DictionaryFactory dictionaryFactory) {
            int n;
            int n2 = n = dictionaryFactory.size;
            int n3 = dictionaryFactory.size + this.size() * 3 + 1;
            dictionaryFactory.checkSize(n3);
            dictionaryFactory.size = n3;
            for (int i = 0; i < this.size(); ++i) {
                Node node = (Node)this.get(i);
                ((DictionaryFactory)dictionaryFactory).tree[n++] = node.c;
                int n4 = 0;
                if (node.size() != 0) {
                    n4 = node.save(dictionaryFactory);
                }
                if (node.isWord) {
                    n4 |= Integer.MIN_VALUE;
                }
                ((DictionaryFactory)dictionaryFactory).tree[n++] = (char)(n4 >> 16);
                ((DictionaryFactory)dictionaryFactory).tree[n++] = (char)n4;
            }
            ((DictionaryFactory)dictionaryFactory).tree[n] = 65535;
            return n2;
        }
    }
}

