/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.util.Collection;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

class SelectiveCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOG = Logging.getLogger(SelectiveCompiler.class);
    private final IncrementalTaskInputs inputs;
    private final PreviousCompilation previousCompilation;
    private final CleaningJavaCompiler cleaningCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final IncrementalCompilationInitializer incrementalCompilationInitilizer;
    private final JarClasspathSnapshotProvider jarClasspathSnapshotProvider;

    public SelectiveCompiler(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, CleaningJavaCompiler cleaningCompiler, RecompilationSpecProvider recompilationSpecProvider, IncrementalCompilationInitializer compilationInitializer, JarClasspathSnapshotProvider jarClasspathSnapshotProvider) {
        this.inputs = inputs;
        this.previousCompilation = previousCompilation;
        this.cleaningCompiler = cleaningCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.incrementalCompilationInitilizer = compilationInitializer;
        this.jarClasspathSnapshotProvider = jarClasspathSnapshotProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(JavaCompileSpec spec) {
        Timer clock = Timers.startTimer();
        JarClasspathSnapshot jarClasspathSnapshot = this.jarClasspathSnapshotProvider.getJarClasspathSnapshot(spec.getCompileClasspath());
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(this.inputs, this.previousCompilation, jarClasspathSnapshot);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.info("Full recompilation is required because {}. Analysis took {}.", (Object)recompilationSpec.getFullRebuildCause(), (Object)clock.getElapsed());
            return this.cleaningCompiler.execute(spec);
        }
        Collection<String> classNames = recompilationSpec.getClassNames();
        this.incrementalCompilationInitilizer.initializeCompilation(spec, classNames);
        if (spec.getSource().isEmpty()) {
            LOG.info("None of the classes needs to be compiled! Analysis took {}. ", (Object)clock.getElapsed());
            return new RecompilationNotNecessary();
        }
        try {
            WorkResult workResult = this.cleaningCompiler.getCompiler().execute((CompileSpec)spec);
            return workResult;
        }
        finally {
            LOG.info("Incremental compilation of {} classes completed in {}.", (Object)classNames.size(), (Object)clock.getElapsed());
            LOG.debug("Recompiled classes {}", classNames);
        }
    }
}

