/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class CbButton
extends Canvas {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    Image image;
    String string;
    CbButtonCallback callback;
    int imode;
    int iwidth;
    int iheight;
    int pwidth;
    int pheight;
    int twidth;
    int theight;
    boolean inside;
    boolean indent;
    CbButtonGroup group;
    boolean selected;
    Color lc1 = Util.light_edge;
    Color lc2 = Util.body;
    Color lc3 = Util.dark_edge;
    Color hc1 = Util.light_edge_hi;
    Color hc2 = Util.body_hi;
    Color hc3 = Util.dark_edge_hi;

    public CbButton(Image image, CbButtonCallback cbButtonCallback) {
        this(image, null, 0, cbButtonCallback);
    }

    public CbButton(String string, CbButtonCallback cbButtonCallback) {
        this(null, string, 0, cbButtonCallback);
    }

    public CbButton(Image image, String string, int n, CbButtonCallback cbButtonCallback) {
        this.image = image;
        this.string = string;
        this.imode = n;
        this.callback = cbButtonCallback;
        if (this.image != null) {
            this.iwidth = Util.getWidth(this.image);
            this.iheight = Util.getHeight(this.image);
        }
        if (this.string != null) {
            this.twidth = Util.fnm.stringWidth(this.string);
            this.theight = Util.fnm.getHeight();
        }
        if (this.image != null && this.string != null) {
            switch (this.imode) {
                case 0: 
                case 1: {
                    this.pwidth = this.iwidth + this.twidth + 6;
                    this.pheight = Math.max(this.iheight, this.theight) + 4;
                    break;
                }
                case 2: 
                case 3: {
                    this.pwidth = Math.max(this.iwidth, this.twidth) + 4;
                    this.pheight = this.iheight + this.theight + 6;
                }
            }
        } else if (this.image != null) {
            this.pwidth = this.iwidth + 4;
            this.pheight = this.iheight + 4;
        } else if (this.string != null) {
            this.pwidth = this.twidth + 8;
            this.pheight = this.theight + 8;
        }
    }

    public void setGroup(CbButtonGroup cbButtonGroup) {
        this.group = cbButtonGroup;
        this.group.add(this);
    }

    public void select() {
        if (this.group != null) {
            this.group.select(this);
        }
    }

    public void setText(String string) {
        this.string = string;
        this.image = null;
        this.twidth = Util.fnm.stringWidth(this.string);
        this.theight = Util.fnm.getHeight();
        this.repaint();
    }

    public void setImage(Image image) {
        this.string = null;
        this.image = image;
        this.iwidth = Util.getWidth(this.image);
        this.iheight = Util.getHeight(this.image);
        this.repaint();
    }

    public void setImageText(Image image, String string, int n) {
        this.image = image;
        this.string = string;
        this.imode = n;
        this.twidth = Util.fnm.stringWidth(this.string);
        this.theight = Util.fnm.getHeight();
        this.iwidth = Util.getWidth(this.image);
        this.iheight = Util.getHeight(this.image);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Color color = this.inside ? this.hc1 : this.lc1;
        Color color2 = this.inside ? this.hc2 : this.lc2;
        Color color3 = this.inside ? this.hc3 : this.lc3;
        int n = this.size().width;
        int n2 = this.size().height;
        Color color4 = this.indent || this.selected ? color3 : color;
        Color color5 = this.indent || this.selected ? color : color3;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(color4);
        graphics.drawLine(0, 0, n - 2, 0);
        graphics.drawLine(0, 0, 0, n2 - 2);
        graphics.setColor(color5);
        graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
        graphics.drawLine(n - 1, n2 - 1, 1, n2 - 1);
        if (this.inside) {
            graphics.setColor(color5);
            graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
            graphics.drawLine(n - 2, n2 - 2, 2, n2 - 2);
        }
        graphics.setColor(color3);
        graphics.setFont(Util.f);
        if (this.image != null && this.string != null) {
            if (this.imode == 0) {
                Dimension dimension = this.imgSize(n - this.twidth - 6, n2 - 4);
                graphics.drawImage(this.image, (n - dimension.width - this.twidth - 2) / 2, (n2 - dimension.height) / 2, dimension.width, dimension.height, this);
                graphics.drawString(this.string, (n - dimension.width - this.twidth - 2) / 2 + dimension.width + 2, (n2 + this.theight - Util.fnm.getDescent()) / 2);
            } else if (this.imode != 1) {
                if (this.imode == 2) {
                    graphics.drawImage(this.image, (n - this.iwidth) / 2, (n2 - this.iheight - this.theight - 2) / 2, this.iwidth, this.iheight, this);
                    graphics.drawString(this.string, (n - this.twidth) / 2, this.iheight + Util.fnm.getHeight() + 2);
                } else if (this.imode == 3) {
                    // empty if block
                }
            }
        } else if (this.image != null) {
            Dimension dimension = this.imgSize(n - 4, n2 - 4);
            graphics.drawImage(this.image, (n - dimension.width) / 2, (n2 - dimension.height) / 2, dimension.width, dimension.height, this);
        } else if (this.string != null) {
            graphics.drawString(this.string, (n - this.twidth) / 2, (n2 + this.theight - Util.fnm.getDescent()) / 2);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.inside = true;
        this.repaint();
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.inside = false;
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.indent = true;
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.size().width && n2 < this.size().height) {
            if (this.callback != null) {
                this.callback.click(this);
            }
            this.select();
        }
        this.indent = false;
        this.repaint();
        return true;
    }

    public Dimension preferredSize() {
        return new Dimension(this.pwidth, this.pheight);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    private Dimension imgSize(int n, int n2) {
        float f;
        float f2 = (float)n / (float)this.iwidth;
        float f3 = (float)n2 / (float)this.iheight;
        float f4 = f = f2 < f3 ? f2 : f3;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return new Dimension((int)((float)this.iwidth * f), (int)((float)this.iheight * f));
    }
}

