/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class PutStoredScriptRequest
extends AcknowledgedRequest<PutStoredScriptRequest> {
    private String id;
    private String lang;
    private BytesReference content;
    private XContentType xContentType;

    public PutStoredScriptRequest() {
    }

    @Deprecated
    public PutStoredScriptRequest(String id, String lang, BytesReference content) {
        this(id, lang, content, XContentFactory.xContentType(content));
    }

    public PutStoredScriptRequest(String id, String lang, BytesReference content, XContentType xContentType) {
        this.id = id;
        this.lang = lang;
        this.content = content;
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError("must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id cannot contain '#' for stored script", validationException);
        }
        if (this.lang != null && this.lang.contains("#")) {
            validationException = ValidateActions.addValidationError("lang cannot contain '#' for stored script", validationException);
        }
        if (this.content == null) {
            validationException = ValidateActions.addValidationError("must specify code for stored script", validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public PutStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public PutStoredScriptRequest lang(String lang) {
        this.lang = lang;
        return this;
    }

    public BytesReference content() {
        return this.content;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    @Deprecated
    public PutStoredScriptRequest content(BytesReference content) {
        return this.content(content, XContentFactory.xContentType(content));
    }

    public PutStoredScriptRequest content(BytesReference content, XContentType xContentType) {
        this.content = content;
        this.xContentType = Objects.requireNonNull(xContentType);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.lang = in.readString();
        if (this.lang.isEmpty()) {
            this.lang = null;
        }
        this.id = in.readOptionalString();
        this.content = in.readBytesReference();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED) ? XContentType.readFrom(in) : XContentFactory.xContentType(this.content);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.lang == null ? "" : this.lang);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.content);
        if (out.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED)) {
            this.xContentType.writeTo(out);
        }
    }

    public String toString() {
        String source = "_na_";
        try {
            source = XContentHelper.convertToJson(this.content, false, this.xContentType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "put stored script {id [" + this.id + "]" + (this.lang != null ? ", lang [" + this.lang + "]" : "") + ", content [" + source + "]}";
    }
}

