/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.lookup.SourceLookup;

public class UpdateHelper
extends AbstractComponent {
    private final ScriptService scriptService;

    public UpdateHelper(Settings settings, ScriptService scriptService) {
        super(settings);
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard, LongSupplier nowInMillis) {
        GetResult getResult = indexShard.getService().get(request.type(), request.id(), new String[]{"_routing", "_parent", "_ttl", "_timestamp"}, true, request.version(), request.versionType(), FetchSourceContext.FETCH_SOURCE);
        return this.prepare(indexShard.shardId(), request, getResult, nowInMillis);
    }

    protected Result prepare(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        UpdateResponse update;
        Map updatedSourceAsMap;
        IndexRequest indexRequest;
        String parent;
        long getDateNS = System.nanoTime();
        if (!getResult.isExists()) {
            if (request.upsertRequest() == null && !request.docAsUpsert()) {
                throw new DocumentMissingException(shardId, request.type(), request.id());
            }
            IndexRequest indexRequest2 = request.docAsUpsert() ? request.doc() : request.upsertRequest();
            TimeValue ttl = indexRequest2.ttl();
            if (request.scriptedUpsert() && request.script() != null) {
                String scriptOpChoice;
                IndexRequest upsert = request.upsertRequest();
                Map<String, Object> upsertDoc = upsert.sourceAsMap();
                Map<String, Object> ctx = new HashMap<String, Object>(2);
                ctx.put("op", "create");
                ctx.put("_source", upsertDoc);
                ctx.put("_now", nowInMillis.getAsLong());
                ctx = this.executeScript(request.script, ctx);
                if (ttl == null) {
                    ttl = this.getTTLFromScriptContext(ctx);
                }
                if (!"create".equals(scriptOpChoice = (String)ctx.get("op"))) {
                    if (!"none".equals(scriptOpChoice)) {
                        this.logger.warn("Used upsert operation [{}] for script [{}], doing nothing...", (Object)scriptOpChoice, (Object)request.script.getIdOrCode());
                    }
                    UpdateResponse update2 = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
                    update2.setGetResult(getResult);
                    return new Result(update2, DocWriteResponse.Result.NOOP, upsertDoc, XContentType.JSON);
                }
                indexRequest2.source((Map)ctx.get("_source"));
            }
            ((IndexRequest)((IndexRequest)((IndexRequest)indexRequest2.index(request.index())).type(request.type()).id(request.id()).create(true).ttl(ttl).setRefreshPolicy(request.getRefreshPolicy())).routing(request.routing()).parent(request.parent()).timeout(request.timeout())).waitForActiveShards(request.waitForActiveShards());
            if (request.versionType() != VersionType.INTERNAL) {
                indexRequest2.version(request.version()).versionType(request.versionType());
            }
            return new Result(indexRequest2, DocWriteResponse.Result.CREATED, null, null);
        }
        long updateVersion = getResult.getVersion();
        if (request.versionType() != VersionType.INTERNAL) {
            assert (request.versionType() == VersionType.FORCE);
            updateVersion = request.version();
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(shardId, request.type(), request.id());
        }
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        String operation = null;
        String timestamp = null;
        TimeValue ttl = null;
        XContentType updateSourceContentType = sourceAndContent.v1();
        String routing = getResult.getFields().containsKey("_routing") ? getResult.field("_routing").getValue().toString() : null;
        String string = parent = getResult.getFields().containsKey("_parent") ? getResult.field("_parent").getValue().toString() : null;
        if (request.script() == null && request.doc() != null) {
            boolean noop;
            indexRequest = request.doc();
            updatedSourceAsMap = sourceAndContent.v2();
            if (indexRequest.ttl() != null) {
                ttl = indexRequest.ttl();
            }
            timestamp = indexRequest.timestamp();
            if (indexRequest.routing() != null) {
                routing = indexRequest.routing();
            }
            if (indexRequest.parent() != null) {
                parent = indexRequest.parent();
            }
            boolean bl = noop = !XContentHelper.update(updatedSourceAsMap, indexRequest.sourceAsMap(), request.detectNoop());
            if (request.detectNoop() && noop) {
                operation = "none";
            }
        } else {
            Map<String, Object> ctx = new HashMap<String, Object>(16);
            Long originalTtl = getResult.getFields().containsKey("_ttl") ? (Long)getResult.field("_ttl").getValue() : null;
            Long originalTimestamp = getResult.getFields().containsKey("_timestamp") ? (Long)getResult.field("_timestamp").getValue() : null;
            ctx.put("_index", getResult.getIndex());
            ctx.put("_type", getResult.getType());
            ctx.put("_id", getResult.getId());
            ctx.put("_version", getResult.getVersion());
            ctx.put("_routing", routing);
            ctx.put("_parent", parent);
            ctx.put("_timestamp", originalTimestamp);
            ctx.put("_ttl", originalTtl);
            ctx.put("_source", sourceAndContent.v2());
            ctx.put("_now", nowInMillis.getAsLong());
            ctx = this.executeScript(request.script, ctx);
            operation = (String)ctx.get("op");
            Object fetchedTimestamp = ctx.get("_timestamp");
            if (fetchedTimestamp != null) {
                timestamp = fetchedTimestamp.toString();
            } else if (originalTimestamp != null) {
                timestamp = originalTimestamp.toString();
            }
            ttl = this.getTTLFromScriptContext(ctx);
            updatedSourceAsMap = (Map)ctx.get("_source");
        }
        if (ttl == null) {
            Long ttlAsLong;
            Long l = ttlAsLong = getResult.getFields().containsKey("_ttl") ? (Long)getResult.field("_ttl").getValue() : null;
            if (ttlAsLong != null) {
                ttl = new TimeValue(ttlAsLong - TimeValue.nsecToMSec(System.nanoTime() - getDateNS));
            }
        }
        if (operation == null || "index".equals(operation)) {
            indexRequest = (IndexRequest)((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(updateVersion).versionType(request.versionType()).waitForActiveShards(request.waitForActiveShards())).timestamp(timestamp).ttl(ttl).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
            return new Result(indexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
        }
        if ("delete".equals(operation)) {
            DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)((DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(updateVersion).versionType(request.versionType()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
            return new Result(deleteRequest, DocWriteResponse.Result.DELETED, updatedSourceAsMap, updateSourceContentType);
        }
        if ("none".equals(operation)) {
            update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
            update.setGetResult(this.extractGetResult(request, request.index(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
            return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
        }
        this.logger.warn("Used update operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)request.script.getIdOrCode());
        update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
        return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
    }

    private Map<String, Object> executeScript(Script script, Map<String, Object> ctx) {
        try {
            if (this.scriptService != null) {
                ExecutableScript executableScript = this.scriptService.executable(script, ScriptContext.Standard.UPDATE);
                executableScript.setNextVar("ctx", ctx);
                executableScript.run();
                ctx = (Map)executableScript.unwrap(ctx);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to execute script", e);
        }
        return ctx;
    }

    private TimeValue getTTLFromScriptContext(Map<String, Object> ctx) {
        Object fetchedTTL = ctx.get("_ttl");
        if (fetchedTTL != null) {
            if (fetchedTTL instanceof Number) {
                return new TimeValue(((Number)fetchedTTL).longValue());
            }
            return TimeValue.parseTimeValue((String)fetchedTTL, null, "_ttl");
        }
        return null;
    }

    public GetResult extractGetResult(UpdateRequest request, String concreteIndex, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (!(request.fields() != null && request.fields().length != 0 || request.fetchSource() != null && request.fetchSource().fetchSource())) {
            return null;
        }
        SourceLookup sourceLookup = new SourceLookup();
        sourceLookup.setSource(source);
        boolean sourceRequested = false;
        HashMap<String, GetField> fields = null;
        if (request.fields() != null && request.fields().length > 0) {
            for (String field : request.fields()) {
                GetField getField;
                if (field.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                Object value = sourceLookup.extractValue(field);
                if (value == null) continue;
                if (fields == null) {
                    fields = new HashMap<String, GetField>(2);
                }
                if ((getField = (GetField)fields.get(field)) == null) {
                    getField = new GetField(field, new ArrayList<Object>(2));
                    fields.put(field, getField);
                }
                getField.getValues().add(value);
            }
        }
        BytesReference sourceFilteredAsBytes = sourceAsBytes;
        if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
            sourceRequested = true;
            if (request.fetchSource().includes().length > 0 || request.fetchSource().excludes().length > 0) {
                Object value = sourceLookup.filter(request.fetchSource());
                try {
                    int initialCapacity = Math.min(1024, sourceAsBytes.length());
                    BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
                    try (XContentBuilder builder = new XContentBuilder(sourceContentType.xContent(), streamOutput);){
                        builder.value(value);
                        sourceFilteredAsBytes = builder.bytes();
                    }
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
                }
            }
        }
        return new GetResult(concreteIndex, request.type(), request.id(), version, true, sourceRequested ? sourceFilteredAsBytes : null, fields);
    }

    public static class Result {
        private final Streamable action;
        private final DocWriteResponse.Result result;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Streamable action, DocWriteResponse.Result result, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.result = result;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Streamable> T action() {
            return (T)this.action;
        }

        public DocWriteResponse.Result getResponseResult() {
            return this.result;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }
}

