/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ParentChildrenBlockJoinQuery;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;

public final class InnerHitsContext {
    private final Map<String, BaseInnerHits> innerHits;

    public InnerHitsContext() {
        this.innerHits = new HashMap<String, BaseInnerHits>();
    }

    public InnerHitsContext(Map<String, BaseInnerHits> innerHits) {
        this.innerHits = Objects.requireNonNull(innerHits);
    }

    public Map<String, BaseInnerHits> getInnerHits() {
        return this.innerHits;
    }

    public void addInnerHitDefinition(BaseInnerHits innerHit) {
        if (this.innerHits.containsKey(innerHit.getName())) {
            throw new IllegalArgumentException("inner_hit definition with the name [" + innerHit.getName() + "] already exists. Use a different inner_hit name or define one explicitly");
        }
        this.innerHits.put(innerHit.getName(), innerHit);
    }

    public static final class ParentChildInnerHits
    extends BaseInnerHits {
        private final MapperService mapperService;
        private final DocumentMapper documentMapper;

        public ParentChildInnerHits(String name, SearchContext context, MapperService mapperService, DocumentMapper documentMapper) {
            super(name != null ? name : documentMapper.type(), context);
            this.mapperService = mapperService;
            this.documentMapper = documentMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            DocValuesTermsQuery hitQuery;
            if (this.isParentHit(hitContext.hit())) {
                String field = ParentFieldMapper.joinField(hitContext.hit().type());
                hitQuery = new DocValuesTermsQuery(field, new String[]{hitContext.hit().id()});
            } else if (this.isChildHit(hitContext.hit())) {
                DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hitContext.hit().type());
                String parentType = hitDocumentMapper.parentFieldMapper().type();
                SearchHitField parentField = hitContext.hit().field("_parent");
                if (parentField == null) {
                    throw new IllegalStateException("All children must have a _parent");
                }
                hitQuery = new TermQuery(new Term("_uid", Uid.createUid(parentType, (String)parentField.getValue())));
            } else {
                return Lucene.EMPTY_TOP_DOCS;
            }
            BooleanQuery q = new BooleanQuery.Builder().add(this.query(), BooleanClause.Occur.MUST).add((Query)hitQuery, BooleanClause.Occur.FILTER).add(this.documentMapper.typeFilter(), BooleanClause.Occur.FILTER).build();
            if (this.size() == 0) {
                int count = context.searcher().count((Query)q);
                return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
            }
            int topN = Math.min(this.from() + this.size(), context.searcher().getIndexReader().maxDoc());
            Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores()) : TopScoreDocCollector.create((int)topN);
            try {
                context.searcher().search((Query)q, (Collector)topDocsCollector);
            }
            finally {
                this.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            return topDocsCollector.topDocs(this.from(), this.size());
        }

        private boolean isParentHit(SearchHit hit) {
            return hit.type().equals(this.documentMapper.parentFieldMapper().type());
        }

        private boolean isChildHit(SearchHit hit) {
            DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.type());
            return this.documentMapper.type().equals(hitDocumentMapper.parentFieldMapper().type());
        }
    }

    public static final class NestedInnerHits
    extends BaseInnerHits {
        private final ObjectMapper parentObjectMapper;
        private final ObjectMapper childObjectMapper;

        public NestedInnerHits(String name, SearchContext context, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper) {
            super(name != null ? name : childObjectMapper.fullPath(), context);
            this.parentObjectMapper = parentObjectMapper;
            this.childObjectMapper = childObjectMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            TopScoreDocCollector topDocsCollector;
            Query rawParentFilter = this.parentObjectMapper == null ? Queries.newNonNestedFilter() : this.parentObjectMapper.nestedTypeFilter();
            BitSetProducer parentFilter = context.bitsetFilterCache().getBitSetProducer(rawParentFilter);
            Query childFilter = this.childObjectMapper.nestedTypeFilter();
            int parentDocId = hitContext.readerContext().docBase + hitContext.docId();
            BooleanQuery q = Queries.filtered(this.query(), (Query)new ParentChildrenBlockJoinQuery(parentFilter, childFilter, parentDocId));
            if (this.size() == 0) {
                return new TopDocs(context.searcher().count((Query)q), Lucene.EMPTY_SCORE_DOCS, 0.0f);
            }
            int topN = Math.min(this.from() + this.size(), context.searcher().getIndexReader().maxDoc());
            if (this.sort() != null) {
                try {
                    topDocsCollector = TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores());
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToElastic(e);
                }
            } else {
                topDocsCollector = TopScoreDocCollector.create((int)topN);
            }
            try {
                context.searcher().search((Query)q, (Collector)topDocsCollector);
            }
            finally {
                this.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            return topDocsCollector.topDocs(this.from(), this.size());
        }
    }

    public static abstract class BaseInnerHits
    extends SubSearchContext {
        private final String name;
        private InnerHitsContext childInnerHits;

        protected BaseInnerHits(String name, SearchContext context) {
            super(context);
            this.name = name;
        }

        public abstract TopDocs topDocs(SearchContext var1, FetchSubPhase.HitContext var2) throws IOException;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InnerHitsContext innerHits() {
            return this.childInnerHits;
        }

        public void setChildInnerHits(Map<String, BaseInnerHits> childInnerHits) {
            this.childInnerHits = new InnerHitsContext(childInnerHits);
        }
    }
}

