/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import org.elasticsearch.search.profile.aggregation.ProfilingLeafBucketCollector;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) throws IOException {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public boolean needsScores() {
        return this.delegate.needsScores();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        this.profileBreakdown.startTime(AggregationTimingType.BUILD_AGGREGATION);
        InternalAggregation result = this.delegate.buildAggregation(bucket);
        this.profileBreakdown.stopAndRecordTime();
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        return new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        this.profileBreakdown.startTime(AggregationTimingType.INITIALIZE);
        this.delegate.preCollection();
        this.profileBreakdown.stopAndRecordTime();
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        this.delegate.postCollection();
    }
}

