/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom_j.xtf.Ili2cUtility;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxException;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class XtfWriter
extends XtfWriterBase {
    public XtfWriter(OutputStreamWriter buffer, TransferDescription td) throws IoxException {
        super(buffer, Ili2cUtility.getIoxMappingTable(td), td.getLastModel().getIliVersion());
        this.setModels(this.buildModelList(td));
    }

    public XtfWriter(File outfile, TransferDescription td) throws IoxException {
        super(outfile, Ili2cUtility.getIoxMappingTable(td), td.getLastModel().getIliVersion());
        this.setModels(this.buildModelList(td));
    }

    public XtfWriter(OutputStream buffer, TransferDescription td) throws IoxException {
        super(buffer, Ili2cUtility.getIoxMappingTable(td), td.getLastModel().getIliVersion());
        this.setModels(this.buildModelList(td));
    }

    private XtfModel[] buildModelList(TransferDescription td) {
        ArrayList modelv = new ArrayList();
        for (Object modelo : td) {
            if (modelo instanceof PredefinedModel || !(modelo instanceof Model)) continue;
            modelv.add(modelo);
        }
        XtfModel[] ret = new XtfModel[modelv.size()];
        int i = 0;
        while (i < modelv.size()) {
            Model model = (Model)modelv.get(i);
            ret[i] = new XtfModel();
            ret[i].setName(model.getName());
            String version = model.getModelVersion();
            ret[i].setVersion(version == null ? "" : version);
            String issuer = model.getIssuer();
            ret[i].setUri(issuer == null ? "" : issuer);
            ++i;
        }
        return ret;
    }
}

