/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;

public class AllCategoryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private Map<String, String> i18nToStr = null;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.category"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.strength")};
    private PluginFactory pluginFactory;

    public AllCategoryTableModel(PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public void setPluginFactory(PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (object.toString().isEmpty()) break;
                this.setPluginCategoryThreshold(n, Plugin.AlertThreshold.valueOf(this.i18nToStr((String)object)));
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                if (object.toString().isEmpty()) break;
                this.setPluginCategoryStrength(n, Plugin.AttackStrength.valueOf(this.i18nToStr((String)object)));
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private String strToI18n(String string) {
        return Constant.messages.getString("ascan.policy.level." + string.toLowerCase());
    }

    private String i18nToStr(String string) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold enum_ : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
            for (Enum enum_ : Plugin.AttackStrength.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
        }
        return this.i18nToStr.get(string);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return Category.length();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = Category.getName(n);
                break;
            }
            case 1: {
                string = this.getPluginCategoryThreshold(n);
                break;
            }
            case 2: {
                string = this.getPluginCategoryStrength(n);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private String getPluginCategoryThreshold(int n) {
        Enum enum_ = null;
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != n) continue;
            if (enum_ == null) {
                enum_ = plugin.getAlertThreshold(true);
                continue;
            }
            if (enum_.equals((Object)plugin.getAlertThreshold(true))) continue;
            return "";
        }
        if (enum_ == null) {
            return "";
        }
        return this.strToI18n(enum_.name());
    }

    private String getPluginCategoryStrength(int n) {
        Enum enum_ = null;
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != n) continue;
            if (enum_ == null) {
                enum_ = plugin.getAttackStrength(true);
                continue;
            }
            if (enum_.equals((Object)plugin.getAttackStrength(true))) continue;
            return "";
        }
        if (enum_ == null) {
            return "";
        }
        return this.strToI18n(enum_.name());
    }

    private void setPluginCategoryThreshold(int n, Plugin.AlertThreshold alertThreshold) {
        boolean bl = !Plugin.AlertThreshold.OFF.equals((Object)alertThreshold);
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            String[] stringArray;
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != n || bl && (stringArray = plugin.getDependency()) != null && stringArray.length != 0 && !this.pluginFactory.hasAllDependenciesAvailable(plugin)) continue;
            plugin.setAlertThreshold(alertThreshold);
            plugin.setEnabled(bl);
        }
    }

    private void setPluginCategoryStrength(int n, Plugin.AttackStrength attackStrength) {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != n) continue;
            plugin.setAttackStrength(attackStrength);
        }
    }

    void setAllCategoryEnabled(boolean bl) {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            plugin.setEnabled(bl);
        }
        this.fireTableDataChanged();
    }

    boolean isAllCategoryEnabled() {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

