/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.FormBasedAuthenticationMethodType;
import org.zaproxy.zap.authentication.HttpAuthenticationMethodType;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.authentication.ScriptBasedAuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.AuthenticationAPI;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.authentication.PopupFlagLoggedInIndicatorMenu;
import org.zaproxy.zap.extension.authentication.PopupFlagLoggedOutIndicatorMenu;
import org.zaproxy.zap.extension.stdmenus.PopupContextMenuItemFactory;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionAuthentication
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final int EXTENSION_ORDER = 52;
    public static final String NAME = "ExtensionAuthentication";
    private static final Logger log = Logger.getLogger(ExtensionAuthentication.class);
    List<AuthenticationMethodType> authenticationMethodTypes;
    private Map<Integer, ContextAuthenticationPanel> contextPanelsMap = new HashMap<Integer, ContextAuthenticationPanel>();
    private PopupContextMenuItemFactory popupFlagLoggedInIndicatorMenuFactory;
    private PopupContextMenuItemFactory popupFlagLoggedOutIndicatorMenuFactory;
    AuthenticationAPI api;

    public ExtensionAuthentication() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(52);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedInIndicatorMenu());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoggedOutIndicatorMenu());
            this.getView().addContextPanelFactory(this);
        }
        this.loadAuthenticationMethodTypes(extensionHook);
        this.api = new AuthenticationAPI(this);
        extensionHook.addApiImplementor(this.api);
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextAuthenticationPanel contextAuthenticationPanel = this.contextPanelsMap.get(context.getIndex());
        if (contextAuthenticationPanel == null) {
            contextAuthenticationPanel = new ContextAuthenticationPanel(this, context);
            this.contextPanelsMap.put(context.getIndex(), contextAuthenticationPanel);
        }
        return contextAuthenticationPanel;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedInIndicatorMenu() {
        if (this.popupFlagLoggedInIndicatorMenuFactory == null) {
            this.popupFlagLoggedInIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204122L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String string) {
                    return new PopupFlagLoggedInIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedInIndicatorMenuFactory;
    }

    private PopupContextMenuItemFactory getPopupFlagLoggedOutIndicatorMenu() {
        if (this.popupFlagLoggedOutIndicatorMenuFactory == null) {
            this.popupFlagLoggedOutIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204123L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String string) {
                    return new PopupFlagLoggedOutIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagLoggedOutIndicatorMenuFactory;
    }

    private void loadAuthenticationMethodTypes(ExtensionHook extensionHook) {
        this.authenticationMethodTypes = new ArrayList<AuthenticationMethodType>();
        this.authenticationMethodTypes.add(new FormBasedAuthenticationMethodType());
        this.authenticationMethodTypes.add(new HttpAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ManualAuthenticationMethodType());
        this.authenticationMethodTypes.add(new ScriptBasedAuthenticationMethodType());
        for (AuthenticationMethodType authenticationMethodType : this.authenticationMethodTypes) {
            authenticationMethodType.hook(extensionHook);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded authentication method types: " + this.authenticationMethodTypes));
        }
    }

    public List<AuthenticationMethodType> getAuthenticationMethodTypes() {
        return this.authenticationMethodTypes;
    }

    public AuthenticationMethodType getAuthenticationMethodTypeForIdentifier(int n) {
        for (AuthenticationMethodType authenticationMethodType : this.getAuthenticationMethodTypes()) {
            if (authenticationMethodType.getUniqueIdentifier() != n) continue;
            return authenticationMethodType;
        }
        return null;
    }

    public URI getLoginRequestURIForContext(Context context) {
        if (!(context.getAuthenticationMethod() instanceof FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)) {
            return null;
        }
        FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethodType.FormBasedAuthenticationMethod)context.getAuthenticationMethod();
        try {
            return new URI(formBasedAuthenticationMethod.getLoginRequestURL(), false);
        }
        catch (NullPointerException | URIException throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            AuthenticationMethodType authenticationMethodType;
            List<String> list = session.getContextDataStrings(context.getIndex(), 200);
            if (list != null && list.size() > 0 && (authenticationMethodType = this.getAuthenticationMethodTypeForIdentifier(Integer.parseInt(list.get(0)))) != null) {
                List<String> list2;
                context.setAuthenticationMethod(authenticationMethodType.loadMethodFromSession(session, context.getIndex()));
                List<String> list3 = session.getContextDataStrings(context.getIndex(), 206);
                if (list3 != null && list3.size() > 0) {
                    context.getAuthenticationMethod().setLoggedInIndicatorPattern(list3.get(0));
                }
                if ((list2 = session.getContextDataStrings(context.getIndex(), 207)) != null && list2.size() > 0) {
                    context.getAuthenticationMethod().setLoggedOutIndicatorPattern(list2.get(0));
                }
            }
        }
        catch (DatabaseException databaseException) {
            log.error((Object)"Unable to load Authentication method.", (Throwable)databaseException);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            AuthenticationMethodType authenticationMethodType = context.getAuthenticationMethod().getType();
            session.setContextData(context.getIndex(), 200, Integer.toString(authenticationMethodType.getUniqueIdentifier()));
            if (context.getAuthenticationMethod().getLoggedInIndicatorPattern() != null) {
                session.setContextData(context.getIndex(), 206, context.getAuthenticationMethod().getLoggedInIndicatorPattern().toString());
            }
            if (context.getAuthenticationMethod().getLoggedOutIndicatorPattern() != null) {
                session.setContextData(context.getIndex(), 207, context.getAuthenticationMethod().getLoggedOutIndicatorPattern().toString());
            }
            authenticationMethodType.persistMethodToSession(session, context.getIndex(), context.getAuthenticationMethod());
        }
        catch (DatabaseException databaseException) {
            log.error((Object)"Unable to persist Authentication method.", (Throwable)databaseException);
        }
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context context) {
        this.contextPanelsMap.remove(context.getIndex());
    }

    @Override
    public void exportContextData(Context context, Configuration configuration) {
        configuration.setProperty("context.authentication.type", (Object)context.getAuthenticationMethod().getType().getUniqueIdentifier());
        if (context.getAuthenticationMethod().getLoggedInIndicatorPattern() != null) {
            configuration.setProperty("context.authentication.loggedin", (Object)context.getAuthenticationMethod().getLoggedInIndicatorPattern().toString());
        }
        if (context.getAuthenticationMethod().getLoggedOutIndicatorPattern() != null) {
            configuration.setProperty("context.authentication.loggedout", (Object)context.getAuthenticationMethod().getLoggedOutIndicatorPattern().toString());
        }
        context.getAuthenticationMethod().getType().exportData(configuration, context.getAuthenticationMethod());
    }

    @Override
    public void importContextData(Context context, Configuration configuration) throws ConfigurationException {
        context.setAuthenticationMethod(this.getAuthenticationMethodTypeForIdentifier(configuration.getInt("context.authentication.type")).createAuthenticationMethod(context.getIndex()));
        String string = configuration.getString("context.authentication.loggedin", "");
        if (string.length() > 0) {
            context.getAuthenticationMethod().setLoggedInIndicatorPattern(string);
        }
        if ((string = configuration.getString("context.authentication.loggedout", "")).length() > 0) {
            context.getAuthenticationMethod().setLoggedOutIndicatorPattern(string);
        }
        context.getAuthenticationMethod().getType().importData(configuration, context.getAuthenticationMethod());
    }
}

